<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$whatsapp_setup_view = new whatsapp_setup_view();

// Run the page
$whatsapp_setup_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$whatsapp_setup_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$whatsapp_setup->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fwhatsapp_setupview = currentForm = new ew.Form("fwhatsapp_setupview", "view");

// Form_CustomValidate event
fwhatsapp_setupview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fwhatsapp_setupview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fwhatsapp_setupview.lists["x_company[]"] = <?php echo $whatsapp_setup_view->company->Lookup->toClientList() ?>;
fwhatsapp_setupview.lists["x_company[]"].options = <?php echo JsonEncode($whatsapp_setup_view->company->lookupOptions()) ?>;
fwhatsapp_setupview.lists["x_operator"] = <?php echo $whatsapp_setup_view->operator->Lookup->toClientList() ?>;
fwhatsapp_setupview.lists["x_operator"].options = <?php echo JsonEncode($whatsapp_setup_view->operator->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$whatsapp_setup->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $whatsapp_setup_view->ExportOptions->render("body") ?>
<?php $whatsapp_setup_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $whatsapp_setup_view->showPageHeader(); ?>
<?php
$whatsapp_setup_view->showMessage();
?>
<form name="fwhatsapp_setupview" id="fwhatsapp_setupview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($whatsapp_setup_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $whatsapp_setup_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="whatsapp_setup">
<input type="hidden" name="modal" value="<?php echo (int)$whatsapp_setup_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($whatsapp_setup->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $whatsapp_setup_view->TableLeftColumnClass ?>"><span id="elh_whatsapp_setup_id"><?php echo $whatsapp_setup->id->caption() ?></span></td>
		<td data-name="id"<?php echo $whatsapp_setup->id->cellAttributes() ?>>
<span id="el_whatsapp_setup_id">
<span<?php echo $whatsapp_setup->id->viewAttributes() ?>>
<?php echo $whatsapp_setup->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($whatsapp_setup->mobile->Visible) { // mobile ?>
	<tr id="r_mobile">
		<td class="<?php echo $whatsapp_setup_view->TableLeftColumnClass ?>"><span id="elh_whatsapp_setup_mobile"><?php echo $whatsapp_setup->mobile->caption() ?></span></td>
		<td data-name="mobile"<?php echo $whatsapp_setup->mobile->cellAttributes() ?>>
<span id="el_whatsapp_setup_mobile">
<span<?php echo $whatsapp_setup->mobile->viewAttributes() ?>>
<?php echo $whatsapp_setup->mobile->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($whatsapp_setup->url->Visible) { // url ?>
	<tr id="r_url">
		<td class="<?php echo $whatsapp_setup_view->TableLeftColumnClass ?>"><span id="elh_whatsapp_setup_url"><?php echo $whatsapp_setup->url->caption() ?></span></td>
		<td data-name="url"<?php echo $whatsapp_setup->url->cellAttributes() ?>>
<span id="el_whatsapp_setup_url">
<span<?php echo $whatsapp_setup->url->viewAttributes() ?>>
<?php echo $whatsapp_setup->url->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($whatsapp_setup->Instance_id->Visible) { // Instance_id ?>
	<tr id="r_Instance_id">
		<td class="<?php echo $whatsapp_setup_view->TableLeftColumnClass ?>"><span id="elh_whatsapp_setup_Instance_id"><?php echo $whatsapp_setup->Instance_id->caption() ?></span></td>
		<td data-name="Instance_id"<?php echo $whatsapp_setup->Instance_id->cellAttributes() ?>>
<span id="el_whatsapp_setup_Instance_id">
<span<?php echo $whatsapp_setup->Instance_id->viewAttributes() ?>>
<?php echo $whatsapp_setup->Instance_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($whatsapp_setup->token->Visible) { // token ?>
	<tr id="r_token">
		<td class="<?php echo $whatsapp_setup_view->TableLeftColumnClass ?>"><span id="elh_whatsapp_setup_token"><?php echo $whatsapp_setup->token->caption() ?></span></td>
		<td data-name="token"<?php echo $whatsapp_setup->token->cellAttributes() ?>>
<span id="el_whatsapp_setup_token">
<span<?php echo $whatsapp_setup->token->viewAttributes() ?>>
<?php echo $whatsapp_setup->token->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($whatsapp_setup->company->Visible) { // company ?>
	<tr id="r_company">
		<td class="<?php echo $whatsapp_setup_view->TableLeftColumnClass ?>"><span id="elh_whatsapp_setup_company"><?php echo $whatsapp_setup->company->caption() ?></span></td>
		<td data-name="company"<?php echo $whatsapp_setup->company->cellAttributes() ?>>
<span id="el_whatsapp_setup_company">
<span<?php echo $whatsapp_setup->company->viewAttributes() ?>>
<?php echo $whatsapp_setup->company->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($whatsapp_setup->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $whatsapp_setup_view->TableLeftColumnClass ?>"><span id="elh_whatsapp_setup_operator"><?php echo $whatsapp_setup->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $whatsapp_setup->operator->cellAttributes() ?>>
<span id="el_whatsapp_setup_operator">
<span<?php echo $whatsapp_setup->operator->viewAttributes() ?>>
<?php echo $whatsapp_setup->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($whatsapp_setup->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $whatsapp_setup_view->TableLeftColumnClass ?>"><span id="elh_whatsapp_setup_datetime"><?php echo $whatsapp_setup->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $whatsapp_setup->datetime->cellAttributes() ?>>
<span id="el_whatsapp_setup_datetime">
<span<?php echo $whatsapp_setup->datetime->viewAttributes() ?>>
<?php echo $whatsapp_setup->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($whatsapp_setup->direct_whatsapp->Visible) { // direct_whatsapp ?>
	<tr id="r_direct_whatsapp">
		<td class="<?php echo $whatsapp_setup_view->TableLeftColumnClass ?>"><span id="elh_whatsapp_setup_direct_whatsapp"><?php echo $whatsapp_setup->direct_whatsapp->caption() ?></span></td>
		<td data-name="direct_whatsapp"<?php echo $whatsapp_setup->direct_whatsapp->cellAttributes() ?>>
<span id="el_whatsapp_setup_direct_whatsapp">
<span<?php echo $whatsapp_setup->direct_whatsapp->viewAttributes() ?>>
<?php echo $whatsapp_setup->direct_whatsapp->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($whatsapp_setup->whatsapp_message->Visible) { // whatsapp_message ?>
	<tr id="r_whatsapp_message">
		<td class="<?php echo $whatsapp_setup_view->TableLeftColumnClass ?>"><span id="elh_whatsapp_setup_whatsapp_message"><?php echo $whatsapp_setup->whatsapp_message->caption() ?></span></td>
		<td data-name="whatsapp_message"<?php echo $whatsapp_setup->whatsapp_message->cellAttributes() ?>>
<span id="el_whatsapp_setup_whatsapp_message">
<span<?php echo $whatsapp_setup->whatsapp_message->viewAttributes() ?>>
<?php echo $whatsapp_setup->whatsapp_message->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$whatsapp_setup_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$whatsapp_setup->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$whatsapp_setup_view->terminate();
?>