<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$wool_import_calculator_list = new wool_import_calculator_list();

// Run the page
$wool_import_calculator_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$wool_import_calculator_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$wool_import_calculator->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fwool_import_calculatorlist = currentForm = new ew.Form("fwool_import_calculatorlist", "list");
fwool_import_calculatorlist.formKeyCountName = '<?php echo $wool_import_calculator_list->FormKeyCountName ?>';

// Form_CustomValidate event
fwool_import_calculatorlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fwool_import_calculatorlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Form object for search

var fwool_import_calculatorlistsrch = currentSearchForm = new ew.Form("fwool_import_calculatorlistsrch");

// Validate function for search
fwool_import_calculatorlistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_rid");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($wool_import_calculator->rid->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fwool_import_calculatorlistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fwool_import_calculatorlistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
// Filters

fwool_import_calculatorlistsrch.filterList = <?php echo $wool_import_calculator_list->getFilterList() ?>;

// Init search panel as collapsed
fwool_import_calculatorlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$wool_import_calculator->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($wool_import_calculator_list->TotalRecs > 0 && $wool_import_calculator_list->ExportOptions->visible()) { ?>
<?php $wool_import_calculator_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($wool_import_calculator_list->ImportOptions->visible()) { ?>
<?php $wool_import_calculator_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($wool_import_calculator_list->SearchOptions->visible()) { ?>
<?php $wool_import_calculator_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($wool_import_calculator_list->FilterOptions->visible()) { ?>
<?php $wool_import_calculator_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$wool_import_calculator_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$wool_import_calculator->isExport() && !$wool_import_calculator->CurrentAction) { ?>
<form name="fwool_import_calculatorlistsrch" id="fwool_import_calculatorlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($wool_import_calculator_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fwool_import_calculatorlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="wool_import_calculator">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$wool_import_calculator_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$wool_import_calculator->RowType = ROWTYPE_SEARCH;

// Render row
$wool_import_calculator->resetAttributes();
$wool_import_calculator_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($wool_import_calculator->rid->Visible) { // rid ?>
	<div id="xsc_rid" class="ew-cell form-group">
		<label for="x_rid" class="ew-search-caption ew-label"><?php echo $wool_import_calculator->rid->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_rid" id="z_rid" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="wool_import_calculator" data-field="x_rid" name="x_rid" id="x_rid" size="30" placeholder="<?php echo HtmlEncode($wool_import_calculator->rid->getPlaceHolder()) ?>" value="<?php echo $wool_import_calculator->rid->EditValue ?>"<?php echo $wool_import_calculator->rid->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($wool_import_calculator_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($wool_import_calculator_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $wool_import_calculator_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($wool_import_calculator_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($wool_import_calculator_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($wool_import_calculator_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($wool_import_calculator_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $wool_import_calculator_list->showPageHeader(); ?>
<?php
$wool_import_calculator_list->showMessage();
?>
<?php if ($wool_import_calculator_list->TotalRecs > 0 || $wool_import_calculator->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($wool_import_calculator_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> wool_import_calculator">
<?php if (!$wool_import_calculator->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$wool_import_calculator->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($wool_import_calculator_list->Pager)) $wool_import_calculator_list->Pager = new PrevNextPager($wool_import_calculator_list->StartRec, $wool_import_calculator_list->DisplayRecs, $wool_import_calculator_list->TotalRecs, $wool_import_calculator_list->AutoHidePager) ?>
<?php if ($wool_import_calculator_list->Pager->RecordCount > 0 && $wool_import_calculator_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($wool_import_calculator_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $wool_import_calculator_list->pageUrl() ?>start=<?php echo $wool_import_calculator_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($wool_import_calculator_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $wool_import_calculator_list->pageUrl() ?>start=<?php echo $wool_import_calculator_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $wool_import_calculator_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($wool_import_calculator_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $wool_import_calculator_list->pageUrl() ?>start=<?php echo $wool_import_calculator_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($wool_import_calculator_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $wool_import_calculator_list->pageUrl() ?>start=<?php echo $wool_import_calculator_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $wool_import_calculator_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($wool_import_calculator_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $wool_import_calculator_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $wool_import_calculator_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $wool_import_calculator_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($wool_import_calculator_list->TotalRecs > 0 && (!$wool_import_calculator_list->AutoHidePageSizeSelector || $wool_import_calculator_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="wool_import_calculator">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($wool_import_calculator_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($wool_import_calculator_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($wool_import_calculator_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($wool_import_calculator_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($wool_import_calculator_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($wool_import_calculator->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $wool_import_calculator_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fwool_import_calculatorlist" id="fwool_import_calculatorlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($wool_import_calculator_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $wool_import_calculator_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="wool_import_calculator">
<div id="gmp_wool_import_calculator" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($wool_import_calculator_list->TotalRecs > 0 || $wool_import_calculator->isGridEdit()) { ?>
<table id="tbl_wool_import_calculatorlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$wool_import_calculator_list->RowType = ROWTYPE_HEADER;

// Render list options
$wool_import_calculator_list->renderListOptions();

// Render list options (header, left)
$wool_import_calculator_list->ListOptions->render("header", "left");
?>
<?php if ($wool_import_calculator->rid->Visible) { // rid ?>
	<?php if ($wool_import_calculator->sortUrl($wool_import_calculator->rid) == "") { ?>
		<th data-name="rid" class="<?php echo $wool_import_calculator->rid->headerCellClass() ?>"><div id="elh_wool_import_calculator_rid" class="wool_import_calculator_rid"><div class="ew-table-header-caption"><?php echo $wool_import_calculator->rid->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="rid" class="<?php echo $wool_import_calculator->rid->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $wool_import_calculator->SortUrl($wool_import_calculator->rid) ?>',2);"><div id="elh_wool_import_calculator_rid" class="wool_import_calculator_rid">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $wool_import_calculator->rid->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($wool_import_calculator->rid->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($wool_import_calculator->rid->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($wool_import_calculator->product_code->Visible) { // product_code ?>
	<?php if ($wool_import_calculator->sortUrl($wool_import_calculator->product_code) == "") { ?>
		<th data-name="product_code" class="<?php echo $wool_import_calculator->product_code->headerCellClass() ?>"><div id="elh_wool_import_calculator_product_code" class="wool_import_calculator_product_code"><div class="ew-table-header-caption"><?php echo $wool_import_calculator->product_code->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="product_code" class="<?php echo $wool_import_calculator->product_code->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $wool_import_calculator->SortUrl($wool_import_calculator->product_code) ?>',2);"><div id="elh_wool_import_calculator_product_code" class="wool_import_calculator_product_code">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $wool_import_calculator->product_code->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($wool_import_calculator->product_code->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($wool_import_calculator->product_code->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($wool_import_calculator->net_weight->Visible) { // net_weight ?>
	<?php if ($wool_import_calculator->sortUrl($wool_import_calculator->net_weight) == "") { ?>
		<th data-name="net_weight" class="<?php echo $wool_import_calculator->net_weight->headerCellClass() ?>"><div id="elh_wool_import_calculator_net_weight" class="wool_import_calculator_net_weight"><div class="ew-table-header-caption"><?php echo $wool_import_calculator->net_weight->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="net_weight" class="<?php echo $wool_import_calculator->net_weight->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $wool_import_calculator->SortUrl($wool_import_calculator->net_weight) ?>',2);"><div id="elh_wool_import_calculator_net_weight" class="wool_import_calculator_net_weight">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $wool_import_calculator->net_weight->caption() ?></span><span class="ew-table-header-sort"><?php if ($wool_import_calculator->net_weight->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($wool_import_calculator->net_weight->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($wool_import_calculator->actual_cost->Visible) { // actual_cost ?>
	<?php if ($wool_import_calculator->sortUrl($wool_import_calculator->actual_cost) == "") { ?>
		<th data-name="actual_cost" class="<?php echo $wool_import_calculator->actual_cost->headerCellClass() ?>"><div id="elh_wool_import_calculator_actual_cost" class="wool_import_calculator_actual_cost"><div class="ew-table-header-caption"><?php echo $wool_import_calculator->actual_cost->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="actual_cost" class="<?php echo $wool_import_calculator->actual_cost->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $wool_import_calculator->SortUrl($wool_import_calculator->actual_cost) ?>',2);"><div id="elh_wool_import_calculator_actual_cost" class="wool_import_calculator_actual_cost">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $wool_import_calculator->actual_cost->caption() ?></span><span class="ew-table-header-sort"><?php if ($wool_import_calculator->actual_cost->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($wool_import_calculator->actual_cost->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($wool_import_calculator->avg_cost->Visible) { // avg_cost ?>
	<?php if ($wool_import_calculator->sortUrl($wool_import_calculator->avg_cost) == "") { ?>
		<th data-name="avg_cost" class="<?php echo $wool_import_calculator->avg_cost->headerCellClass() ?>"><div id="elh_wool_import_calculator_avg_cost" class="wool_import_calculator_avg_cost"><div class="ew-table-header-caption"><?php echo $wool_import_calculator->avg_cost->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="avg_cost" class="<?php echo $wool_import_calculator->avg_cost->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $wool_import_calculator->SortUrl($wool_import_calculator->avg_cost) ?>',2);"><div id="elh_wool_import_calculator_avg_cost" class="wool_import_calculator_avg_cost">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $wool_import_calculator->avg_cost->caption() ?></span><span class="ew-table-header-sort"><?php if ($wool_import_calculator->avg_cost->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($wool_import_calculator->avg_cost->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$wool_import_calculator_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($wool_import_calculator->ExportAll && $wool_import_calculator->isExport()) {
	$wool_import_calculator_list->StopRec = $wool_import_calculator_list->TotalRecs;
} else {

	// Set the last record to display
	if ($wool_import_calculator_list->TotalRecs > $wool_import_calculator_list->StartRec + $wool_import_calculator_list->DisplayRecs - 1)
		$wool_import_calculator_list->StopRec = $wool_import_calculator_list->StartRec + $wool_import_calculator_list->DisplayRecs - 1;
	else
		$wool_import_calculator_list->StopRec = $wool_import_calculator_list->TotalRecs;
}
$wool_import_calculator_list->RecCnt = $wool_import_calculator_list->StartRec - 1;
if ($wool_import_calculator_list->Recordset && !$wool_import_calculator_list->Recordset->EOF) {
	$wool_import_calculator_list->Recordset->moveFirst();
	$selectLimit = $wool_import_calculator_list->UseSelectLimit;
	if (!$selectLimit && $wool_import_calculator_list->StartRec > 1)
		$wool_import_calculator_list->Recordset->move($wool_import_calculator_list->StartRec - 1);
} elseif (!$wool_import_calculator->AllowAddDeleteRow && $wool_import_calculator_list->StopRec == 0) {
	$wool_import_calculator_list->StopRec = $wool_import_calculator->GridAddRowCount;
}

// Initialize aggregate
$wool_import_calculator->RowType = ROWTYPE_AGGREGATEINIT;
$wool_import_calculator->resetAttributes();
$wool_import_calculator_list->renderRow();
while ($wool_import_calculator_list->RecCnt < $wool_import_calculator_list->StopRec) {
	$wool_import_calculator_list->RecCnt++;
	if ($wool_import_calculator_list->RecCnt >= $wool_import_calculator_list->StartRec) {
		$wool_import_calculator_list->RowCnt++;

		// Set up key count
		$wool_import_calculator_list->KeyCount = $wool_import_calculator_list->RowIndex;

		// Init row class and style
		$wool_import_calculator->resetAttributes();
		$wool_import_calculator->CssClass = "";
		if ($wool_import_calculator->isGridAdd()) {
		} else {
			$wool_import_calculator_list->loadRowValues($wool_import_calculator_list->Recordset); // Load row values
		}
		$wool_import_calculator->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$wool_import_calculator->RowAttrs = array_merge($wool_import_calculator->RowAttrs, array('data-rowindex'=>$wool_import_calculator_list->RowCnt, 'id'=>'r' . $wool_import_calculator_list->RowCnt . '_wool_import_calculator', 'data-rowtype'=>$wool_import_calculator->RowType));

		// Render row
		$wool_import_calculator_list->renderRow();

		// Render list options
		$wool_import_calculator_list->renderListOptions();
?>
	<tr<?php echo $wool_import_calculator->rowAttributes() ?>>
<?php

// Render list options (body, left)
$wool_import_calculator_list->ListOptions->render("body", "left", $wool_import_calculator_list->RowCnt);
?>
	<?php if ($wool_import_calculator->rid->Visible) { // rid ?>
		<td data-name="rid"<?php echo $wool_import_calculator->rid->cellAttributes() ?>>
<span id="el<?php echo $wool_import_calculator_list->RowCnt ?>_wool_import_calculator_rid" class="wool_import_calculator_rid">
<span<?php echo $wool_import_calculator->rid->viewAttributes() ?>>
<?php if ((!EmptyString($wool_import_calculator->rid->getViewValue())) && $wool_import_calculator->rid->linkAttributes() <> "") { ?>
<a<?php echo $wool_import_calculator->rid->linkAttributes() ?>><?php echo $wool_import_calculator->rid->getViewValue() ?></a>
<?php } else { ?>
<?php echo $wool_import_calculator->rid->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($wool_import_calculator->product_code->Visible) { // product_code ?>
		<td data-name="product_code"<?php echo $wool_import_calculator->product_code->cellAttributes() ?>>
<span id="el<?php echo $wool_import_calculator_list->RowCnt ?>_wool_import_calculator_product_code" class="wool_import_calculator_product_code">
<span<?php echo $wool_import_calculator->product_code->viewAttributes() ?>>
<?php if ((!EmptyString($wool_import_calculator->product_code->getViewValue())) && $wool_import_calculator->product_code->linkAttributes() <> "") { ?>
<a<?php echo $wool_import_calculator->product_code->linkAttributes() ?>><?php echo $wool_import_calculator->product_code->getViewValue() ?></a>
<?php } else { ?>
<?php echo $wool_import_calculator->product_code->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($wool_import_calculator->net_weight->Visible) { // net_weight ?>
		<td data-name="net_weight"<?php echo $wool_import_calculator->net_weight->cellAttributes() ?>>
<span id="el<?php echo $wool_import_calculator_list->RowCnt ?>_wool_import_calculator_net_weight" class="wool_import_calculator_net_weight">
<span<?php echo $wool_import_calculator->net_weight->viewAttributes() ?>>
<?php if ((!EmptyString($wool_import_calculator->net_weight->getViewValue())) && $wool_import_calculator->net_weight->linkAttributes() <> "") { ?>
<a<?php echo $wool_import_calculator->net_weight->linkAttributes() ?>><?php echo $wool_import_calculator->net_weight->getViewValue() ?></a>
<?php } else { ?>
<?php echo $wool_import_calculator->net_weight->getViewValue() ?>
<?php } ?>
</span>
</span>
</td>
	<?php } ?>
	<?php if ($wool_import_calculator->actual_cost->Visible) { // actual_cost ?>
		<td data-name="actual_cost"<?php echo $wool_import_calculator->actual_cost->cellAttributes() ?>>
<span id="el<?php echo $wool_import_calculator_list->RowCnt ?>_wool_import_calculator_actual_cost" class="wool_import_calculator_actual_cost">
<span<?php echo $wool_import_calculator->actual_cost->viewAttributes() ?>>
<?php echo $wool_import_calculator->actual_cost->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($wool_import_calculator->avg_cost->Visible) { // avg_cost ?>
		<td data-name="avg_cost"<?php echo $wool_import_calculator->avg_cost->cellAttributes() ?>>
<span id="el<?php echo $wool_import_calculator_list->RowCnt ?>_wool_import_calculator_avg_cost" class="wool_import_calculator_avg_cost">
<span<?php echo $wool_import_calculator->avg_cost->viewAttributes() ?>>
<?php echo $wool_import_calculator->avg_cost->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$wool_import_calculator_list->ListOptions->render("body", "right", $wool_import_calculator_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$wool_import_calculator->isGridAdd())
		$wool_import_calculator_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$wool_import_calculator->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($wool_import_calculator_list->Recordset)
	$wool_import_calculator_list->Recordset->Close();
?>
<?php if (!$wool_import_calculator->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$wool_import_calculator->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($wool_import_calculator_list->Pager)) $wool_import_calculator_list->Pager = new PrevNextPager($wool_import_calculator_list->StartRec, $wool_import_calculator_list->DisplayRecs, $wool_import_calculator_list->TotalRecs, $wool_import_calculator_list->AutoHidePager) ?>
<?php if ($wool_import_calculator_list->Pager->RecordCount > 0 && $wool_import_calculator_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($wool_import_calculator_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $wool_import_calculator_list->pageUrl() ?>start=<?php echo $wool_import_calculator_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($wool_import_calculator_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $wool_import_calculator_list->pageUrl() ?>start=<?php echo $wool_import_calculator_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $wool_import_calculator_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($wool_import_calculator_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $wool_import_calculator_list->pageUrl() ?>start=<?php echo $wool_import_calculator_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($wool_import_calculator_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $wool_import_calculator_list->pageUrl() ?>start=<?php echo $wool_import_calculator_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $wool_import_calculator_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($wool_import_calculator_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $wool_import_calculator_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $wool_import_calculator_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $wool_import_calculator_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($wool_import_calculator_list->TotalRecs > 0 && (!$wool_import_calculator_list->AutoHidePageSizeSelector || $wool_import_calculator_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="wool_import_calculator">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($wool_import_calculator_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($wool_import_calculator_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($wool_import_calculator_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($wool_import_calculator_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($wool_import_calculator_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($wool_import_calculator->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $wool_import_calculator_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($wool_import_calculator_list->TotalRecs == 0 && !$wool_import_calculator->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $wool_import_calculator_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$wool_import_calculator_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$wool_import_calculator->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$wool_import_calculator->isExport()) { ?>
<script>
ew.scrollableTable("gmp_wool_import_calculator", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$wool_import_calculator_list->terminate();
?>