<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$world_city_add = new world_city_add();

// Run the page
$world_city_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$world_city_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fworld_cityadd = currentForm = new ew.Form("fworld_cityadd", "add");

// Validate form
fworld_cityadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($world_city_add->country_id->Required) { ?>
			elm = this.getElements("x" + infix + "_country_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $world_city->country_id->caption(), $world_city->country_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($world_city_add->state_id->Required) { ?>
			elm = this.getElements("x" + infix + "_state_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $world_city->state_id->caption(), $world_city->state_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($world_city_add->name->Required) { ?>
			elm = this.getElements("x" + infix + "_name");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $world_city->name->caption(), $world_city->name->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fworld_cityadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fworld_cityadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fworld_cityadd.lists["x_country_id"] = <?php echo $world_city_add->country_id->Lookup->toClientList() ?>;
fworld_cityadd.lists["x_country_id"].options = <?php echo JsonEncode($world_city_add->country_id->lookupOptions()) ?>;
fworld_cityadd.lists["x_state_id"] = <?php echo $world_city_add->state_id->Lookup->toClientList() ?>;
fworld_cityadd.lists["x_state_id"].options = <?php echo JsonEncode($world_city_add->state_id->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $world_city_add->showPageHeader(); ?>
<?php
$world_city_add->showMessage();
?>
<form name="fworld_cityadd" id="fworld_cityadd" class="<?php echo $world_city_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($world_city_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $world_city_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="world_city">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$world_city_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($world_city->country_id->Visible) { // country_id ?>
	<div id="r_country_id" class="form-group row">
		<label id="elh_world_city_country_id" for="x_country_id" class="<?php echo $world_city_add->LeftColumnClass ?>"><?php echo $world_city->country_id->caption() ?><?php echo ($world_city->country_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $world_city_add->RightColumnClass ?>"><div<?php echo $world_city->country_id->cellAttributes() ?>>
<span id="el_world_city_country_id">
<?php $world_city->country_id->EditAttrs["onchange"] = "ew.updateOptions.call(this);" . @$world_city->country_id->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="world_city" data-field="x_country_id" data-value-separator="<?php echo $world_city->country_id->displayValueSeparatorAttribute() ?>" id="x_country_id" name="x_country_id"<?php echo $world_city->country_id->editAttributes() ?>>
		<?php echo $world_city->country_id->selectOptionListHtml("x_country_id") ?>
	</select>
</div>
<?php echo $world_city->country_id->Lookup->getParamTag("p_x_country_id") ?>
</span>
<?php echo $world_city->country_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($world_city->state_id->Visible) { // state_id ?>
	<div id="r_state_id" class="form-group row">
		<label id="elh_world_city_state_id" for="x_state_id" class="<?php echo $world_city_add->LeftColumnClass ?>"><?php echo $world_city->state_id->caption() ?><?php echo ($world_city->state_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $world_city_add->RightColumnClass ?>"><div<?php echo $world_city->state_id->cellAttributes() ?>>
<span id="el_world_city_state_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="world_city" data-field="x_state_id" data-value-separator="<?php echo $world_city->state_id->displayValueSeparatorAttribute() ?>" id="x_state_id" name="x_state_id"<?php echo $world_city->state_id->editAttributes() ?>>
		<?php echo $world_city->state_id->selectOptionListHtml("x_state_id") ?>
	</select>
</div>
<?php echo $world_city->state_id->Lookup->getParamTag("p_x_state_id") ?>
</span>
<?php echo $world_city->state_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($world_city->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label id="elh_world_city_name" for="x_name" class="<?php echo $world_city_add->LeftColumnClass ?>"><?php echo $world_city->name->caption() ?><?php echo ($world_city->name->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $world_city_add->RightColumnClass ?>"><div<?php echo $world_city->name->cellAttributes() ?>>
<span id="el_world_city_name">
<input type="text" data-table="world_city" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($world_city->name->getPlaceHolder()) ?>" value="<?php echo $world_city->name->EditValue ?>"<?php echo $world_city->name->editAttributes() ?>>
</span>
<?php echo $world_city->name->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$world_city_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $world_city_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $world_city_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$world_city_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$world_city_add->terminate();
?>