<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$world_city_list = new world_city_list();

// Run the page
$world_city_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$world_city_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$world_city->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fworld_citylist = currentForm = new ew.Form("fworld_citylist", "list");
fworld_citylist.formKeyCountName = '<?php echo $world_city_list->FormKeyCountName ?>';

// Form_CustomValidate event
fworld_citylist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fworld_citylist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fworld_citylist.lists["x_country_id"] = <?php echo $world_city_list->country_id->Lookup->toClientList() ?>;
fworld_citylist.lists["x_country_id"].options = <?php echo JsonEncode($world_city_list->country_id->lookupOptions()) ?>;
fworld_citylist.lists["x_state_id"] = <?php echo $world_city_list->state_id->Lookup->toClientList() ?>;
fworld_citylist.lists["x_state_id"].options = <?php echo JsonEncode($world_city_list->state_id->lookupOptions()) ?>;

// Form object for search
var fworld_citylistsrch = currentSearchForm = new ew.Form("fworld_citylistsrch");

// Validate function for search
fworld_citylistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fworld_citylistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fworld_citylistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fworld_citylistsrch.lists["x_country_id"] = <?php echo $world_city_list->country_id->Lookup->toClientList() ?>;
fworld_citylistsrch.lists["x_country_id"].options = <?php echo JsonEncode($world_city_list->country_id->lookupOptions()) ?>;
fworld_citylistsrch.lists["x_state_id"] = <?php echo $world_city_list->state_id->Lookup->toClientList() ?>;
fworld_citylistsrch.lists["x_state_id"].options = <?php echo JsonEncode($world_city_list->state_id->lookupOptions()) ?>;

// Filters
fworld_citylistsrch.filterList = <?php echo $world_city_list->getFilterList() ?>;

// Init search panel as collapsed
fworld_citylistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$world_city->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($world_city_list->TotalRecs > 0 && $world_city_list->ExportOptions->visible()) { ?>
<?php $world_city_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($world_city_list->ImportOptions->visible()) { ?>
<?php $world_city_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($world_city_list->SearchOptions->visible()) { ?>
<?php $world_city_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($world_city_list->FilterOptions->visible()) { ?>
<?php $world_city_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$world_city_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$world_city->isExport() && !$world_city->CurrentAction) { ?>
<form name="fworld_citylistsrch" id="fworld_citylistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($world_city_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fworld_citylistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="world_city">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$world_city_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$world_city->RowType = ROWTYPE_SEARCH;

// Render row
$world_city->resetAttributes();
$world_city_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($world_city->country_id->Visible) { // country_id ?>
	<div id="xsc_country_id" class="ew-cell form-group">
		<label for="x_country_id" class="ew-search-caption ew-label"><?php echo $world_city->country_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_country_id" id="z_country_id" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="world_city" data-field="x_country_id" name="x_country_id" id="x_country_id" size="30" placeholder="<?php echo HtmlEncode($world_city->country_id->getPlaceHolder()) ?>" value="<?php echo $world_city->country_id->EditValue ?>"<?php echo $world_city->country_id->editAttributes() ?>>
<?php echo $world_city->country_id->Lookup->getParamTag("p_x_country_id") ?>
</span>
	</div>
<?php } ?>
<?php if ($world_city->state_id->Visible) { // state_id ?>
	<div id="xsc_state_id" class="ew-cell form-group">
		<label for="x_state_id" class="ew-search-caption ew-label"><?php echo $world_city->state_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_state_id" id="z_state_id" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="world_city" data-field="x_state_id" name="x_state_id" id="x_state_id" size="30" placeholder="<?php echo HtmlEncode($world_city->state_id->getPlaceHolder()) ?>" value="<?php echo $world_city->state_id->EditValue ?>"<?php echo $world_city->state_id->editAttributes() ?>>
<?php echo $world_city->state_id->Lookup->getParamTag("p_x_state_id") ?>
</span>
	</div>
<?php } ?>
<?php if ($world_city->name->Visible) { // name ?>
	<div id="xsc_name" class="ew-cell form-group">
		<label for="x_name" class="ew-search-caption ew-label"><?php echo $world_city->name->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_name" id="z_name" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="world_city" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($world_city->name->getPlaceHolder()) ?>" value="<?php echo $world_city->name->EditValue ?>"<?php echo $world_city->name->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($world_city_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($world_city_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $world_city_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($world_city_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($world_city_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($world_city_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($world_city_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $world_city_list->showPageHeader(); ?>
<?php
$world_city_list->showMessage();
?>
<?php if ($world_city_list->TotalRecs > 0 || $world_city->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($world_city_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> world_city">
<?php if (!$world_city->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$world_city->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($world_city_list->Pager)) $world_city_list->Pager = new PrevNextPager($world_city_list->StartRec, $world_city_list->DisplayRecs, $world_city_list->TotalRecs, $world_city_list->AutoHidePager) ?>
<?php if ($world_city_list->Pager->RecordCount > 0 && $world_city_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($world_city_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $world_city_list->pageUrl() ?>start=<?php echo $world_city_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($world_city_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $world_city_list->pageUrl() ?>start=<?php echo $world_city_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $world_city_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($world_city_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $world_city_list->pageUrl() ?>start=<?php echo $world_city_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($world_city_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $world_city_list->pageUrl() ?>start=<?php echo $world_city_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $world_city_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($world_city_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $world_city_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $world_city_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $world_city_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($world_city_list->TotalRecs > 0 && (!$world_city_list->AutoHidePageSizeSelector || $world_city_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="world_city">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($world_city_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($world_city_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($world_city_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($world_city_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($world_city_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($world_city->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $world_city_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fworld_citylist" id="fworld_citylist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($world_city_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $world_city_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="world_city">
<div id="gmp_world_city" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($world_city_list->TotalRecs > 0 || $world_city->isGridEdit()) { ?>
<table id="tbl_world_citylist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$world_city_list->RowType = ROWTYPE_HEADER;

// Render list options
$world_city_list->renderListOptions();

// Render list options (header, left)
$world_city_list->ListOptions->render("header", "left");
?>
<?php if ($world_city->id->Visible) { // id ?>
	<?php if ($world_city->sortUrl($world_city->id) == "") { ?>
		<th data-name="id" class="<?php echo $world_city->id->headerCellClass() ?>"><div id="elh_world_city_id" class="world_city_id"><div class="ew-table-header-caption"><?php echo $world_city->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $world_city->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $world_city->SortUrl($world_city->id) ?>',2);"><div id="elh_world_city_id" class="world_city_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $world_city->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($world_city->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($world_city->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($world_city->country_id->Visible) { // country_id ?>
	<?php if ($world_city->sortUrl($world_city->country_id) == "") { ?>
		<th data-name="country_id" class="<?php echo $world_city->country_id->headerCellClass() ?>"><div id="elh_world_city_country_id" class="world_city_country_id"><div class="ew-table-header-caption"><?php echo $world_city->country_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="country_id" class="<?php echo $world_city->country_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $world_city->SortUrl($world_city->country_id) ?>',2);"><div id="elh_world_city_country_id" class="world_city_country_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $world_city->country_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($world_city->country_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($world_city->country_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($world_city->state_id->Visible) { // state_id ?>
	<?php if ($world_city->sortUrl($world_city->state_id) == "") { ?>
		<th data-name="state_id" class="<?php echo $world_city->state_id->headerCellClass() ?>"><div id="elh_world_city_state_id" class="world_city_state_id"><div class="ew-table-header-caption"><?php echo $world_city->state_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="state_id" class="<?php echo $world_city->state_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $world_city->SortUrl($world_city->state_id) ?>',2);"><div id="elh_world_city_state_id" class="world_city_state_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $world_city->state_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($world_city->state_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($world_city->state_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($world_city->name->Visible) { // name ?>
	<?php if ($world_city->sortUrl($world_city->name) == "") { ?>
		<th data-name="name" class="<?php echo $world_city->name->headerCellClass() ?>"><div id="elh_world_city_name" class="world_city_name"><div class="ew-table-header-caption"><?php echo $world_city->name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="name" class="<?php echo $world_city->name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $world_city->SortUrl($world_city->name) ?>',2);"><div id="elh_world_city_name" class="world_city_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $world_city->name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($world_city->name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($world_city->name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$world_city_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($world_city->ExportAll && $world_city->isExport()) {
	$world_city_list->StopRec = $world_city_list->TotalRecs;
} else {

	// Set the last record to display
	if ($world_city_list->TotalRecs > $world_city_list->StartRec + $world_city_list->DisplayRecs - 1)
		$world_city_list->StopRec = $world_city_list->StartRec + $world_city_list->DisplayRecs - 1;
	else
		$world_city_list->StopRec = $world_city_list->TotalRecs;
}
$world_city_list->RecCnt = $world_city_list->StartRec - 1;
if ($world_city_list->Recordset && !$world_city_list->Recordset->EOF) {
	$world_city_list->Recordset->moveFirst();
	$selectLimit = $world_city_list->UseSelectLimit;
	if (!$selectLimit && $world_city_list->StartRec > 1)
		$world_city_list->Recordset->move($world_city_list->StartRec - 1);
} elseif (!$world_city->AllowAddDeleteRow && $world_city_list->StopRec == 0) {
	$world_city_list->StopRec = $world_city->GridAddRowCount;
}

// Initialize aggregate
$world_city->RowType = ROWTYPE_AGGREGATEINIT;
$world_city->resetAttributes();
$world_city_list->renderRow();
while ($world_city_list->RecCnt < $world_city_list->StopRec) {
	$world_city_list->RecCnt++;
	if ($world_city_list->RecCnt >= $world_city_list->StartRec) {
		$world_city_list->RowCnt++;

		// Set up key count
		$world_city_list->KeyCount = $world_city_list->RowIndex;

		// Init row class and style
		$world_city->resetAttributes();
		$world_city->CssClass = "";
		if ($world_city->isGridAdd()) {
		} else {
			$world_city_list->loadRowValues($world_city_list->Recordset); // Load row values
		}
		$world_city->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$world_city->RowAttrs = array_merge($world_city->RowAttrs, array('data-rowindex'=>$world_city_list->RowCnt, 'id'=>'r' . $world_city_list->RowCnt . '_world_city', 'data-rowtype'=>$world_city->RowType));

		// Render row
		$world_city_list->renderRow();

		// Render list options
		$world_city_list->renderListOptions();
?>
	<tr<?php echo $world_city->rowAttributes() ?>>
<?php

// Render list options (body, left)
$world_city_list->ListOptions->render("body", "left", $world_city_list->RowCnt);
?>
	<?php if ($world_city->id->Visible) { // id ?>
		<td data-name="id"<?php echo $world_city->id->cellAttributes() ?>>
<span id="el<?php echo $world_city_list->RowCnt ?>_world_city_id" class="world_city_id">
<span<?php echo $world_city->id->viewAttributes() ?>>
<?php echo $world_city->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($world_city->country_id->Visible) { // country_id ?>
		<td data-name="country_id"<?php echo $world_city->country_id->cellAttributes() ?>>
<span id="el<?php echo $world_city_list->RowCnt ?>_world_city_country_id" class="world_city_country_id">
<span<?php echo $world_city->country_id->viewAttributes() ?>>
<?php echo $world_city->country_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($world_city->state_id->Visible) { // state_id ?>
		<td data-name="state_id"<?php echo $world_city->state_id->cellAttributes() ?>>
<span id="el<?php echo $world_city_list->RowCnt ?>_world_city_state_id" class="world_city_state_id">
<span<?php echo $world_city->state_id->viewAttributes() ?>>
<?php echo $world_city->state_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($world_city->name->Visible) { // name ?>
		<td data-name="name"<?php echo $world_city->name->cellAttributes() ?>>
<span id="el<?php echo $world_city_list->RowCnt ?>_world_city_name" class="world_city_name">
<span<?php echo $world_city->name->viewAttributes() ?>>
<?php echo $world_city->name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$world_city_list->ListOptions->render("body", "right", $world_city_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$world_city->isGridAdd())
		$world_city_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$world_city->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($world_city_list->Recordset)
	$world_city_list->Recordset->Close();
?>
<?php if (!$world_city->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$world_city->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($world_city_list->Pager)) $world_city_list->Pager = new PrevNextPager($world_city_list->StartRec, $world_city_list->DisplayRecs, $world_city_list->TotalRecs, $world_city_list->AutoHidePager) ?>
<?php if ($world_city_list->Pager->RecordCount > 0 && $world_city_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($world_city_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $world_city_list->pageUrl() ?>start=<?php echo $world_city_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($world_city_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $world_city_list->pageUrl() ?>start=<?php echo $world_city_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $world_city_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($world_city_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $world_city_list->pageUrl() ?>start=<?php echo $world_city_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($world_city_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $world_city_list->pageUrl() ?>start=<?php echo $world_city_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $world_city_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($world_city_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $world_city_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $world_city_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $world_city_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($world_city_list->TotalRecs > 0 && (!$world_city_list->AutoHidePageSizeSelector || $world_city_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="world_city">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($world_city_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($world_city_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($world_city_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($world_city_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($world_city_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($world_city->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $world_city_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($world_city_list->TotalRecs == 0 && !$world_city->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $world_city_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$world_city_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$world_city->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$world_city->isExport()) { ?>
<script>
ew.scrollableTable("gmp_world_city", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$world_city_list->terminate();
?>