<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$world_city_search = new world_city_search();

// Run the page
$world_city_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$world_city_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($world_city_search->IsModal) { ?>
var fworld_citysearch = currentAdvancedSearchForm = new ew.Form("fworld_citysearch", "search");
<?php } else { ?>
var fworld_citysearch = currentForm = new ew.Form("fworld_citysearch", "search");
<?php } ?>

// Form_CustomValidate event
fworld_citysearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fworld_citysearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fworld_citysearch.lists["x_country_id"] = <?php echo $world_city_search->country_id->Lookup->toClientList() ?>;
fworld_citysearch.lists["x_country_id"].options = <?php echo JsonEncode($world_city_search->country_id->lookupOptions()) ?>;
fworld_citysearch.lists["x_state_id"] = <?php echo $world_city_search->state_id->Lookup->toClientList() ?>;
fworld_citysearch.lists["x_state_id"].options = <?php echo JsonEncode($world_city_search->state_id->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fworld_citysearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($world_city->id->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $world_city_search->showPageHeader(); ?>
<?php
$world_city_search->showMessage();
?>
<form name="fworld_citysearch" id="fworld_citysearch" class="<?php echo $world_city_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($world_city_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $world_city_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="world_city">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$world_city_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($world_city->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $world_city_search->LeftColumnClass ?>"><span id="elh_world_city_id"><?php echo $world_city->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $world_city_search->RightColumnClass ?>"><div<?php echo $world_city->id->cellAttributes() ?>>
			<span id="el_world_city_id">
<input type="text" data-table="world_city" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($world_city->id->getPlaceHolder()) ?>" value="<?php echo $world_city->id->EditValue ?>"<?php echo $world_city->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($world_city->country_id->Visible) { // country_id ?>
	<div id="r_country_id" class="form-group row">
		<label for="x_country_id" class="<?php echo $world_city_search->LeftColumnClass ?>"><span id="elh_world_city_country_id"><?php echo $world_city->country_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_country_id" id="z_country_id" value="="></span>
		</label>
		<div class="<?php echo $world_city_search->RightColumnClass ?>"><div<?php echo $world_city->country_id->cellAttributes() ?>>
			<span id="el_world_city_country_id">
<input type="text" data-table="world_city" data-field="x_country_id" name="x_country_id" id="x_country_id" size="30" placeholder="<?php echo HtmlEncode($world_city->country_id->getPlaceHolder()) ?>" value="<?php echo $world_city->country_id->EditValue ?>"<?php echo $world_city->country_id->editAttributes() ?>>
<?php echo $world_city->country_id->Lookup->getParamTag("p_x_country_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($world_city->state_id->Visible) { // state_id ?>
	<div id="r_state_id" class="form-group row">
		<label for="x_state_id" class="<?php echo $world_city_search->LeftColumnClass ?>"><span id="elh_world_city_state_id"><?php echo $world_city->state_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_state_id" id="z_state_id" value="="></span>
		</label>
		<div class="<?php echo $world_city_search->RightColumnClass ?>"><div<?php echo $world_city->state_id->cellAttributes() ?>>
			<span id="el_world_city_state_id">
<input type="text" data-table="world_city" data-field="x_state_id" name="x_state_id" id="x_state_id" size="30" placeholder="<?php echo HtmlEncode($world_city->state_id->getPlaceHolder()) ?>" value="<?php echo $world_city->state_id->EditValue ?>"<?php echo $world_city->state_id->editAttributes() ?>>
<?php echo $world_city->state_id->Lookup->getParamTag("p_x_state_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($world_city->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label for="x_name" class="<?php echo $world_city_search->LeftColumnClass ?>"><span id="elh_world_city_name"><?php echo $world_city->name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_name" id="z_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $world_city_search->RightColumnClass ?>"><div<?php echo $world_city->name->cellAttributes() ?>>
			<span id="el_world_city_name">
<input type="text" data-table="world_city" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($world_city->name->getPlaceHolder()) ?>" value="<?php echo $world_city->name->EditValue ?>"<?php echo $world_city->name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$world_city_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $world_city_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$world_city_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$world_city_search->terminate();
?>