<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$world_state_list = new world_state_list();

// Run the page
$world_state_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$world_state_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$world_state->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fworld_statelist = currentForm = new ew.Form("fworld_statelist", "list");
fworld_statelist.formKeyCountName = '<?php echo $world_state_list->FormKeyCountName ?>';

// Form_CustomValidate event
fworld_statelist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fworld_statelist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fworld_statelist.lists["x_country_id"] = <?php echo $world_state_list->country_id->Lookup->toClientList() ?>;
fworld_statelist.lists["x_country_id"].options = <?php echo JsonEncode($world_state_list->country_id->lookupOptions()) ?>;

// Form object for search
var fworld_statelistsrch = currentSearchForm = new ew.Form("fworld_statelistsrch");

// Validate function for search
fworld_statelistsrch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}

// Form_CustomValidate event
fworld_statelistsrch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fworld_statelistsrch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fworld_statelistsrch.lists["x_country_id"] = <?php echo $world_state_list->country_id->Lookup->toClientList() ?>;
fworld_statelistsrch.lists["x_country_id"].options = <?php echo JsonEncode($world_state_list->country_id->lookupOptions()) ?>;

// Filters
fworld_statelistsrch.filterList = <?php echo $world_state_list->getFilterList() ?>;

// Init search panel as collapsed
fworld_statelistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$world_state->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($world_state_list->TotalRecs > 0 && $world_state_list->ExportOptions->visible()) { ?>
<?php $world_state_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($world_state_list->ImportOptions->visible()) { ?>
<?php $world_state_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($world_state_list->SearchOptions->visible()) { ?>
<?php $world_state_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($world_state_list->FilterOptions->visible()) { ?>
<?php $world_state_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$world_state_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$world_state->isExport() && !$world_state->CurrentAction) { ?>
<form name="fworld_statelistsrch" id="fworld_statelistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($world_state_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fworld_statelistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="world_state">
	<div class="ew-basic-search">
<?php
if ($SearchError == "")
	$world_state_list->LoadAdvancedSearch(); // Load advanced search

// Render for search
$world_state->RowType = ROWTYPE_SEARCH;

// Render row
$world_state->resetAttributes();
$world_state_list->renderRow();
?>
<div id="xsr_1" class="ew-row d-sm-flex">
<?php if ($world_state->country_id->Visible) { // country_id ?>
	<div id="xsc_country_id" class="ew-cell form-group">
		<label for="x_country_id" class="ew-search-caption ew-label"><?php echo $world_state->country_id->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_country_id" id="z_country_id" value="="></span>
		<span class="ew-search-field">
<input type="text" data-table="world_state" data-field="x_country_id" name="x_country_id" id="x_country_id" size="30" placeholder="<?php echo HtmlEncode($world_state->country_id->getPlaceHolder()) ?>" value="<?php echo $world_state->country_id->EditValue ?>"<?php echo $world_state->country_id->editAttributes() ?>>
<?php echo $world_state->country_id->Lookup->getParamTag("p_x_country_id") ?>
</span>
	</div>
<?php } ?>
<?php if ($world_state->name->Visible) { // name ?>
	<div id="xsc_name" class="ew-cell form-group">
		<label for="x_name" class="ew-search-caption ew-label"><?php echo $world_state->name->caption() ?></label>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_name" id="z_name" value="LIKE"></span>
		<span class="ew-search-field">
<input type="text" data-table="world_state" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($world_state->name->getPlaceHolder()) ?>" value="<?php echo $world_state->name->EditValue ?>"<?php echo $world_state->name->editAttributes() ?>>
</span>
	</div>
<?php } ?>
</div>
<div id="xsr_2" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($world_state_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($world_state_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $world_state_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($world_state_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($world_state_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($world_state_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($world_state_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $world_state_list->showPageHeader(); ?>
<?php
$world_state_list->showMessage();
?>
<?php if ($world_state_list->TotalRecs > 0 || $world_state->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($world_state_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> world_state">
<?php if (!$world_state->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$world_state->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($world_state_list->Pager)) $world_state_list->Pager = new PrevNextPager($world_state_list->StartRec, $world_state_list->DisplayRecs, $world_state_list->TotalRecs, $world_state_list->AutoHidePager) ?>
<?php if ($world_state_list->Pager->RecordCount > 0 && $world_state_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($world_state_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $world_state_list->pageUrl() ?>start=<?php echo $world_state_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($world_state_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $world_state_list->pageUrl() ?>start=<?php echo $world_state_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $world_state_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($world_state_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $world_state_list->pageUrl() ?>start=<?php echo $world_state_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($world_state_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $world_state_list->pageUrl() ?>start=<?php echo $world_state_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $world_state_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($world_state_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $world_state_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $world_state_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $world_state_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($world_state_list->TotalRecs > 0 && (!$world_state_list->AutoHidePageSizeSelector || $world_state_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="world_state">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($world_state_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($world_state_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($world_state_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($world_state_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($world_state_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($world_state->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $world_state_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fworld_statelist" id="fworld_statelist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($world_state_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $world_state_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="world_state">
<div id="gmp_world_state" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($world_state_list->TotalRecs > 0 || $world_state->isGridEdit()) { ?>
<table id="tbl_world_statelist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$world_state_list->RowType = ROWTYPE_HEADER;

// Render list options
$world_state_list->renderListOptions();

// Render list options (header, left)
$world_state_list->ListOptions->render("header", "left");
?>
<?php if ($world_state->id->Visible) { // id ?>
	<?php if ($world_state->sortUrl($world_state->id) == "") { ?>
		<th data-name="id" class="<?php echo $world_state->id->headerCellClass() ?>"><div id="elh_world_state_id" class="world_state_id"><div class="ew-table-header-caption"><?php echo $world_state->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $world_state->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $world_state->SortUrl($world_state->id) ?>',2);"><div id="elh_world_state_id" class="world_state_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $world_state->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($world_state->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($world_state->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($world_state->country_id->Visible) { // country_id ?>
	<?php if ($world_state->sortUrl($world_state->country_id) == "") { ?>
		<th data-name="country_id" class="<?php echo $world_state->country_id->headerCellClass() ?>"><div id="elh_world_state_country_id" class="world_state_country_id"><div class="ew-table-header-caption"><?php echo $world_state->country_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="country_id" class="<?php echo $world_state->country_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $world_state->SortUrl($world_state->country_id) ?>',2);"><div id="elh_world_state_country_id" class="world_state_country_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $world_state->country_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($world_state->country_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($world_state->country_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($world_state->name->Visible) { // name ?>
	<?php if ($world_state->sortUrl($world_state->name) == "") { ?>
		<th data-name="name" class="<?php echo $world_state->name->headerCellClass() ?>"><div id="elh_world_state_name" class="world_state_name"><div class="ew-table-header-caption"><?php echo $world_state->name->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="name" class="<?php echo $world_state->name->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $world_state->SortUrl($world_state->name) ?>',2);"><div id="elh_world_state_name" class="world_state_name">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $world_state->name->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($world_state->name->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($world_state->name->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$world_state_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($world_state->ExportAll && $world_state->isExport()) {
	$world_state_list->StopRec = $world_state_list->TotalRecs;
} else {

	// Set the last record to display
	if ($world_state_list->TotalRecs > $world_state_list->StartRec + $world_state_list->DisplayRecs - 1)
		$world_state_list->StopRec = $world_state_list->StartRec + $world_state_list->DisplayRecs - 1;
	else
		$world_state_list->StopRec = $world_state_list->TotalRecs;
}
$world_state_list->RecCnt = $world_state_list->StartRec - 1;
if ($world_state_list->Recordset && !$world_state_list->Recordset->EOF) {
	$world_state_list->Recordset->moveFirst();
	$selectLimit = $world_state_list->UseSelectLimit;
	if (!$selectLimit && $world_state_list->StartRec > 1)
		$world_state_list->Recordset->move($world_state_list->StartRec - 1);
} elseif (!$world_state->AllowAddDeleteRow && $world_state_list->StopRec == 0) {
	$world_state_list->StopRec = $world_state->GridAddRowCount;
}

// Initialize aggregate
$world_state->RowType = ROWTYPE_AGGREGATEINIT;
$world_state->resetAttributes();
$world_state_list->renderRow();
while ($world_state_list->RecCnt < $world_state_list->StopRec) {
	$world_state_list->RecCnt++;
	if ($world_state_list->RecCnt >= $world_state_list->StartRec) {
		$world_state_list->RowCnt++;

		// Set up key count
		$world_state_list->KeyCount = $world_state_list->RowIndex;

		// Init row class and style
		$world_state->resetAttributes();
		$world_state->CssClass = "";
		if ($world_state->isGridAdd()) {
		} else {
			$world_state_list->loadRowValues($world_state_list->Recordset); // Load row values
		}
		$world_state->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$world_state->RowAttrs = array_merge($world_state->RowAttrs, array('data-rowindex'=>$world_state_list->RowCnt, 'id'=>'r' . $world_state_list->RowCnt . '_world_state', 'data-rowtype'=>$world_state->RowType));

		// Render row
		$world_state_list->renderRow();

		// Render list options
		$world_state_list->renderListOptions();
?>
	<tr<?php echo $world_state->rowAttributes() ?>>
<?php

// Render list options (body, left)
$world_state_list->ListOptions->render("body", "left", $world_state_list->RowCnt);
?>
	<?php if ($world_state->id->Visible) { // id ?>
		<td data-name="id"<?php echo $world_state->id->cellAttributes() ?>>
<span id="el<?php echo $world_state_list->RowCnt ?>_world_state_id" class="world_state_id">
<span<?php echo $world_state->id->viewAttributes() ?>>
<?php echo $world_state->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($world_state->country_id->Visible) { // country_id ?>
		<td data-name="country_id"<?php echo $world_state->country_id->cellAttributes() ?>>
<span id="el<?php echo $world_state_list->RowCnt ?>_world_state_country_id" class="world_state_country_id">
<span<?php echo $world_state->country_id->viewAttributes() ?>>
<?php echo $world_state->country_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($world_state->name->Visible) { // name ?>
		<td data-name="name"<?php echo $world_state->name->cellAttributes() ?>>
<span id="el<?php echo $world_state_list->RowCnt ?>_world_state_name" class="world_state_name">
<span<?php echo $world_state->name->viewAttributes() ?>>
<?php echo $world_state->name->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$world_state_list->ListOptions->render("body", "right", $world_state_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$world_state->isGridAdd())
		$world_state_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$world_state->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($world_state_list->Recordset)
	$world_state_list->Recordset->Close();
?>
<?php if (!$world_state->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$world_state->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($world_state_list->Pager)) $world_state_list->Pager = new PrevNextPager($world_state_list->StartRec, $world_state_list->DisplayRecs, $world_state_list->TotalRecs, $world_state_list->AutoHidePager) ?>
<?php if ($world_state_list->Pager->RecordCount > 0 && $world_state_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($world_state_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $world_state_list->pageUrl() ?>start=<?php echo $world_state_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($world_state_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $world_state_list->pageUrl() ?>start=<?php echo $world_state_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $world_state_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($world_state_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $world_state_list->pageUrl() ?>start=<?php echo $world_state_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($world_state_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $world_state_list->pageUrl() ?>start=<?php echo $world_state_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $world_state_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($world_state_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $world_state_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $world_state_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $world_state_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($world_state_list->TotalRecs > 0 && (!$world_state_list->AutoHidePageSizeSelector || $world_state_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="world_state">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($world_state_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($world_state_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($world_state_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($world_state_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($world_state_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($world_state->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $world_state_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($world_state_list->TotalRecs == 0 && !$world_state->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $world_state_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$world_state_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$world_state->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$world_state->isExport()) { ?>
<script>
ew.scrollableTable("gmp_world_state", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$world_state_list->terminate();
?>