<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$world_state_search = new world_state_search();

// Run the page
$world_state_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$world_state_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($world_state_search->IsModal) { ?>
var fworld_statesearch = currentAdvancedSearchForm = new ew.Form("fworld_statesearch", "search");
<?php } else { ?>
var fworld_statesearch = currentForm = new ew.Form("fworld_statesearch", "search");
<?php } ?>

// Form_CustomValidate event
fworld_statesearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fworld_statesearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fworld_statesearch.lists["x_country_id"] = <?php echo $world_state_search->country_id->Lookup->toClientList() ?>;
fworld_statesearch.lists["x_country_id"].options = <?php echo JsonEncode($world_state_search->country_id->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fworld_statesearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($world_state->id->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $world_state_search->showPageHeader(); ?>
<?php
$world_state_search->showMessage();
?>
<form name="fworld_statesearch" id="fworld_statesearch" class="<?php echo $world_state_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($world_state_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $world_state_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="world_state">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$world_state_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($world_state->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $world_state_search->LeftColumnClass ?>"><span id="elh_world_state_id"><?php echo $world_state->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $world_state_search->RightColumnClass ?>"><div<?php echo $world_state->id->cellAttributes() ?>>
			<span id="el_world_state_id">
<input type="text" data-table="world_state" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($world_state->id->getPlaceHolder()) ?>" value="<?php echo $world_state->id->EditValue ?>"<?php echo $world_state->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($world_state->country_id->Visible) { // country_id ?>
	<div id="r_country_id" class="form-group row">
		<label for="x_country_id" class="<?php echo $world_state_search->LeftColumnClass ?>"><span id="elh_world_state_country_id"><?php echo $world_state->country_id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_country_id" id="z_country_id" value="="></span>
		</label>
		<div class="<?php echo $world_state_search->RightColumnClass ?>"><div<?php echo $world_state->country_id->cellAttributes() ?>>
			<span id="el_world_state_country_id">
<input type="text" data-table="world_state" data-field="x_country_id" name="x_country_id" id="x_country_id" size="30" placeholder="<?php echo HtmlEncode($world_state->country_id->getPlaceHolder()) ?>" value="<?php echo $world_state->country_id->EditValue ?>"<?php echo $world_state->country_id->editAttributes() ?>>
<?php echo $world_state->country_id->Lookup->getParamTag("p_x_country_id") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($world_state->name->Visible) { // name ?>
	<div id="r_name" class="form-group row">
		<label for="x_name" class="<?php echo $world_state_search->LeftColumnClass ?>"><span id="elh_world_state_name"><?php echo $world_state->name->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_name" id="z_name" value="LIKE"></span>
		</label>
		<div class="<?php echo $world_state_search->RightColumnClass ?>"><div<?php echo $world_state->name->cellAttributes() ?>>
			<span id="el_world_state_name">
<input type="text" data-table="world_state" data-field="x_name" name="x_name" id="x_name" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($world_state->name->getPlaceHolder()) ?>" value="<?php echo $world_state->name->EditValue ?>"<?php echo $world_state->name->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$world_state_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $world_state_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$world_state_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$world_state_search->terminate();
?>