<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$ww_color_order_add = new ww_color_order_add();

// Run the page
$ww_color_order_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$ww_color_order_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fww_color_orderadd = currentForm = new ew.Form("fww_color_orderadd", "add");

// Validate form
fww_color_orderadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($ww_color_order_add->period->Required) { ?>
			elm = this.getElements("x" + infix + "_period");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ww_color_order->period->caption(), $ww_color_order->period->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ww_color_order_add->c_id->Required) { ?>
			elm = this.getElements("x" + infix + "_c_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ww_color_order->c_id->caption(), $ww_color_order->c_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ww_color_order_add->quantity->Required) { ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ww_color_order->quantity->caption(), $ww_color_order->quantity->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_quantity");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($ww_color_order->quantity->errorMessage()) ?>");
		<?php if ($ww_color_order_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ww_color_order->operator->caption(), $ww_color_order->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ww_color_order_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ww_color_order->datetime->caption(), $ww_color_order->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fww_color_orderadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fww_color_orderadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fww_color_orderadd.lists["x_period"] = <?php echo $ww_color_order_add->period->Lookup->toClientList() ?>;
fww_color_orderadd.lists["x_period"].options = <?php echo JsonEncode($ww_color_order_add->period->lookupOptions()) ?>;
fww_color_orderadd.lists["x_c_id"] = <?php echo $ww_color_order_add->c_id->Lookup->toClientList() ?>;
fww_color_orderadd.lists["x_c_id"].options = <?php echo JsonEncode($ww_color_order_add->c_id->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $ww_color_order_add->showPageHeader(); ?>
<?php
$ww_color_order_add->showMessage();
?>
<form name="fww_color_orderadd" id="fww_color_orderadd" class="<?php echo $ww_color_order_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($ww_color_order_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $ww_color_order_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="ww_color_order">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$ww_color_order_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($ww_color_order->period->Visible) { // period ?>
	<div id="r_period" class="form-group row">
		<label id="elh_ww_color_order_period" for="x_period" class="<?php echo $ww_color_order_add->LeftColumnClass ?>"><?php echo $ww_color_order->period->caption() ?><?php echo ($ww_color_order->period->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ww_color_order_add->RightColumnClass ?>"><div<?php echo $ww_color_order->period->cellAttributes() ?>>
<span id="el_ww_color_order_period">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ww_color_order" data-field="x_period" data-value-separator="<?php echo $ww_color_order->period->displayValueSeparatorAttribute() ?>" id="x_period" name="x_period"<?php echo $ww_color_order->period->editAttributes() ?>>
		<?php echo $ww_color_order->period->selectOptionListHtml("x_period") ?>
	</select>
</div>
<?php echo $ww_color_order->period->Lookup->getParamTag("p_x_period") ?>
</span>
<?php echo $ww_color_order->period->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ww_color_order->c_id->Visible) { // c_id ?>
	<div id="r_c_id" class="form-group row">
		<label id="elh_ww_color_order_c_id" for="x_c_id" class="<?php echo $ww_color_order_add->LeftColumnClass ?>"><?php echo $ww_color_order->c_id->caption() ?><?php echo ($ww_color_order->c_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ww_color_order_add->RightColumnClass ?>"><div<?php echo $ww_color_order->c_id->cellAttributes() ?>>
<span id="el_ww_color_order_c_id">
<?php $ww_color_order->c_id->EditAttrs["onchange"] = "ew.autoFill(this);" . @$ww_color_order->c_id->EditAttrs["onchange"]; ?>
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ww_color_order" data-field="x_c_id" data-value-separator="<?php echo $ww_color_order->c_id->displayValueSeparatorAttribute() ?>" id="x_c_id" name="x_c_id"<?php echo $ww_color_order->c_id->editAttributes() ?>>
		<?php echo $ww_color_order->c_id->selectOptionListHtml("x_c_id") ?>
	</select>
</div>
<?php echo $ww_color_order->c_id->Lookup->getParamTag("p_x_c_id") ?>
</span>
<?php echo $ww_color_order->c_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ww_color_order->quantity->Visible) { // quantity ?>
	<div id="r_quantity" class="form-group row">
		<label id="elh_ww_color_order_quantity" for="x_quantity" class="<?php echo $ww_color_order_add->LeftColumnClass ?>"><?php echo $ww_color_order->quantity->caption() ?><?php echo ($ww_color_order->quantity->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ww_color_order_add->RightColumnClass ?>"><div<?php echo $ww_color_order->quantity->cellAttributes() ?>>
<span id="el_ww_color_order_quantity">
<input type="text" data-table="ww_color_order" data-field="x_quantity" name="x_quantity" id="x_quantity" size="30" placeholder="<?php echo HtmlEncode($ww_color_order->quantity->getPlaceHolder()) ?>" value="<?php echo $ww_color_order->quantity->EditValue ?>"<?php echo $ww_color_order->quantity->editAttributes() ?>>
</span>
<?php echo $ww_color_order->quantity->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$ww_color_order_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $ww_color_order_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $ww_color_order_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$ww_color_order_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$ww_color_order_add->terminate();
?>