<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$ww_color_order_view = new ww_color_order_view();

// Run the page
$ww_color_order_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$ww_color_order_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$ww_color_order->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fww_color_orderview = currentForm = new ew.Form("fww_color_orderview", "view");

// Form_CustomValidate event
fww_color_orderview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fww_color_orderview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fww_color_orderview.lists["x_period"] = <?php echo $ww_color_order_view->period->Lookup->toClientList() ?>;
fww_color_orderview.lists["x_period"].options = <?php echo JsonEncode($ww_color_order_view->period->lookupOptions()) ?>;
fww_color_orderview.lists["x_c_id"] = <?php echo $ww_color_order_view->c_id->Lookup->toClientList() ?>;
fww_color_orderview.lists["x_c_id"].options = <?php echo JsonEncode($ww_color_order_view->c_id->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$ww_color_order->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $ww_color_order_view->ExportOptions->render("body") ?>
<?php $ww_color_order_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $ww_color_order_view->showPageHeader(); ?>
<?php
$ww_color_order_view->showMessage();
?>
<form name="fww_color_orderview" id="fww_color_orderview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($ww_color_order_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $ww_color_order_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="ww_color_order">
<input type="hidden" name="modal" value="<?php echo (int)$ww_color_order_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($ww_color_order->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $ww_color_order_view->TableLeftColumnClass ?>"><span id="elh_ww_color_order_id"><?php echo $ww_color_order->id->caption() ?></span></td>
		<td data-name="id"<?php echo $ww_color_order->id->cellAttributes() ?>>
<span id="el_ww_color_order_id">
<span<?php echo $ww_color_order->id->viewAttributes() ?>>
<?php echo $ww_color_order->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ww_color_order->period->Visible) { // period ?>
	<tr id="r_period">
		<td class="<?php echo $ww_color_order_view->TableLeftColumnClass ?>"><span id="elh_ww_color_order_period"><?php echo $ww_color_order->period->caption() ?></span></td>
		<td data-name="period"<?php echo $ww_color_order->period->cellAttributes() ?>>
<span id="el_ww_color_order_period">
<span<?php echo $ww_color_order->period->viewAttributes() ?>>
<?php echo $ww_color_order->period->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ww_color_order->c_id->Visible) { // c_id ?>
	<tr id="r_c_id">
		<td class="<?php echo $ww_color_order_view->TableLeftColumnClass ?>"><span id="elh_ww_color_order_c_id"><?php echo $ww_color_order->c_id->caption() ?></span></td>
		<td data-name="c_id"<?php echo $ww_color_order->c_id->cellAttributes() ?>>
<span id="el_ww_color_order_c_id">
<span<?php echo $ww_color_order->c_id->viewAttributes() ?>>
<?php echo $ww_color_order->c_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ww_color_order->quantity->Visible) { // quantity ?>
	<tr id="r_quantity">
		<td class="<?php echo $ww_color_order_view->TableLeftColumnClass ?>"><span id="elh_ww_color_order_quantity"><?php echo $ww_color_order->quantity->caption() ?></span></td>
		<td data-name="quantity"<?php echo $ww_color_order->quantity->cellAttributes() ?>>
<span id="el_ww_color_order_quantity">
<span<?php echo $ww_color_order->quantity->viewAttributes() ?>>
<?php echo $ww_color_order->quantity->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ww_color_order->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $ww_color_order_view->TableLeftColumnClass ?>"><span id="elh_ww_color_order_operator"><?php echo $ww_color_order->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $ww_color_order->operator->cellAttributes() ?>>
<span id="el_ww_color_order_operator">
<span<?php echo $ww_color_order->operator->viewAttributes() ?>>
<?php echo $ww_color_order->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ww_color_order->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $ww_color_order_view->TableLeftColumnClass ?>"><span id="elh_ww_color_order_datetime"><?php echo $ww_color_order->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $ww_color_order->datetime->cellAttributes() ?>>
<span id="el_ww_color_order_datetime">
<span<?php echo $ww_color_order->datetime->viewAttributes() ?>>
<?php echo $ww_color_order->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$ww_color_order_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$ww_color_order->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$ww_color_order_view->terminate();
?>