<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$ww_color_add = new ww_color_add();

// Run the page
$ww_color_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$ww_color_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fww_coloradd = currentForm = new ew.Form("fww_coloradd", "add");

// Validate form
fww_coloradd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($ww_color_add->color->Required) { ?>
			elm = this.getElements("x" + infix + "_color");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ww_color->color->caption(), $ww_color->color->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ww_color_add->color_source->Required) { ?>
			elm = this.getElements("x" + infix + "_color_source");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ww_color->color_source->caption(), $ww_color->color_source->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ww_color_add->base_color->Required) { ?>
			elm = this.getElements("x" + infix + "_base_color");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ww_color->base_color->caption(), $ww_color->base_color->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ww_color_add->match_clariant->Required) { ?>
			elm = this.getElements("x" + infix + "_match_clariant");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ww_color->match_clariant->caption(), $ww_color->match_clariant->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ww_color_add->match_poddar->Required) { ?>
			elm = this.getElements("x" + infix + "_match_poddar");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ww_color->match_poddar->caption(), $ww_color->match_poddar->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ww_color_add->match_polyone->Required) { ?>
			elm = this.getElements("x" + infix + "_match_polyone");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ww_color->match_polyone->caption(), $ww_color->match_polyone->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ww_color_add->moq->Required) { ?>
			elm = this.getElements("x" + infix + "_moq");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ww_color->moq->caption(), $ww_color->moq->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_moq");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($ww_color->moq->errorMessage()) ?>");
		<?php if ($ww_color_add->m_stock->Required) { ?>
			elm = this.getElements("x" + infix + "_m_stock");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ww_color->m_stock->caption(), $ww_color->m_stock->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_m_stock");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($ww_color->m_stock->errorMessage()) ?>");
		<?php if ($ww_color_add->stock->Required) { ?>
			elm = this.getElements("x" + infix + "_stock");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ww_color->stock->caption(), $ww_color->stock->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_stock");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($ww_color->stock->errorMessage()) ?>");
		<?php if ($ww_color_add->status->Required) { ?>
			elm = this.getElements("x" + infix + "_status");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ww_color->status->caption(), $ww_color->status->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ww_color_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ww_color->operator->caption(), $ww_color->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ww_color_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ww_color->datetime->caption(), $ww_color->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fww_coloradd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fww_coloradd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fww_coloradd.lists["x_color_source"] = <?php echo $ww_color_add->color_source->Lookup->toClientList() ?>;
fww_coloradd.lists["x_color_source"].options = <?php echo JsonEncode($ww_color_add->color_source->options(FALSE, TRUE)) ?>;
fww_coloradd.lists["x_base_color"] = <?php echo $ww_color_add->base_color->Lookup->toClientList() ?>;
fww_coloradd.lists["x_base_color"].options = <?php echo JsonEncode($ww_color_add->base_color->options(FALSE, TRUE)) ?>;
fww_coloradd.lists["x_match_clariant"] = <?php echo $ww_color_add->match_clariant->Lookup->toClientList() ?>;
fww_coloradd.lists["x_match_clariant"].options = <?php echo JsonEncode($ww_color_add->match_clariant->lookupOptions()) ?>;
fww_coloradd.lists["x_match_poddar"] = <?php echo $ww_color_add->match_poddar->Lookup->toClientList() ?>;
fww_coloradd.lists["x_match_poddar"].options = <?php echo JsonEncode($ww_color_add->match_poddar->lookupOptions()) ?>;
fww_coloradd.lists["x_match_polyone"] = <?php echo $ww_color_add->match_polyone->Lookup->toClientList() ?>;
fww_coloradd.lists["x_match_polyone"].options = <?php echo JsonEncode($ww_color_add->match_polyone->lookupOptions()) ?>;
fww_coloradd.lists["x_status"] = <?php echo $ww_color_add->status->Lookup->toClientList() ?>;
fww_coloradd.lists["x_status"].options = <?php echo JsonEncode($ww_color_add->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $ww_color_add->showPageHeader(); ?>
<?php
$ww_color_add->showMessage();
?>
<form name="fww_coloradd" id="fww_coloradd" class="<?php echo $ww_color_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($ww_color_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $ww_color_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="ww_color">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$ww_color_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($ww_color->color->Visible) { // color ?>
	<div id="r_color" class="form-group row">
		<label id="elh_ww_color_color" for="x_color" class="<?php echo $ww_color_add->LeftColumnClass ?>"><?php echo $ww_color->color->caption() ?><?php echo ($ww_color->color->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ww_color_add->RightColumnClass ?>"><div<?php echo $ww_color->color->cellAttributes() ?>>
<span id="el_ww_color_color">
<input type="text" data-table="ww_color" data-field="x_color" name="x_color" id="x_color" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ww_color->color->getPlaceHolder()) ?>" value="<?php echo $ww_color->color->EditValue ?>"<?php echo $ww_color->color->editAttributes() ?>>
</span>
<?php echo $ww_color->color->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ww_color->color_source->Visible) { // color_source ?>
	<div id="r_color_source" class="form-group row">
		<label id="elh_ww_color_color_source" for="x_color_source" class="<?php echo $ww_color_add->LeftColumnClass ?>"><?php echo $ww_color->color_source->caption() ?><?php echo ($ww_color->color_source->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ww_color_add->RightColumnClass ?>"><div<?php echo $ww_color->color_source->cellAttributes() ?>>
<span id="el_ww_color_color_source">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ww_color" data-field="x_color_source" data-value-separator="<?php echo $ww_color->color_source->displayValueSeparatorAttribute() ?>" id="x_color_source" name="x_color_source"<?php echo $ww_color->color_source->editAttributes() ?>>
		<?php echo $ww_color->color_source->selectOptionListHtml("x_color_source") ?>
	</select>
</div>
</span>
<?php echo $ww_color->color_source->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ww_color->base_color->Visible) { // base_color ?>
	<div id="r_base_color" class="form-group row">
		<label id="elh_ww_color_base_color" for="x_base_color" class="<?php echo $ww_color_add->LeftColumnClass ?>"><?php echo $ww_color->base_color->caption() ?><?php echo ($ww_color->base_color->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ww_color_add->RightColumnClass ?>"><div<?php echo $ww_color->base_color->cellAttributes() ?>>
<span id="el_ww_color_base_color">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ww_color" data-field="x_base_color" data-value-separator="<?php echo $ww_color->base_color->displayValueSeparatorAttribute() ?>" id="x_base_color" name="x_base_color"<?php echo $ww_color->base_color->editAttributes() ?>>
		<?php echo $ww_color->base_color->selectOptionListHtml("x_base_color") ?>
	</select>
</div>
</span>
<?php echo $ww_color->base_color->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ww_color->match_clariant->Visible) { // match_clariant ?>
	<div id="r_match_clariant" class="form-group row">
		<label id="elh_ww_color_match_clariant" for="x_match_clariant" class="<?php echo $ww_color_add->LeftColumnClass ?>"><?php echo $ww_color->match_clariant->caption() ?><?php echo ($ww_color->match_clariant->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ww_color_add->RightColumnClass ?>"><div<?php echo $ww_color->match_clariant->cellAttributes() ?>>
<span id="el_ww_color_match_clariant">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ww_color" data-field="x_match_clariant" data-value-separator="<?php echo $ww_color->match_clariant->displayValueSeparatorAttribute() ?>" id="x_match_clariant" name="x_match_clariant"<?php echo $ww_color->match_clariant->editAttributes() ?>>
		<?php echo $ww_color->match_clariant->selectOptionListHtml("x_match_clariant") ?>
	</select>
</div>
<?php echo $ww_color->match_clariant->Lookup->getParamTag("p_x_match_clariant") ?>
</span>
<?php echo $ww_color->match_clariant->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ww_color->match_poddar->Visible) { // match_poddar ?>
	<div id="r_match_poddar" class="form-group row">
		<label id="elh_ww_color_match_poddar" for="x_match_poddar" class="<?php echo $ww_color_add->LeftColumnClass ?>"><?php echo $ww_color->match_poddar->caption() ?><?php echo ($ww_color->match_poddar->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ww_color_add->RightColumnClass ?>"><div<?php echo $ww_color->match_poddar->cellAttributes() ?>>
<span id="el_ww_color_match_poddar">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ww_color" data-field="x_match_poddar" data-value-separator="<?php echo $ww_color->match_poddar->displayValueSeparatorAttribute() ?>" id="x_match_poddar" name="x_match_poddar"<?php echo $ww_color->match_poddar->editAttributes() ?>>
		<?php echo $ww_color->match_poddar->selectOptionListHtml("x_match_poddar") ?>
	</select>
</div>
<?php echo $ww_color->match_poddar->Lookup->getParamTag("p_x_match_poddar") ?>
</span>
<?php echo $ww_color->match_poddar->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ww_color->match_polyone->Visible) { // match_polyone ?>
	<div id="r_match_polyone" class="form-group row">
		<label id="elh_ww_color_match_polyone" for="x_match_polyone" class="<?php echo $ww_color_add->LeftColumnClass ?>"><?php echo $ww_color->match_polyone->caption() ?><?php echo ($ww_color->match_polyone->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ww_color_add->RightColumnClass ?>"><div<?php echo $ww_color->match_polyone->cellAttributes() ?>>
<span id="el_ww_color_match_polyone">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ww_color" data-field="x_match_polyone" data-value-separator="<?php echo $ww_color->match_polyone->displayValueSeparatorAttribute() ?>" id="x_match_polyone" name="x_match_polyone"<?php echo $ww_color->match_polyone->editAttributes() ?>>
		<?php echo $ww_color->match_polyone->selectOptionListHtml("x_match_polyone") ?>
	</select>
</div>
<?php echo $ww_color->match_polyone->Lookup->getParamTag("p_x_match_polyone") ?>
</span>
<?php echo $ww_color->match_polyone->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ww_color->moq->Visible) { // moq ?>
	<div id="r_moq" class="form-group row">
		<label id="elh_ww_color_moq" for="x_moq" class="<?php echo $ww_color_add->LeftColumnClass ?>"><?php echo $ww_color->moq->caption() ?><?php echo ($ww_color->moq->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ww_color_add->RightColumnClass ?>"><div<?php echo $ww_color->moq->cellAttributes() ?>>
<span id="el_ww_color_moq">
<input type="text" data-table="ww_color" data-field="x_moq" name="x_moq" id="x_moq" size="30" placeholder="<?php echo HtmlEncode($ww_color->moq->getPlaceHolder()) ?>" value="<?php echo $ww_color->moq->EditValue ?>"<?php echo $ww_color->moq->editAttributes() ?>>
</span>
<?php echo $ww_color->moq->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ww_color->m_stock->Visible) { // m_stock ?>
	<div id="r_m_stock" class="form-group row">
		<label id="elh_ww_color_m_stock" for="x_m_stock" class="<?php echo $ww_color_add->LeftColumnClass ?>"><?php echo $ww_color->m_stock->caption() ?><?php echo ($ww_color->m_stock->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ww_color_add->RightColumnClass ?>"><div<?php echo $ww_color->m_stock->cellAttributes() ?>>
<span id="el_ww_color_m_stock">
<input type="text" data-table="ww_color" data-field="x_m_stock" name="x_m_stock" id="x_m_stock" size="30" placeholder="<?php echo HtmlEncode($ww_color->m_stock->getPlaceHolder()) ?>" value="<?php echo $ww_color->m_stock->EditValue ?>"<?php echo $ww_color->m_stock->editAttributes() ?>>
</span>
<?php echo $ww_color->m_stock->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ww_color->stock->Visible) { // stock ?>
	<div id="r_stock" class="form-group row">
		<label id="elh_ww_color_stock" for="x_stock" class="<?php echo $ww_color_add->LeftColumnClass ?>"><?php echo $ww_color->stock->caption() ?><?php echo ($ww_color->stock->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ww_color_add->RightColumnClass ?>"><div<?php echo $ww_color->stock->cellAttributes() ?>>
<span id="el_ww_color_stock">
<input type="text" data-table="ww_color" data-field="x_stock" name="x_stock" id="x_stock" size="30" placeholder="<?php echo HtmlEncode($ww_color->stock->getPlaceHolder()) ?>" value="<?php echo $ww_color->stock->EditValue ?>"<?php echo $ww_color->stock->editAttributes() ?>>
</span>
<?php echo $ww_color->stock->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ww_color->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label id="elh_ww_color_status" for="x_status" class="<?php echo $ww_color_add->LeftColumnClass ?>"><?php echo $ww_color->status->caption() ?><?php echo ($ww_color->status->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ww_color_add->RightColumnClass ?>"><div<?php echo $ww_color->status->cellAttributes() ?>>
<span id="el_ww_color_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ww_color" data-field="x_status" data-value-separator="<?php echo $ww_color->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $ww_color->status->editAttributes() ?>>
		<?php echo $ww_color->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
<?php echo $ww_color->status->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$ww_color_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $ww_color_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $ww_color_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$ww_color_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$ww_color_add->terminate();
?>