<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$ww_color_list = new ww_color_list();

// Run the page
$ww_color_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$ww_color_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$ww_color->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fww_colorlist = currentForm = new ew.Form("fww_colorlist", "list");
fww_colorlist.formKeyCountName = '<?php echo $ww_color_list->FormKeyCountName ?>';

// Form_CustomValidate event
fww_colorlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fww_colorlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fww_colorlist.lists["x_color_source"] = <?php echo $ww_color_list->color_source->Lookup->toClientList() ?>;
fww_colorlist.lists["x_color_source"].options = <?php echo JsonEncode($ww_color_list->color_source->options(FALSE, TRUE)) ?>;
fww_colorlist.lists["x_base_color"] = <?php echo $ww_color_list->base_color->Lookup->toClientList() ?>;
fww_colorlist.lists["x_base_color"].options = <?php echo JsonEncode($ww_color_list->base_color->options(FALSE, TRUE)) ?>;
fww_colorlist.lists["x_match_clariant"] = <?php echo $ww_color_list->match_clariant->Lookup->toClientList() ?>;
fww_colorlist.lists["x_match_clariant"].options = <?php echo JsonEncode($ww_color_list->match_clariant->lookupOptions()) ?>;
fww_colorlist.lists["x_match_poddar"] = <?php echo $ww_color_list->match_poddar->Lookup->toClientList() ?>;
fww_colorlist.lists["x_match_poddar"].options = <?php echo JsonEncode($ww_color_list->match_poddar->lookupOptions()) ?>;
fww_colorlist.lists["x_match_polyone"] = <?php echo $ww_color_list->match_polyone->Lookup->toClientList() ?>;
fww_colorlist.lists["x_match_polyone"].options = <?php echo JsonEncode($ww_color_list->match_polyone->lookupOptions()) ?>;
fww_colorlist.lists["x_status"] = <?php echo $ww_color_list->status->Lookup->toClientList() ?>;
fww_colorlist.lists["x_status"].options = <?php echo JsonEncode($ww_color_list->status->options(FALSE, TRUE)) ?>;

// Form object for search
var fww_colorlistsrch = currentSearchForm = new ew.Form("fww_colorlistsrch");

// Filters
fww_colorlistsrch.filterList = <?php echo $ww_color_list->getFilterList() ?>;

// Init search panel as collapsed
fww_colorlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$ww_color->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($ww_color_list->TotalRecs > 0 && $ww_color_list->ExportOptions->visible()) { ?>
<?php $ww_color_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($ww_color_list->ImportOptions->visible()) { ?>
<?php $ww_color_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($ww_color_list->SearchOptions->visible()) { ?>
<?php $ww_color_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($ww_color_list->FilterOptions->visible()) { ?>
<?php $ww_color_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$ww_color_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$ww_color->isExport() && !$ww_color->CurrentAction) { ?>
<form name="fww_colorlistsrch" id="fww_colorlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($ww_color_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fww_colorlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="ww_color">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($ww_color_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($ww_color_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $ww_color_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($ww_color_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($ww_color_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($ww_color_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($ww_color_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $ww_color_list->showPageHeader(); ?>
<?php
$ww_color_list->showMessage();
?>
<?php if ($ww_color_list->TotalRecs > 0 || $ww_color->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($ww_color_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> ww_color">
<?php if (!$ww_color->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$ww_color->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($ww_color_list->Pager)) $ww_color_list->Pager = new PrevNextPager($ww_color_list->StartRec, $ww_color_list->DisplayRecs, $ww_color_list->TotalRecs, $ww_color_list->AutoHidePager) ?>
<?php if ($ww_color_list->Pager->RecordCount > 0 && $ww_color_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($ww_color_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $ww_color_list->pageUrl() ?>start=<?php echo $ww_color_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($ww_color_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $ww_color_list->pageUrl() ?>start=<?php echo $ww_color_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $ww_color_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($ww_color_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $ww_color_list->pageUrl() ?>start=<?php echo $ww_color_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($ww_color_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $ww_color_list->pageUrl() ?>start=<?php echo $ww_color_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $ww_color_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($ww_color_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $ww_color_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $ww_color_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $ww_color_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($ww_color_list->TotalRecs > 0 && (!$ww_color_list->AutoHidePageSizeSelector || $ww_color_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="ww_color">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($ww_color_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($ww_color_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($ww_color_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($ww_color_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($ww_color_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($ww_color->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $ww_color_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fww_colorlist" id="fww_colorlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($ww_color_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $ww_color_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="ww_color">
<div id="gmp_ww_color" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($ww_color_list->TotalRecs > 0 || $ww_color->isGridEdit()) { ?>
<table id="tbl_ww_colorlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$ww_color_list->RowType = ROWTYPE_HEADER;

// Render list options
$ww_color_list->renderListOptions();

// Render list options (header, left)
$ww_color_list->ListOptions->render("header", "left");
?>
<?php if ($ww_color->id->Visible) { // id ?>
	<?php if ($ww_color->sortUrl($ww_color->id) == "") { ?>
		<th data-name="id" class="<?php echo $ww_color->id->headerCellClass() ?>"><div id="elh_ww_color_id" class="ww_color_id"><div class="ew-table-header-caption"><?php echo $ww_color->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $ww_color->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ww_color->SortUrl($ww_color->id) ?>',2);"><div id="elh_ww_color_id" class="ww_color_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ww_color->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($ww_color->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ww_color->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ww_color->color->Visible) { // color ?>
	<?php if ($ww_color->sortUrl($ww_color->color) == "") { ?>
		<th data-name="color" class="<?php echo $ww_color->color->headerCellClass() ?>"><div id="elh_ww_color_color" class="ww_color_color"><div class="ew-table-header-caption"><?php echo $ww_color->color->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="color" class="<?php echo $ww_color->color->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ww_color->SortUrl($ww_color->color) ?>',2);"><div id="elh_ww_color_color" class="ww_color_color">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ww_color->color->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ww_color->color->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ww_color->color->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ww_color->color_source->Visible) { // color_source ?>
	<?php if ($ww_color->sortUrl($ww_color->color_source) == "") { ?>
		<th data-name="color_source" class="<?php echo $ww_color->color_source->headerCellClass() ?>"><div id="elh_ww_color_color_source" class="ww_color_color_source"><div class="ew-table-header-caption"><?php echo $ww_color->color_source->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="color_source" class="<?php echo $ww_color->color_source->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ww_color->SortUrl($ww_color->color_source) ?>',2);"><div id="elh_ww_color_color_source" class="ww_color_color_source">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ww_color->color_source->caption() ?></span><span class="ew-table-header-sort"><?php if ($ww_color->color_source->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ww_color->color_source->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ww_color->base_color->Visible) { // base_color ?>
	<?php if ($ww_color->sortUrl($ww_color->base_color) == "") { ?>
		<th data-name="base_color" class="<?php echo $ww_color->base_color->headerCellClass() ?>"><div id="elh_ww_color_base_color" class="ww_color_base_color"><div class="ew-table-header-caption"><?php echo $ww_color->base_color->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="base_color" class="<?php echo $ww_color->base_color->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ww_color->SortUrl($ww_color->base_color) ?>',2);"><div id="elh_ww_color_base_color" class="ww_color_base_color">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ww_color->base_color->caption() ?></span><span class="ew-table-header-sort"><?php if ($ww_color->base_color->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ww_color->base_color->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ww_color->match_clariant->Visible) { // match_clariant ?>
	<?php if ($ww_color->sortUrl($ww_color->match_clariant) == "") { ?>
		<th data-name="match_clariant" class="<?php echo $ww_color->match_clariant->headerCellClass() ?>"><div id="elh_ww_color_match_clariant" class="ww_color_match_clariant"><div class="ew-table-header-caption"><?php echo $ww_color->match_clariant->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="match_clariant" class="<?php echo $ww_color->match_clariant->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ww_color->SortUrl($ww_color->match_clariant) ?>',2);"><div id="elh_ww_color_match_clariant" class="ww_color_match_clariant">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ww_color->match_clariant->caption() ?></span><span class="ew-table-header-sort"><?php if ($ww_color->match_clariant->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ww_color->match_clariant->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ww_color->match_poddar->Visible) { // match_poddar ?>
	<?php if ($ww_color->sortUrl($ww_color->match_poddar) == "") { ?>
		<th data-name="match_poddar" class="<?php echo $ww_color->match_poddar->headerCellClass() ?>"><div id="elh_ww_color_match_poddar" class="ww_color_match_poddar"><div class="ew-table-header-caption"><?php echo $ww_color->match_poddar->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="match_poddar" class="<?php echo $ww_color->match_poddar->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ww_color->SortUrl($ww_color->match_poddar) ?>',2);"><div id="elh_ww_color_match_poddar" class="ww_color_match_poddar">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ww_color->match_poddar->caption() ?></span><span class="ew-table-header-sort"><?php if ($ww_color->match_poddar->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ww_color->match_poddar->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ww_color->match_polyone->Visible) { // match_polyone ?>
	<?php if ($ww_color->sortUrl($ww_color->match_polyone) == "") { ?>
		<th data-name="match_polyone" class="<?php echo $ww_color->match_polyone->headerCellClass() ?>"><div id="elh_ww_color_match_polyone" class="ww_color_match_polyone"><div class="ew-table-header-caption"><?php echo $ww_color->match_polyone->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="match_polyone" class="<?php echo $ww_color->match_polyone->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ww_color->SortUrl($ww_color->match_polyone) ?>',2);"><div id="elh_ww_color_match_polyone" class="ww_color_match_polyone">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ww_color->match_polyone->caption() ?></span><span class="ew-table-header-sort"><?php if ($ww_color->match_polyone->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ww_color->match_polyone->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ww_color->moq->Visible) { // moq ?>
	<?php if ($ww_color->sortUrl($ww_color->moq) == "") { ?>
		<th data-name="moq" class="<?php echo $ww_color->moq->headerCellClass() ?>"><div id="elh_ww_color_moq" class="ww_color_moq"><div class="ew-table-header-caption"><?php echo $ww_color->moq->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="moq" class="<?php echo $ww_color->moq->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ww_color->SortUrl($ww_color->moq) ?>',2);"><div id="elh_ww_color_moq" class="ww_color_moq">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ww_color->moq->caption() ?></span><span class="ew-table-header-sort"><?php if ($ww_color->moq->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ww_color->moq->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ww_color->m_stock->Visible) { // m_stock ?>
	<?php if ($ww_color->sortUrl($ww_color->m_stock) == "") { ?>
		<th data-name="m_stock" class="<?php echo $ww_color->m_stock->headerCellClass() ?>"><div id="elh_ww_color_m_stock" class="ww_color_m_stock"><div class="ew-table-header-caption"><?php echo $ww_color->m_stock->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="m_stock" class="<?php echo $ww_color->m_stock->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ww_color->SortUrl($ww_color->m_stock) ?>',2);"><div id="elh_ww_color_m_stock" class="ww_color_m_stock">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ww_color->m_stock->caption() ?></span><span class="ew-table-header-sort"><?php if ($ww_color->m_stock->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ww_color->m_stock->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ww_color->stock->Visible) { // stock ?>
	<?php if ($ww_color->sortUrl($ww_color->stock) == "") { ?>
		<th data-name="stock" class="<?php echo $ww_color->stock->headerCellClass() ?>"><div id="elh_ww_color_stock" class="ww_color_stock"><div class="ew-table-header-caption"><?php echo $ww_color->stock->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="stock" class="<?php echo $ww_color->stock->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ww_color->SortUrl($ww_color->stock) ?>',2);"><div id="elh_ww_color_stock" class="ww_color_stock">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ww_color->stock->caption() ?></span><span class="ew-table-header-sort"><?php if ($ww_color->stock->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ww_color->stock->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ww_color->required->Visible) { // required ?>
	<?php if ($ww_color->sortUrl($ww_color->required) == "") { ?>
		<th data-name="required" class="<?php echo $ww_color->required->headerCellClass() ?>"><div id="elh_ww_color_required" class="ww_color_required"><div class="ew-table-header-caption"><?php echo $ww_color->required->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="required" class="<?php echo $ww_color->required->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ww_color->SortUrl($ww_color->required) ?>',2);"><div id="elh_ww_color_required" class="ww_color_required">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ww_color->required->caption() ?></span><span class="ew-table-header-sort"><?php if ($ww_color->required->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ww_color->required->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ww_color->ordered->Visible) { // ordered ?>
	<?php if ($ww_color->sortUrl($ww_color->ordered) == "") { ?>
		<th data-name="ordered" class="<?php echo $ww_color->ordered->headerCellClass() ?>"><div id="elh_ww_color_ordered" class="ww_color_ordered"><div class="ew-table-header-caption"><?php echo $ww_color->ordered->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ordered" class="<?php echo $ww_color->ordered->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ww_color->SortUrl($ww_color->ordered) ?>',2);"><div id="elh_ww_color_ordered" class="ww_color_ordered">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ww_color->ordered->caption() ?></span><span class="ew-table-header-sort"><?php if ($ww_color->ordered->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ww_color->ordered->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ww_color->pending_order->Visible) { // pending_order ?>
	<?php if ($ww_color->sortUrl($ww_color->pending_order) == "") { ?>
		<th data-name="pending_order" class="<?php echo $ww_color->pending_order->headerCellClass() ?>"><div id="elh_ww_color_pending_order" class="ww_color_pending_order"><div class="ew-table-header-caption"><?php echo $ww_color->pending_order->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pending_order" class="<?php echo $ww_color->pending_order->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ww_color->SortUrl($ww_color->pending_order) ?>',2);"><div id="elh_ww_color_pending_order" class="ww_color_pending_order">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ww_color->pending_order->caption() ?></span><span class="ew-table-header-sort"><?php if ($ww_color->pending_order->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ww_color->pending_order->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ww_color->status->Visible) { // status ?>
	<?php if ($ww_color->sortUrl($ww_color->status) == "") { ?>
		<th data-name="status" class="<?php echo $ww_color->status->headerCellClass() ?>"><div id="elh_ww_color_status" class="ww_color_status"><div class="ew-table-header-caption"><?php echo $ww_color->status->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="status" class="<?php echo $ww_color->status->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ww_color->SortUrl($ww_color->status) ?>',2);"><div id="elh_ww_color_status" class="ww_color_status">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ww_color->status->caption() ?></span><span class="ew-table-header-sort"><?php if ($ww_color->status->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ww_color->status->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ww_color->operator->Visible) { // operator ?>
	<?php if ($ww_color->sortUrl($ww_color->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $ww_color->operator->headerCellClass() ?>"><div id="elh_ww_color_operator" class="ww_color_operator"><div class="ew-table-header-caption"><?php echo $ww_color->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $ww_color->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ww_color->SortUrl($ww_color->operator) ?>',2);"><div id="elh_ww_color_operator" class="ww_color_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ww_color->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($ww_color->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ww_color->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ww_color->datetime->Visible) { // datetime ?>
	<?php if ($ww_color->sortUrl($ww_color->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $ww_color->datetime->headerCellClass() ?>"><div id="elh_ww_color_datetime" class="ww_color_datetime"><div class="ew-table-header-caption"><?php echo $ww_color->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $ww_color->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ww_color->SortUrl($ww_color->datetime) ?>',2);"><div id="elh_ww_color_datetime" class="ww_color_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ww_color->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($ww_color->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ww_color->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$ww_color_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($ww_color->ExportAll && $ww_color->isExport()) {
	$ww_color_list->StopRec = $ww_color_list->TotalRecs;
} else {

	// Set the last record to display
	if ($ww_color_list->TotalRecs > $ww_color_list->StartRec + $ww_color_list->DisplayRecs - 1)
		$ww_color_list->StopRec = $ww_color_list->StartRec + $ww_color_list->DisplayRecs - 1;
	else
		$ww_color_list->StopRec = $ww_color_list->TotalRecs;
}
$ww_color_list->RecCnt = $ww_color_list->StartRec - 1;
if ($ww_color_list->Recordset && !$ww_color_list->Recordset->EOF) {
	$ww_color_list->Recordset->moveFirst();
	$selectLimit = $ww_color_list->UseSelectLimit;
	if (!$selectLimit && $ww_color_list->StartRec > 1)
		$ww_color_list->Recordset->move($ww_color_list->StartRec - 1);
} elseif (!$ww_color->AllowAddDeleteRow && $ww_color_list->StopRec == 0) {
	$ww_color_list->StopRec = $ww_color->GridAddRowCount;
}

// Initialize aggregate
$ww_color->RowType = ROWTYPE_AGGREGATEINIT;
$ww_color->resetAttributes();
$ww_color_list->renderRow();
while ($ww_color_list->RecCnt < $ww_color_list->StopRec) {
	$ww_color_list->RecCnt++;
	if ($ww_color_list->RecCnt >= $ww_color_list->StartRec) {
		$ww_color_list->RowCnt++;

		// Set up key count
		$ww_color_list->KeyCount = $ww_color_list->RowIndex;

		// Init row class and style
		$ww_color->resetAttributes();
		$ww_color->CssClass = "";
		if ($ww_color->isGridAdd()) {
		} else {
			$ww_color_list->loadRowValues($ww_color_list->Recordset); // Load row values
		}
		$ww_color->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$ww_color->RowAttrs = array_merge($ww_color->RowAttrs, array('data-rowindex'=>$ww_color_list->RowCnt, 'id'=>'r' . $ww_color_list->RowCnt . '_ww_color', 'data-rowtype'=>$ww_color->RowType));

		// Render row
		$ww_color_list->renderRow();

		// Render list options
		$ww_color_list->renderListOptions();
?>
	<tr<?php echo $ww_color->rowAttributes() ?>>
<?php

// Render list options (body, left)
$ww_color_list->ListOptions->render("body", "left", $ww_color_list->RowCnt);
?>
	<?php if ($ww_color->id->Visible) { // id ?>
		<td data-name="id"<?php echo $ww_color->id->cellAttributes() ?>>
<span id="el<?php echo $ww_color_list->RowCnt ?>_ww_color_id" class="ww_color_id">
<span<?php echo $ww_color->id->viewAttributes() ?>>
<?php echo $ww_color->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ww_color->color->Visible) { // color ?>
		<td data-name="color"<?php echo $ww_color->color->cellAttributes() ?>>
<span id="el<?php echo $ww_color_list->RowCnt ?>_ww_color_color" class="ww_color_color">
<span<?php echo $ww_color->color->viewAttributes() ?>>
<?php echo $ww_color->color->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ww_color->color_source->Visible) { // color_source ?>
		<td data-name="color_source"<?php echo $ww_color->color_source->cellAttributes() ?>>
<span id="el<?php echo $ww_color_list->RowCnt ?>_ww_color_color_source" class="ww_color_color_source">
<span<?php echo $ww_color->color_source->viewAttributes() ?>>
<?php echo $ww_color->color_source->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ww_color->base_color->Visible) { // base_color ?>
		<td data-name="base_color"<?php echo $ww_color->base_color->cellAttributes() ?>>
<span id="el<?php echo $ww_color_list->RowCnt ?>_ww_color_base_color" class="ww_color_base_color">
<span<?php echo $ww_color->base_color->viewAttributes() ?>>
<?php echo $ww_color->base_color->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ww_color->match_clariant->Visible) { // match_clariant ?>
		<td data-name="match_clariant"<?php echo $ww_color->match_clariant->cellAttributes() ?>>
<span id="el<?php echo $ww_color_list->RowCnt ?>_ww_color_match_clariant" class="ww_color_match_clariant">
<span<?php echo $ww_color->match_clariant->viewAttributes() ?>>
<?php echo $ww_color->match_clariant->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ww_color->match_poddar->Visible) { // match_poddar ?>
		<td data-name="match_poddar"<?php echo $ww_color->match_poddar->cellAttributes() ?>>
<span id="el<?php echo $ww_color_list->RowCnt ?>_ww_color_match_poddar" class="ww_color_match_poddar">
<span<?php echo $ww_color->match_poddar->viewAttributes() ?>>
<?php echo $ww_color->match_poddar->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ww_color->match_polyone->Visible) { // match_polyone ?>
		<td data-name="match_polyone"<?php echo $ww_color->match_polyone->cellAttributes() ?>>
<span id="el<?php echo $ww_color_list->RowCnt ?>_ww_color_match_polyone" class="ww_color_match_polyone">
<span<?php echo $ww_color->match_polyone->viewAttributes() ?>>
<?php echo $ww_color->match_polyone->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ww_color->moq->Visible) { // moq ?>
		<td data-name="moq"<?php echo $ww_color->moq->cellAttributes() ?>>
<span id="el<?php echo $ww_color_list->RowCnt ?>_ww_color_moq" class="ww_color_moq">
<span<?php echo $ww_color->moq->viewAttributes() ?>>
<?php echo $ww_color->moq->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ww_color->m_stock->Visible) { // m_stock ?>
		<td data-name="m_stock"<?php echo $ww_color->m_stock->cellAttributes() ?>>
<span id="el<?php echo $ww_color_list->RowCnt ?>_ww_color_m_stock" class="ww_color_m_stock">
<span<?php echo $ww_color->m_stock->viewAttributes() ?>>
<?php echo $ww_color->m_stock->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ww_color->stock->Visible) { // stock ?>
		<td data-name="stock"<?php echo $ww_color->stock->cellAttributes() ?>>
<span id="el<?php echo $ww_color_list->RowCnt ?>_ww_color_stock" class="ww_color_stock">
<span<?php echo $ww_color->stock->viewAttributes() ?>>
<?php echo $ww_color->stock->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ww_color->required->Visible) { // required ?>
		<td data-name="required"<?php echo $ww_color->required->cellAttributes() ?>>
<span id="el<?php echo $ww_color_list->RowCnt ?>_ww_color_required" class="ww_color_required">
<span<?php echo $ww_color->required->viewAttributes() ?>>
<?php echo $ww_color->required->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ww_color->ordered->Visible) { // ordered ?>
		<td data-name="ordered"<?php echo $ww_color->ordered->cellAttributes() ?>>
<span id="el<?php echo $ww_color_list->RowCnt ?>_ww_color_ordered" class="ww_color_ordered">
<span<?php echo $ww_color->ordered->viewAttributes() ?>>
<?php echo $ww_color->ordered->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ww_color->pending_order->Visible) { // pending_order ?>
		<td data-name="pending_order"<?php echo $ww_color->pending_order->cellAttributes() ?>>
<span id="el<?php echo $ww_color_list->RowCnt ?>_ww_color_pending_order" class="ww_color_pending_order">
<span<?php echo $ww_color->pending_order->viewAttributes() ?>>
<?php echo $ww_color->pending_order->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ww_color->status->Visible) { // status ?>
		<td data-name="status"<?php echo $ww_color->status->cellAttributes() ?>>
<span id="el<?php echo $ww_color_list->RowCnt ?>_ww_color_status" class="ww_color_status">
<span<?php echo $ww_color->status->viewAttributes() ?>>
<?php echo $ww_color->status->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ww_color->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $ww_color->operator->cellAttributes() ?>>
<span id="el<?php echo $ww_color_list->RowCnt ?>_ww_color_operator" class="ww_color_operator">
<span<?php echo $ww_color->operator->viewAttributes() ?>>
<?php echo $ww_color->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ww_color->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $ww_color->datetime->cellAttributes() ?>>
<span id="el<?php echo $ww_color_list->RowCnt ?>_ww_color_datetime" class="ww_color_datetime">
<span<?php echo $ww_color->datetime->viewAttributes() ?>>
<?php echo $ww_color->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$ww_color_list->ListOptions->render("body", "right", $ww_color_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$ww_color->isGridAdd())
		$ww_color_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$ww_color->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($ww_color_list->Recordset)
	$ww_color_list->Recordset->Close();
?>
<?php if (!$ww_color->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$ww_color->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($ww_color_list->Pager)) $ww_color_list->Pager = new PrevNextPager($ww_color_list->StartRec, $ww_color_list->DisplayRecs, $ww_color_list->TotalRecs, $ww_color_list->AutoHidePager) ?>
<?php if ($ww_color_list->Pager->RecordCount > 0 && $ww_color_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($ww_color_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $ww_color_list->pageUrl() ?>start=<?php echo $ww_color_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($ww_color_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $ww_color_list->pageUrl() ?>start=<?php echo $ww_color_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $ww_color_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($ww_color_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $ww_color_list->pageUrl() ?>start=<?php echo $ww_color_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($ww_color_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $ww_color_list->pageUrl() ?>start=<?php echo $ww_color_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $ww_color_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($ww_color_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $ww_color_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $ww_color_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $ww_color_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($ww_color_list->TotalRecs > 0 && (!$ww_color_list->AutoHidePageSizeSelector || $ww_color_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="ww_color">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($ww_color_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($ww_color_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($ww_color_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($ww_color_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($ww_color_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($ww_color->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $ww_color_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($ww_color_list->TotalRecs == 0 && !$ww_color->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $ww_color_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$ww_color_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$ww_color->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$ww_color->isExport()) { ?>
<script>
ew.scrollableTable("gmp_ww_color", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$ww_color_list->terminate();
?>