<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$ww_color_search = new ww_color_search();

// Run the page
$ww_color_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$ww_color_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($ww_color_search->IsModal) { ?>
var fww_colorsearch = currentAdvancedSearchForm = new ew.Form("fww_colorsearch", "search");
<?php } else { ?>
var fww_colorsearch = currentForm = new ew.Form("fww_colorsearch", "search");
<?php } ?>

// Form_CustomValidate event
fww_colorsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fww_colorsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fww_colorsearch.lists["x_color_source"] = <?php echo $ww_color_search->color_source->Lookup->toClientList() ?>;
fww_colorsearch.lists["x_color_source"].options = <?php echo JsonEncode($ww_color_search->color_source->options(FALSE, TRUE)) ?>;
fww_colorsearch.lists["x_base_color"] = <?php echo $ww_color_search->base_color->Lookup->toClientList() ?>;
fww_colorsearch.lists["x_base_color"].options = <?php echo JsonEncode($ww_color_search->base_color->options(FALSE, TRUE)) ?>;
fww_colorsearch.lists["x_match_clariant"] = <?php echo $ww_color_search->match_clariant->Lookup->toClientList() ?>;
fww_colorsearch.lists["x_match_clariant"].options = <?php echo JsonEncode($ww_color_search->match_clariant->lookupOptions()) ?>;
fww_colorsearch.lists["x_match_poddar"] = <?php echo $ww_color_search->match_poddar->Lookup->toClientList() ?>;
fww_colorsearch.lists["x_match_poddar"].options = <?php echo JsonEncode($ww_color_search->match_poddar->lookupOptions()) ?>;
fww_colorsearch.lists["x_match_polyone"] = <?php echo $ww_color_search->match_polyone->Lookup->toClientList() ?>;
fww_colorsearch.lists["x_match_polyone"].options = <?php echo JsonEncode($ww_color_search->match_polyone->lookupOptions()) ?>;
fww_colorsearch.lists["x_status"] = <?php echo $ww_color_search->status->Lookup->toClientList() ?>;
fww_colorsearch.lists["x_status"].options = <?php echo JsonEncode($ww_color_search->status->options(FALSE, TRUE)) ?>;

// Form object for search
// Validate function for search

fww_colorsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_id");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($ww_color->id->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_moq");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($ww_color->moq->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_m_stock");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($ww_color->m_stock->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_stock");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($ww_color->stock->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_required");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($ww_color->required->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_ordered");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($ww_color->ordered->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pending_order");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($ww_color->pending_order->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($ww_color->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($ww_color->datetime->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $ww_color_search->showPageHeader(); ?>
<?php
$ww_color_search->showMessage();
?>
<form name="fww_colorsearch" id="fww_colorsearch" class="<?php echo $ww_color_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($ww_color_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $ww_color_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="ww_color">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$ww_color_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($ww_color->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $ww_color_search->LeftColumnClass ?>"><span id="elh_ww_color_id"><?php echo $ww_color->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_id" id="z_id" value="="></span>
		</label>
		<div class="<?php echo $ww_color_search->RightColumnClass ?>"><div<?php echo $ww_color->id->cellAttributes() ?>>
			<span id="el_ww_color_id">
<input type="text" data-table="ww_color" data-field="x_id" name="x_id" id="x_id" placeholder="<?php echo HtmlEncode($ww_color->id->getPlaceHolder()) ?>" value="<?php echo $ww_color->id->EditValue ?>"<?php echo $ww_color->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ww_color->color->Visible) { // color ?>
	<div id="r_color" class="form-group row">
		<label for="x_color" class="<?php echo $ww_color_search->LeftColumnClass ?>"><span id="elh_ww_color_color"><?php echo $ww_color->color->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_color" id="z_color" value="LIKE"></span>
		</label>
		<div class="<?php echo $ww_color_search->RightColumnClass ?>"><div<?php echo $ww_color->color->cellAttributes() ?>>
			<span id="el_ww_color_color">
<input type="text" data-table="ww_color" data-field="x_color" name="x_color" id="x_color" size="30" maxlength="96" placeholder="<?php echo HtmlEncode($ww_color->color->getPlaceHolder()) ?>" value="<?php echo $ww_color->color->EditValue ?>"<?php echo $ww_color->color->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ww_color->color_source->Visible) { // color_source ?>
	<div id="r_color_source" class="form-group row">
		<label for="x_color_source" class="<?php echo $ww_color_search->LeftColumnClass ?>"><span id="elh_ww_color_color_source"><?php echo $ww_color->color_source->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_color_source" id="z_color_source" value="LIKE"></span>
		</label>
		<div class="<?php echo $ww_color_search->RightColumnClass ?>"><div<?php echo $ww_color->color_source->cellAttributes() ?>>
			<span id="el_ww_color_color_source">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ww_color" data-field="x_color_source" data-value-separator="<?php echo $ww_color->color_source->displayValueSeparatorAttribute() ?>" id="x_color_source" name="x_color_source"<?php echo $ww_color->color_source->editAttributes() ?>>
		<?php echo $ww_color->color_source->selectOptionListHtml("x_color_source") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ww_color->base_color->Visible) { // base_color ?>
	<div id="r_base_color" class="form-group row">
		<label for="x_base_color" class="<?php echo $ww_color_search->LeftColumnClass ?>"><span id="elh_ww_color_base_color"><?php echo $ww_color->base_color->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_base_color" id="z_base_color" value="="></span>
		</label>
		<div class="<?php echo $ww_color_search->RightColumnClass ?>"><div<?php echo $ww_color->base_color->cellAttributes() ?>>
			<span id="el_ww_color_base_color">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ww_color" data-field="x_base_color" data-value-separator="<?php echo $ww_color->base_color->displayValueSeparatorAttribute() ?>" id="x_base_color" name="x_base_color"<?php echo $ww_color->base_color->editAttributes() ?>>
		<?php echo $ww_color->base_color->selectOptionListHtml("x_base_color") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ww_color->match_clariant->Visible) { // match_clariant ?>
	<div id="r_match_clariant" class="form-group row">
		<label for="x_match_clariant" class="<?php echo $ww_color_search->LeftColumnClass ?>"><span id="elh_ww_color_match_clariant"><?php echo $ww_color->match_clariant->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_match_clariant" id="z_match_clariant" value="="></span>
		</label>
		<div class="<?php echo $ww_color_search->RightColumnClass ?>"><div<?php echo $ww_color->match_clariant->cellAttributes() ?>>
			<span id="el_ww_color_match_clariant">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ww_color" data-field="x_match_clariant" data-value-separator="<?php echo $ww_color->match_clariant->displayValueSeparatorAttribute() ?>" id="x_match_clariant" name="x_match_clariant"<?php echo $ww_color->match_clariant->editAttributes() ?>>
		<?php echo $ww_color->match_clariant->selectOptionListHtml("x_match_clariant") ?>
	</select>
</div>
<?php echo $ww_color->match_clariant->Lookup->getParamTag("p_x_match_clariant") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ww_color->match_poddar->Visible) { // match_poddar ?>
	<div id="r_match_poddar" class="form-group row">
		<label for="x_match_poddar" class="<?php echo $ww_color_search->LeftColumnClass ?>"><span id="elh_ww_color_match_poddar"><?php echo $ww_color->match_poddar->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_match_poddar" id="z_match_poddar" value="="></span>
		</label>
		<div class="<?php echo $ww_color_search->RightColumnClass ?>"><div<?php echo $ww_color->match_poddar->cellAttributes() ?>>
			<span id="el_ww_color_match_poddar">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ww_color" data-field="x_match_poddar" data-value-separator="<?php echo $ww_color->match_poddar->displayValueSeparatorAttribute() ?>" id="x_match_poddar" name="x_match_poddar"<?php echo $ww_color->match_poddar->editAttributes() ?>>
		<?php echo $ww_color->match_poddar->selectOptionListHtml("x_match_poddar") ?>
	</select>
</div>
<?php echo $ww_color->match_poddar->Lookup->getParamTag("p_x_match_poddar") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ww_color->match_polyone->Visible) { // match_polyone ?>
	<div id="r_match_polyone" class="form-group row">
		<label for="x_match_polyone" class="<?php echo $ww_color_search->LeftColumnClass ?>"><span id="elh_ww_color_match_polyone"><?php echo $ww_color->match_polyone->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_match_polyone" id="z_match_polyone" value="="></span>
		</label>
		<div class="<?php echo $ww_color_search->RightColumnClass ?>"><div<?php echo $ww_color->match_polyone->cellAttributes() ?>>
			<span id="el_ww_color_match_polyone">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ww_color" data-field="x_match_polyone" data-value-separator="<?php echo $ww_color->match_polyone->displayValueSeparatorAttribute() ?>" id="x_match_polyone" name="x_match_polyone"<?php echo $ww_color->match_polyone->editAttributes() ?>>
		<?php echo $ww_color->match_polyone->selectOptionListHtml("x_match_polyone") ?>
	</select>
</div>
<?php echo $ww_color->match_polyone->Lookup->getParamTag("p_x_match_polyone") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ww_color->moq->Visible) { // moq ?>
	<div id="r_moq" class="form-group row">
		<label for="x_moq" class="<?php echo $ww_color_search->LeftColumnClass ?>"><span id="elh_ww_color_moq"><?php echo $ww_color->moq->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_moq" id="z_moq" value="="></span>
		</label>
		<div class="<?php echo $ww_color_search->RightColumnClass ?>"><div<?php echo $ww_color->moq->cellAttributes() ?>>
			<span id="el_ww_color_moq">
<input type="text" data-table="ww_color" data-field="x_moq" name="x_moq" id="x_moq" size="30" placeholder="<?php echo HtmlEncode($ww_color->moq->getPlaceHolder()) ?>" value="<?php echo $ww_color->moq->EditValue ?>"<?php echo $ww_color->moq->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ww_color->m_stock->Visible) { // m_stock ?>
	<div id="r_m_stock" class="form-group row">
		<label for="x_m_stock" class="<?php echo $ww_color_search->LeftColumnClass ?>"><span id="elh_ww_color_m_stock"><?php echo $ww_color->m_stock->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_m_stock" id="z_m_stock" value="="></span>
		</label>
		<div class="<?php echo $ww_color_search->RightColumnClass ?>"><div<?php echo $ww_color->m_stock->cellAttributes() ?>>
			<span id="el_ww_color_m_stock">
<input type="text" data-table="ww_color" data-field="x_m_stock" name="x_m_stock" id="x_m_stock" size="30" placeholder="<?php echo HtmlEncode($ww_color->m_stock->getPlaceHolder()) ?>" value="<?php echo $ww_color->m_stock->EditValue ?>"<?php echo $ww_color->m_stock->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ww_color->stock->Visible) { // stock ?>
	<div id="r_stock" class="form-group row">
		<label for="x_stock" class="<?php echo $ww_color_search->LeftColumnClass ?>"><span id="elh_ww_color_stock"><?php echo $ww_color->stock->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_stock" id="z_stock" value="="></span>
		</label>
		<div class="<?php echo $ww_color_search->RightColumnClass ?>"><div<?php echo $ww_color->stock->cellAttributes() ?>>
			<span id="el_ww_color_stock">
<input type="text" data-table="ww_color" data-field="x_stock" name="x_stock" id="x_stock" size="30" placeholder="<?php echo HtmlEncode($ww_color->stock->getPlaceHolder()) ?>" value="<?php echo $ww_color->stock->EditValue ?>"<?php echo $ww_color->stock->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ww_color->required->Visible) { // required ?>
	<div id="r_required" class="form-group row">
		<label for="x_required" class="<?php echo $ww_color_search->LeftColumnClass ?>"><span id="elh_ww_color_required"><?php echo $ww_color->required->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_required" id="z_required" value="="></span>
		</label>
		<div class="<?php echo $ww_color_search->RightColumnClass ?>"><div<?php echo $ww_color->required->cellAttributes() ?>>
			<span id="el_ww_color_required">
<input type="text" data-table="ww_color" data-field="x_required" name="x_required" id="x_required" size="30" placeholder="<?php echo HtmlEncode($ww_color->required->getPlaceHolder()) ?>" value="<?php echo $ww_color->required->EditValue ?>"<?php echo $ww_color->required->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ww_color->ordered->Visible) { // ordered ?>
	<div id="r_ordered" class="form-group row">
		<label for="x_ordered" class="<?php echo $ww_color_search->LeftColumnClass ?>"><span id="elh_ww_color_ordered"><?php echo $ww_color->ordered->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ordered" id="z_ordered" value="="></span>
		</label>
		<div class="<?php echo $ww_color_search->RightColumnClass ?>"><div<?php echo $ww_color->ordered->cellAttributes() ?>>
			<span id="el_ww_color_ordered">
<input type="text" data-table="ww_color" data-field="x_ordered" name="x_ordered" id="x_ordered" size="30" placeholder="<?php echo HtmlEncode($ww_color->ordered->getPlaceHolder()) ?>" value="<?php echo $ww_color->ordered->EditValue ?>"<?php echo $ww_color->ordered->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ww_color->pending_order->Visible) { // pending_order ?>
	<div id="r_pending_order" class="form-group row">
		<label for="x_pending_order" class="<?php echo $ww_color_search->LeftColumnClass ?>"><span id="elh_ww_color_pending_order"><?php echo $ww_color->pending_order->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_pending_order" id="z_pending_order" value="="></span>
		</label>
		<div class="<?php echo $ww_color_search->RightColumnClass ?>"><div<?php echo $ww_color->pending_order->cellAttributes() ?>>
			<span id="el_ww_color_pending_order">
<input type="text" data-table="ww_color" data-field="x_pending_order" name="x_pending_order" id="x_pending_order" size="30" placeholder="<?php echo HtmlEncode($ww_color->pending_order->getPlaceHolder()) ?>" value="<?php echo $ww_color->pending_order->EditValue ?>"<?php echo $ww_color->pending_order->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ww_color->status->Visible) { // status ?>
	<div id="r_status" class="form-group row">
		<label for="x_status" class="<?php echo $ww_color_search->LeftColumnClass ?>"><span id="elh_ww_color_status"><?php echo $ww_color->status->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_status" id="z_status" value="="></span>
		</label>
		<div class="<?php echo $ww_color_search->RightColumnClass ?>"><div<?php echo $ww_color->status->cellAttributes() ?>>
			<span id="el_ww_color_status">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ww_color" data-field="x_status" data-value-separator="<?php echo $ww_color->status->displayValueSeparatorAttribute() ?>" id="x_status" name="x_status"<?php echo $ww_color->status->editAttributes() ?>>
		<?php echo $ww_color->status->selectOptionListHtml("x_status") ?>
	</select>
</div>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ww_color->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $ww_color_search->LeftColumnClass ?>"><span id="elh_ww_color_operator"><?php echo $ww_color->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $ww_color_search->RightColumnClass ?>"><div<?php echo $ww_color->operator->cellAttributes() ?>>
			<span id="el_ww_color_operator">
<input type="text" data-table="ww_color" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($ww_color->operator->getPlaceHolder()) ?>" value="<?php echo $ww_color->operator->EditValue ?>"<?php echo $ww_color->operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ww_color->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $ww_color_search->LeftColumnClass ?>"><span id="elh_ww_color_datetime"><?php echo $ww_color->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $ww_color_search->RightColumnClass ?>"><div<?php echo $ww_color->datetime->cellAttributes() ?>>
			<span id="el_ww_color_datetime">
<input type="text" data-table="ww_color" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($ww_color->datetime->getPlaceHolder()) ?>" value="<?php echo $ww_color->datetime->EditValue ?>"<?php echo $ww_color->datetime->editAttributes() ?>>
<?php if (!$ww_color->datetime->ReadOnly && !$ww_color->datetime->Disabled && !isset($ww_color->datetime->EditAttrs["readonly"]) && !isset($ww_color->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fww_colorsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$ww_color_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $ww_color_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$ww_color_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$ww_color_search->terminate();
?>