<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$ww_color_view = new ww_color_view();

// Run the page
$ww_color_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$ww_color_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$ww_color->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fww_colorview = currentForm = new ew.Form("fww_colorview", "view");

// Form_CustomValidate event
fww_colorview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fww_colorview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fww_colorview.lists["x_color_source"] = <?php echo $ww_color_view->color_source->Lookup->toClientList() ?>;
fww_colorview.lists["x_color_source"].options = <?php echo JsonEncode($ww_color_view->color_source->options(FALSE, TRUE)) ?>;
fww_colorview.lists["x_base_color"] = <?php echo $ww_color_view->base_color->Lookup->toClientList() ?>;
fww_colorview.lists["x_base_color"].options = <?php echo JsonEncode($ww_color_view->base_color->options(FALSE, TRUE)) ?>;
fww_colorview.lists["x_match_clariant"] = <?php echo $ww_color_view->match_clariant->Lookup->toClientList() ?>;
fww_colorview.lists["x_match_clariant"].options = <?php echo JsonEncode($ww_color_view->match_clariant->lookupOptions()) ?>;
fww_colorview.lists["x_match_poddar"] = <?php echo $ww_color_view->match_poddar->Lookup->toClientList() ?>;
fww_colorview.lists["x_match_poddar"].options = <?php echo JsonEncode($ww_color_view->match_poddar->lookupOptions()) ?>;
fww_colorview.lists["x_match_polyone"] = <?php echo $ww_color_view->match_polyone->Lookup->toClientList() ?>;
fww_colorview.lists["x_match_polyone"].options = <?php echo JsonEncode($ww_color_view->match_polyone->lookupOptions()) ?>;
fww_colorview.lists["x_status"] = <?php echo $ww_color_view->status->Lookup->toClientList() ?>;
fww_colorview.lists["x_status"].options = <?php echo JsonEncode($ww_color_view->status->options(FALSE, TRUE)) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$ww_color->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $ww_color_view->ExportOptions->render("body") ?>
<?php $ww_color_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $ww_color_view->showPageHeader(); ?>
<?php
$ww_color_view->showMessage();
?>
<form name="fww_colorview" id="fww_colorview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($ww_color_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $ww_color_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="ww_color">
<input type="hidden" name="modal" value="<?php echo (int)$ww_color_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($ww_color->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $ww_color_view->TableLeftColumnClass ?>"><span id="elh_ww_color_id"><?php echo $ww_color->id->caption() ?></span></td>
		<td data-name="id"<?php echo $ww_color->id->cellAttributes() ?>>
<span id="el_ww_color_id">
<span<?php echo $ww_color->id->viewAttributes() ?>>
<?php echo $ww_color->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ww_color->color->Visible) { // color ?>
	<tr id="r_color">
		<td class="<?php echo $ww_color_view->TableLeftColumnClass ?>"><span id="elh_ww_color_color"><?php echo $ww_color->color->caption() ?></span></td>
		<td data-name="color"<?php echo $ww_color->color->cellAttributes() ?>>
<span id="el_ww_color_color">
<span<?php echo $ww_color->color->viewAttributes() ?>>
<?php echo $ww_color->color->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ww_color->color_source->Visible) { // color_source ?>
	<tr id="r_color_source">
		<td class="<?php echo $ww_color_view->TableLeftColumnClass ?>"><span id="elh_ww_color_color_source"><?php echo $ww_color->color_source->caption() ?></span></td>
		<td data-name="color_source"<?php echo $ww_color->color_source->cellAttributes() ?>>
<span id="el_ww_color_color_source">
<span<?php echo $ww_color->color_source->viewAttributes() ?>>
<?php echo $ww_color->color_source->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ww_color->base_color->Visible) { // base_color ?>
	<tr id="r_base_color">
		<td class="<?php echo $ww_color_view->TableLeftColumnClass ?>"><span id="elh_ww_color_base_color"><?php echo $ww_color->base_color->caption() ?></span></td>
		<td data-name="base_color"<?php echo $ww_color->base_color->cellAttributes() ?>>
<span id="el_ww_color_base_color">
<span<?php echo $ww_color->base_color->viewAttributes() ?>>
<?php echo $ww_color->base_color->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ww_color->match_clariant->Visible) { // match_clariant ?>
	<tr id="r_match_clariant">
		<td class="<?php echo $ww_color_view->TableLeftColumnClass ?>"><span id="elh_ww_color_match_clariant"><?php echo $ww_color->match_clariant->caption() ?></span></td>
		<td data-name="match_clariant"<?php echo $ww_color->match_clariant->cellAttributes() ?>>
<span id="el_ww_color_match_clariant">
<span<?php echo $ww_color->match_clariant->viewAttributes() ?>>
<?php echo $ww_color->match_clariant->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ww_color->match_poddar->Visible) { // match_poddar ?>
	<tr id="r_match_poddar">
		<td class="<?php echo $ww_color_view->TableLeftColumnClass ?>"><span id="elh_ww_color_match_poddar"><?php echo $ww_color->match_poddar->caption() ?></span></td>
		<td data-name="match_poddar"<?php echo $ww_color->match_poddar->cellAttributes() ?>>
<span id="el_ww_color_match_poddar">
<span<?php echo $ww_color->match_poddar->viewAttributes() ?>>
<?php echo $ww_color->match_poddar->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ww_color->match_polyone->Visible) { // match_polyone ?>
	<tr id="r_match_polyone">
		<td class="<?php echo $ww_color_view->TableLeftColumnClass ?>"><span id="elh_ww_color_match_polyone"><?php echo $ww_color->match_polyone->caption() ?></span></td>
		<td data-name="match_polyone"<?php echo $ww_color->match_polyone->cellAttributes() ?>>
<span id="el_ww_color_match_polyone">
<span<?php echo $ww_color->match_polyone->viewAttributes() ?>>
<?php echo $ww_color->match_polyone->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ww_color->moq->Visible) { // moq ?>
	<tr id="r_moq">
		<td class="<?php echo $ww_color_view->TableLeftColumnClass ?>"><span id="elh_ww_color_moq"><?php echo $ww_color->moq->caption() ?></span></td>
		<td data-name="moq"<?php echo $ww_color->moq->cellAttributes() ?>>
<span id="el_ww_color_moq">
<span<?php echo $ww_color->moq->viewAttributes() ?>>
<?php echo $ww_color->moq->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ww_color->m_stock->Visible) { // m_stock ?>
	<tr id="r_m_stock">
		<td class="<?php echo $ww_color_view->TableLeftColumnClass ?>"><span id="elh_ww_color_m_stock"><?php echo $ww_color->m_stock->caption() ?></span></td>
		<td data-name="m_stock"<?php echo $ww_color->m_stock->cellAttributes() ?>>
<span id="el_ww_color_m_stock">
<span<?php echo $ww_color->m_stock->viewAttributes() ?>>
<?php echo $ww_color->m_stock->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ww_color->stock->Visible) { // stock ?>
	<tr id="r_stock">
		<td class="<?php echo $ww_color_view->TableLeftColumnClass ?>"><span id="elh_ww_color_stock"><?php echo $ww_color->stock->caption() ?></span></td>
		<td data-name="stock"<?php echo $ww_color->stock->cellAttributes() ?>>
<span id="el_ww_color_stock">
<span<?php echo $ww_color->stock->viewAttributes() ?>>
<?php echo $ww_color->stock->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ww_color->required->Visible) { // required ?>
	<tr id="r_required">
		<td class="<?php echo $ww_color_view->TableLeftColumnClass ?>"><span id="elh_ww_color_required"><?php echo $ww_color->required->caption() ?></span></td>
		<td data-name="required"<?php echo $ww_color->required->cellAttributes() ?>>
<span id="el_ww_color_required">
<span<?php echo $ww_color->required->viewAttributes() ?>>
<?php echo $ww_color->required->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ww_color->ordered->Visible) { // ordered ?>
	<tr id="r_ordered">
		<td class="<?php echo $ww_color_view->TableLeftColumnClass ?>"><span id="elh_ww_color_ordered"><?php echo $ww_color->ordered->caption() ?></span></td>
		<td data-name="ordered"<?php echo $ww_color->ordered->cellAttributes() ?>>
<span id="el_ww_color_ordered">
<span<?php echo $ww_color->ordered->viewAttributes() ?>>
<?php echo $ww_color->ordered->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ww_color->pending_order->Visible) { // pending_order ?>
	<tr id="r_pending_order">
		<td class="<?php echo $ww_color_view->TableLeftColumnClass ?>"><span id="elh_ww_color_pending_order"><?php echo $ww_color->pending_order->caption() ?></span></td>
		<td data-name="pending_order"<?php echo $ww_color->pending_order->cellAttributes() ?>>
<span id="el_ww_color_pending_order">
<span<?php echo $ww_color->pending_order->viewAttributes() ?>>
<?php echo $ww_color->pending_order->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ww_color->status->Visible) { // status ?>
	<tr id="r_status">
		<td class="<?php echo $ww_color_view->TableLeftColumnClass ?>"><span id="elh_ww_color_status"><?php echo $ww_color->status->caption() ?></span></td>
		<td data-name="status"<?php echo $ww_color->status->cellAttributes() ?>>
<span id="el_ww_color_status">
<span<?php echo $ww_color->status->viewAttributes() ?>>
<?php echo $ww_color->status->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ww_color->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $ww_color_view->TableLeftColumnClass ?>"><span id="elh_ww_color_operator"><?php echo $ww_color->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $ww_color->operator->cellAttributes() ?>>
<span id="el_ww_color_operator">
<span<?php echo $ww_color->operator->viewAttributes() ?>>
<?php echo $ww_color->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ww_color->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $ww_color_view->TableLeftColumnClass ?>"><span id="elh_ww_color_datetime"><?php echo $ww_color->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $ww_color->datetime->cellAttributes() ?>>
<span id="el_ww_color_datetime">
<span<?php echo $ww_color->datetime->viewAttributes() ?>>
<?php echo $ww_color->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$ww_color_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$ww_color->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$ww_color_view->terminate();
?>