<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$ww_yarn_plan_add = new ww_yarn_plan_add();

// Run the page
$ww_yarn_plan_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$ww_yarn_plan_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fww_yarn_planadd = currentForm = new ew.Form("fww_yarn_planadd", "add");

// Validate form
fww_yarn_planadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($ww_yarn_plan_add->period->Required) { ?>
			elm = this.getElements("x" + infix + "_period");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ww_yarn_plan->period->caption(), $ww_yarn_plan->period->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ww_yarn_plan_add->y_id->Required) { ?>
			elm = this.getElements("x" + infix + "_y_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ww_yarn_plan->y_id->caption(), $ww_yarn_plan->y_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ww_yarn_plan_add->forcast->Required) { ?>
			elm = this.getElements("x" + infix + "_forcast");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ww_yarn_plan->forcast->caption(), $ww_yarn_plan->forcast->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_forcast");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($ww_yarn_plan->forcast->errorMessage()) ?>");
		<?php if ($ww_yarn_plan_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ww_yarn_plan->operator->caption(), $ww_yarn_plan->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ww_yarn_plan_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ww_yarn_plan->datetime->caption(), $ww_yarn_plan->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fww_yarn_planadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fww_yarn_planadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fww_yarn_planadd.lists["x_period"] = <?php echo $ww_yarn_plan_add->period->Lookup->toClientList() ?>;
fww_yarn_planadd.lists["x_period"].options = <?php echo JsonEncode($ww_yarn_plan_add->period->lookupOptions()) ?>;
fww_yarn_planadd.lists["x_y_id"] = <?php echo $ww_yarn_plan_add->y_id->Lookup->toClientList() ?>;
fww_yarn_planadd.lists["x_y_id"].options = <?php echo JsonEncode($ww_yarn_plan_add->y_id->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $ww_yarn_plan_add->showPageHeader(); ?>
<?php
$ww_yarn_plan_add->showMessage();
?>
<form name="fww_yarn_planadd" id="fww_yarn_planadd" class="<?php echo $ww_yarn_plan_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($ww_yarn_plan_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $ww_yarn_plan_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="ww_yarn_plan">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$ww_yarn_plan_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($ww_yarn_plan->period->Visible) { // period ?>
	<div id="r_period" class="form-group row">
		<label id="elh_ww_yarn_plan_period" for="x_period" class="<?php echo $ww_yarn_plan_add->LeftColumnClass ?>"><?php echo $ww_yarn_plan->period->caption() ?><?php echo ($ww_yarn_plan->period->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ww_yarn_plan_add->RightColumnClass ?>"><div<?php echo $ww_yarn_plan->period->cellAttributes() ?>>
<span id="el_ww_yarn_plan_period">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ww_yarn_plan" data-field="x_period" data-value-separator="<?php echo $ww_yarn_plan->period->displayValueSeparatorAttribute() ?>" id="x_period" name="x_period"<?php echo $ww_yarn_plan->period->editAttributes() ?>>
		<?php echo $ww_yarn_plan->period->selectOptionListHtml("x_period") ?>
	</select>
</div>
<?php echo $ww_yarn_plan->period->Lookup->getParamTag("p_x_period") ?>
</span>
<?php echo $ww_yarn_plan->period->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ww_yarn_plan->y_id->Visible) { // y_id ?>
	<div id="r_y_id" class="form-group row">
		<label id="elh_ww_yarn_plan_y_id" for="x_y_id" class="<?php echo $ww_yarn_plan_add->LeftColumnClass ?>"><?php echo $ww_yarn_plan->y_id->caption() ?><?php echo ($ww_yarn_plan->y_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ww_yarn_plan_add->RightColumnClass ?>"><div<?php echo $ww_yarn_plan->y_id->cellAttributes() ?>>
<span id="el_ww_yarn_plan_y_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ww_yarn_plan" data-field="x_y_id" data-value-separator="<?php echo $ww_yarn_plan->y_id->displayValueSeparatorAttribute() ?>" id="x_y_id" name="x_y_id"<?php echo $ww_yarn_plan->y_id->editAttributes() ?>>
		<?php echo $ww_yarn_plan->y_id->selectOptionListHtml("x_y_id") ?>
	</select>
</div>
<?php echo $ww_yarn_plan->y_id->Lookup->getParamTag("p_x_y_id") ?>
</span>
<?php echo $ww_yarn_plan->y_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ww_yarn_plan->forcast->Visible) { // forcast ?>
	<div id="r_forcast" class="form-group row">
		<label id="elh_ww_yarn_plan_forcast" for="x_forcast" class="<?php echo $ww_yarn_plan_add->LeftColumnClass ?>"><?php echo $ww_yarn_plan->forcast->caption() ?><?php echo ($ww_yarn_plan->forcast->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ww_yarn_plan_add->RightColumnClass ?>"><div<?php echo $ww_yarn_plan->forcast->cellAttributes() ?>>
<span id="el_ww_yarn_plan_forcast">
<input type="text" data-table="ww_yarn_plan" data-field="x_forcast" name="x_forcast" id="x_forcast" size="30" placeholder="<?php echo HtmlEncode($ww_yarn_plan->forcast->getPlaceHolder()) ?>" value="<?php echo $ww_yarn_plan->forcast->EditValue ?>"<?php echo $ww_yarn_plan->forcast->editAttributes() ?>>
</span>
<?php echo $ww_yarn_plan->forcast->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$ww_yarn_plan_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $ww_yarn_plan_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $ww_yarn_plan_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$ww_yarn_plan_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$ww_yarn_plan_add->terminate();
?>