<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$ww_yarn_plan_edit = new ww_yarn_plan_edit();

// Run the page
$ww_yarn_plan_edit->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$ww_yarn_plan_edit->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "edit";
var fww_yarn_planedit = currentForm = new ew.Form("fww_yarn_planedit", "edit");

// Validate form
fww_yarn_planedit.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($ww_yarn_plan_edit->id->Required) { ?>
			elm = this.getElements("x" + infix + "_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ww_yarn_plan->id->caption(), $ww_yarn_plan->id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ww_yarn_plan_edit->period->Required) { ?>
			elm = this.getElements("x" + infix + "_period");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ww_yarn_plan->period->caption(), $ww_yarn_plan->period->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ww_yarn_plan_edit->y_id->Required) { ?>
			elm = this.getElements("x" + infix + "_y_id");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ww_yarn_plan->y_id->caption(), $ww_yarn_plan->y_id->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ww_yarn_plan_edit->forcast->Required) { ?>
			elm = this.getElements("x" + infix + "_forcast");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ww_yarn_plan->forcast->caption(), $ww_yarn_plan->forcast->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_forcast");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($ww_yarn_plan->forcast->errorMessage()) ?>");
		<?php if ($ww_yarn_plan_edit->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ww_yarn_plan->operator->caption(), $ww_yarn_plan->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ww_yarn_plan_edit->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ww_yarn_plan->datetime->caption(), $ww_yarn_plan->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fww_yarn_planedit.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fww_yarn_planedit.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fww_yarn_planedit.lists["x_period"] = <?php echo $ww_yarn_plan_edit->period->Lookup->toClientList() ?>;
fww_yarn_planedit.lists["x_period"].options = <?php echo JsonEncode($ww_yarn_plan_edit->period->lookupOptions()) ?>;
fww_yarn_planedit.lists["x_y_id"] = <?php echo $ww_yarn_plan_edit->y_id->Lookup->toClientList() ?>;
fww_yarn_planedit.lists["x_y_id"].options = <?php echo JsonEncode($ww_yarn_plan_edit->y_id->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $ww_yarn_plan_edit->showPageHeader(); ?>
<?php
$ww_yarn_plan_edit->showMessage();
?>
<form name="fww_yarn_planedit" id="fww_yarn_planedit" class="<?php echo $ww_yarn_plan_edit->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($ww_yarn_plan_edit->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $ww_yarn_plan_edit->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="ww_yarn_plan">
<input type="hidden" name="action" id="action" value="update">
<input type="hidden" name="modal" value="<?php echo (int)$ww_yarn_plan_edit->IsModal ?>">
<div class="ew-edit-div"><!-- page* -->
<?php if ($ww_yarn_plan->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label id="elh_ww_yarn_plan_id" class="<?php echo $ww_yarn_plan_edit->LeftColumnClass ?>"><?php echo $ww_yarn_plan->id->caption() ?><?php echo ($ww_yarn_plan->id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ww_yarn_plan_edit->RightColumnClass ?>"><div<?php echo $ww_yarn_plan->id->cellAttributes() ?>>
<span id="el_ww_yarn_plan_id">
<span<?php echo $ww_yarn_plan->id->viewAttributes() ?>>
<input type="text" readonly class="form-control-plaintext" value="<?php echo RemoveHtml($ww_yarn_plan->id->EditValue) ?>"></span>
</span>
<input type="hidden" data-table="ww_yarn_plan" data-field="x_id" name="x_id" id="x_id" value="<?php echo HtmlEncode($ww_yarn_plan->id->CurrentValue) ?>">
<?php echo $ww_yarn_plan->id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ww_yarn_plan->period->Visible) { // period ?>
	<div id="r_period" class="form-group row">
		<label id="elh_ww_yarn_plan_period" for="x_period" class="<?php echo $ww_yarn_plan_edit->LeftColumnClass ?>"><?php echo $ww_yarn_plan->period->caption() ?><?php echo ($ww_yarn_plan->period->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ww_yarn_plan_edit->RightColumnClass ?>"><div<?php echo $ww_yarn_plan->period->cellAttributes() ?>>
<span id="el_ww_yarn_plan_period">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ww_yarn_plan" data-field="x_period" data-value-separator="<?php echo $ww_yarn_plan->period->displayValueSeparatorAttribute() ?>" id="x_period" name="x_period"<?php echo $ww_yarn_plan->period->editAttributes() ?>>
		<?php echo $ww_yarn_plan->period->selectOptionListHtml("x_period") ?>
	</select>
</div>
<?php echo $ww_yarn_plan->period->Lookup->getParamTag("p_x_period") ?>
</span>
<?php echo $ww_yarn_plan->period->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ww_yarn_plan->y_id->Visible) { // y_id ?>
	<div id="r_y_id" class="form-group row">
		<label id="elh_ww_yarn_plan_y_id" for="x_y_id" class="<?php echo $ww_yarn_plan_edit->LeftColumnClass ?>"><?php echo $ww_yarn_plan->y_id->caption() ?><?php echo ($ww_yarn_plan->y_id->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ww_yarn_plan_edit->RightColumnClass ?>"><div<?php echo $ww_yarn_plan->y_id->cellAttributes() ?>>
<span id="el_ww_yarn_plan_y_id">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ww_yarn_plan" data-field="x_y_id" data-value-separator="<?php echo $ww_yarn_plan->y_id->displayValueSeparatorAttribute() ?>" id="x_y_id" name="x_y_id"<?php echo $ww_yarn_plan->y_id->editAttributes() ?>>
		<?php echo $ww_yarn_plan->y_id->selectOptionListHtml("x_y_id") ?>
	</select>
</div>
<?php echo $ww_yarn_plan->y_id->Lookup->getParamTag("p_x_y_id") ?>
</span>
<?php echo $ww_yarn_plan->y_id->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ww_yarn_plan->forcast->Visible) { // forcast ?>
	<div id="r_forcast" class="form-group row">
		<label id="elh_ww_yarn_plan_forcast" for="x_forcast" class="<?php echo $ww_yarn_plan_edit->LeftColumnClass ?>"><?php echo $ww_yarn_plan->forcast->caption() ?><?php echo ($ww_yarn_plan->forcast->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ww_yarn_plan_edit->RightColumnClass ?>"><div<?php echo $ww_yarn_plan->forcast->cellAttributes() ?>>
<span id="el_ww_yarn_plan_forcast">
<input type="text" data-table="ww_yarn_plan" data-field="x_forcast" name="x_forcast" id="x_forcast" size="30" placeholder="<?php echo HtmlEncode($ww_yarn_plan->forcast->getPlaceHolder()) ?>" value="<?php echo $ww_yarn_plan->forcast->EditValue ?>"<?php echo $ww_yarn_plan->forcast->editAttributes() ?>>
</span>
<?php echo $ww_yarn_plan->forcast->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$ww_yarn_plan_edit->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $ww_yarn_plan_edit->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("SaveBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $ww_yarn_plan_edit->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$ww_yarn_plan_edit->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$ww_yarn_plan_edit->terminate();
?>