<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$ww_yarn_plan_list = new ww_yarn_plan_list();

// Run the page
$ww_yarn_plan_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$ww_yarn_plan_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$ww_yarn_plan->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fww_yarn_planlist = currentForm = new ew.Form("fww_yarn_planlist", "list");
fww_yarn_planlist.formKeyCountName = '<?php echo $ww_yarn_plan_list->FormKeyCountName ?>';

// Form_CustomValidate event
fww_yarn_planlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fww_yarn_planlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fww_yarn_planlist.lists["x_period"] = <?php echo $ww_yarn_plan_list->period->Lookup->toClientList() ?>;
fww_yarn_planlist.lists["x_period"].options = <?php echo JsonEncode($ww_yarn_plan_list->period->lookupOptions()) ?>;
fww_yarn_planlist.lists["x_y_id"] = <?php echo $ww_yarn_plan_list->y_id->Lookup->toClientList() ?>;
fww_yarn_planlist.lists["x_y_id"].options = <?php echo JsonEncode($ww_yarn_plan_list->y_id->lookupOptions()) ?>;

// Form object for search
var fww_yarn_planlistsrch = currentSearchForm = new ew.Form("fww_yarn_planlistsrch");

// Filters
fww_yarn_planlistsrch.filterList = <?php echo $ww_yarn_plan_list->getFilterList() ?>;

// Init search panel as collapsed
fww_yarn_planlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$ww_yarn_plan->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($ww_yarn_plan_list->TotalRecs > 0 && $ww_yarn_plan_list->ExportOptions->visible()) { ?>
<?php $ww_yarn_plan_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($ww_yarn_plan_list->ImportOptions->visible()) { ?>
<?php $ww_yarn_plan_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($ww_yarn_plan_list->SearchOptions->visible()) { ?>
<?php $ww_yarn_plan_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($ww_yarn_plan_list->FilterOptions->visible()) { ?>
<?php $ww_yarn_plan_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$ww_yarn_plan_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$ww_yarn_plan->isExport() && !$ww_yarn_plan->CurrentAction) { ?>
<form name="fww_yarn_planlistsrch" id="fww_yarn_planlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($ww_yarn_plan_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fww_yarn_planlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="ww_yarn_plan">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($ww_yarn_plan_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($ww_yarn_plan_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $ww_yarn_plan_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($ww_yarn_plan_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($ww_yarn_plan_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($ww_yarn_plan_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($ww_yarn_plan_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $ww_yarn_plan_list->showPageHeader(); ?>
<?php
$ww_yarn_plan_list->showMessage();
?>
<?php if ($ww_yarn_plan_list->TotalRecs > 0 || $ww_yarn_plan->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($ww_yarn_plan_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> ww_yarn_plan">
<?php if (!$ww_yarn_plan->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$ww_yarn_plan->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($ww_yarn_plan_list->Pager)) $ww_yarn_plan_list->Pager = new PrevNextPager($ww_yarn_plan_list->StartRec, $ww_yarn_plan_list->DisplayRecs, $ww_yarn_plan_list->TotalRecs, $ww_yarn_plan_list->AutoHidePager) ?>
<?php if ($ww_yarn_plan_list->Pager->RecordCount > 0 && $ww_yarn_plan_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($ww_yarn_plan_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $ww_yarn_plan_list->pageUrl() ?>start=<?php echo $ww_yarn_plan_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($ww_yarn_plan_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $ww_yarn_plan_list->pageUrl() ?>start=<?php echo $ww_yarn_plan_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $ww_yarn_plan_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($ww_yarn_plan_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $ww_yarn_plan_list->pageUrl() ?>start=<?php echo $ww_yarn_plan_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($ww_yarn_plan_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $ww_yarn_plan_list->pageUrl() ?>start=<?php echo $ww_yarn_plan_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $ww_yarn_plan_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($ww_yarn_plan_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $ww_yarn_plan_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $ww_yarn_plan_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $ww_yarn_plan_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($ww_yarn_plan_list->TotalRecs > 0 && (!$ww_yarn_plan_list->AutoHidePageSizeSelector || $ww_yarn_plan_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="ww_yarn_plan">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($ww_yarn_plan_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($ww_yarn_plan_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($ww_yarn_plan_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($ww_yarn_plan_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($ww_yarn_plan_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($ww_yarn_plan->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $ww_yarn_plan_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fww_yarn_planlist" id="fww_yarn_planlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($ww_yarn_plan_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $ww_yarn_plan_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="ww_yarn_plan">
<div id="gmp_ww_yarn_plan" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($ww_yarn_plan_list->TotalRecs > 0 || $ww_yarn_plan->isGridEdit()) { ?>
<table id="tbl_ww_yarn_planlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$ww_yarn_plan_list->RowType = ROWTYPE_HEADER;

// Render list options
$ww_yarn_plan_list->renderListOptions();

// Render list options (header, left)
$ww_yarn_plan_list->ListOptions->render("header", "left");
?>
<?php if ($ww_yarn_plan->id->Visible) { // id ?>
	<?php if ($ww_yarn_plan->sortUrl($ww_yarn_plan->id) == "") { ?>
		<th data-name="id" class="<?php echo $ww_yarn_plan->id->headerCellClass() ?>"><div id="elh_ww_yarn_plan_id" class="ww_yarn_plan_id"><div class="ew-table-header-caption"><?php echo $ww_yarn_plan->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $ww_yarn_plan->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ww_yarn_plan->SortUrl($ww_yarn_plan->id) ?>',2);"><div id="elh_ww_yarn_plan_id" class="ww_yarn_plan_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ww_yarn_plan->id->caption() ?></span><span class="ew-table-header-sort"><?php if ($ww_yarn_plan->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ww_yarn_plan->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ww_yarn_plan->period->Visible) { // period ?>
	<?php if ($ww_yarn_plan->sortUrl($ww_yarn_plan->period) == "") { ?>
		<th data-name="period" class="<?php echo $ww_yarn_plan->period->headerCellClass() ?>"><div id="elh_ww_yarn_plan_period" class="ww_yarn_plan_period"><div class="ew-table-header-caption"><?php echo $ww_yarn_plan->period->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="period" class="<?php echo $ww_yarn_plan->period->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ww_yarn_plan->SortUrl($ww_yarn_plan->period) ?>',2);"><div id="elh_ww_yarn_plan_period" class="ww_yarn_plan_period">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ww_yarn_plan->period->caption() ?></span><span class="ew-table-header-sort"><?php if ($ww_yarn_plan->period->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ww_yarn_plan->period->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ww_yarn_plan->y_id->Visible) { // y_id ?>
	<?php if ($ww_yarn_plan->sortUrl($ww_yarn_plan->y_id) == "") { ?>
		<th data-name="y_id" class="<?php echo $ww_yarn_plan->y_id->headerCellClass() ?>"><div id="elh_ww_yarn_plan_y_id" class="ww_yarn_plan_y_id"><div class="ew-table-header-caption"><?php echo $ww_yarn_plan->y_id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="y_id" class="<?php echo $ww_yarn_plan->y_id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ww_yarn_plan->SortUrl($ww_yarn_plan->y_id) ?>',2);"><div id="elh_ww_yarn_plan_y_id" class="ww_yarn_plan_y_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ww_yarn_plan->y_id->caption() ?></span><span class="ew-table-header-sort"><?php if ($ww_yarn_plan->y_id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ww_yarn_plan->y_id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ww_yarn_plan->forcast->Visible) { // forcast ?>
	<?php if ($ww_yarn_plan->sortUrl($ww_yarn_plan->forcast) == "") { ?>
		<th data-name="forcast" class="<?php echo $ww_yarn_plan->forcast->headerCellClass() ?>"><div id="elh_ww_yarn_plan_forcast" class="ww_yarn_plan_forcast"><div class="ew-table-header-caption"><?php echo $ww_yarn_plan->forcast->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="forcast" class="<?php echo $ww_yarn_plan->forcast->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ww_yarn_plan->SortUrl($ww_yarn_plan->forcast) ?>',2);"><div id="elh_ww_yarn_plan_forcast" class="ww_yarn_plan_forcast">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ww_yarn_plan->forcast->caption() ?></span><span class="ew-table-header-sort"><?php if ($ww_yarn_plan->forcast->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ww_yarn_plan->forcast->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ww_yarn_plan->operator->Visible) { // operator ?>
	<?php if ($ww_yarn_plan->sortUrl($ww_yarn_plan->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $ww_yarn_plan->operator->headerCellClass() ?>"><div id="elh_ww_yarn_plan_operator" class="ww_yarn_plan_operator"><div class="ew-table-header-caption"><?php echo $ww_yarn_plan->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $ww_yarn_plan->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ww_yarn_plan->SortUrl($ww_yarn_plan->operator) ?>',2);"><div id="elh_ww_yarn_plan_operator" class="ww_yarn_plan_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ww_yarn_plan->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($ww_yarn_plan->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ww_yarn_plan->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ww_yarn_plan->datetime->Visible) { // datetime ?>
	<?php if ($ww_yarn_plan->sortUrl($ww_yarn_plan->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $ww_yarn_plan->datetime->headerCellClass() ?>"><div id="elh_ww_yarn_plan_datetime" class="ww_yarn_plan_datetime"><div class="ew-table-header-caption"><?php echo $ww_yarn_plan->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $ww_yarn_plan->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ww_yarn_plan->SortUrl($ww_yarn_plan->datetime) ?>',2);"><div id="elh_ww_yarn_plan_datetime" class="ww_yarn_plan_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ww_yarn_plan->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($ww_yarn_plan->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ww_yarn_plan->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$ww_yarn_plan_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($ww_yarn_plan->ExportAll && $ww_yarn_plan->isExport()) {
	$ww_yarn_plan_list->StopRec = $ww_yarn_plan_list->TotalRecs;
} else {

	// Set the last record to display
	if ($ww_yarn_plan_list->TotalRecs > $ww_yarn_plan_list->StartRec + $ww_yarn_plan_list->DisplayRecs - 1)
		$ww_yarn_plan_list->StopRec = $ww_yarn_plan_list->StartRec + $ww_yarn_plan_list->DisplayRecs - 1;
	else
		$ww_yarn_plan_list->StopRec = $ww_yarn_plan_list->TotalRecs;
}
$ww_yarn_plan_list->RecCnt = $ww_yarn_plan_list->StartRec - 1;
if ($ww_yarn_plan_list->Recordset && !$ww_yarn_plan_list->Recordset->EOF) {
	$ww_yarn_plan_list->Recordset->moveFirst();
	$selectLimit = $ww_yarn_plan_list->UseSelectLimit;
	if (!$selectLimit && $ww_yarn_plan_list->StartRec > 1)
		$ww_yarn_plan_list->Recordset->move($ww_yarn_plan_list->StartRec - 1);
} elseif (!$ww_yarn_plan->AllowAddDeleteRow && $ww_yarn_plan_list->StopRec == 0) {
	$ww_yarn_plan_list->StopRec = $ww_yarn_plan->GridAddRowCount;
}

// Initialize aggregate
$ww_yarn_plan->RowType = ROWTYPE_AGGREGATEINIT;
$ww_yarn_plan->resetAttributes();
$ww_yarn_plan_list->renderRow();
while ($ww_yarn_plan_list->RecCnt < $ww_yarn_plan_list->StopRec) {
	$ww_yarn_plan_list->RecCnt++;
	if ($ww_yarn_plan_list->RecCnt >= $ww_yarn_plan_list->StartRec) {
		$ww_yarn_plan_list->RowCnt++;

		// Set up key count
		$ww_yarn_plan_list->KeyCount = $ww_yarn_plan_list->RowIndex;

		// Init row class and style
		$ww_yarn_plan->resetAttributes();
		$ww_yarn_plan->CssClass = "";
		if ($ww_yarn_plan->isGridAdd()) {
		} else {
			$ww_yarn_plan_list->loadRowValues($ww_yarn_plan_list->Recordset); // Load row values
		}
		$ww_yarn_plan->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$ww_yarn_plan->RowAttrs = array_merge($ww_yarn_plan->RowAttrs, array('data-rowindex'=>$ww_yarn_plan_list->RowCnt, 'id'=>'r' . $ww_yarn_plan_list->RowCnt . '_ww_yarn_plan', 'data-rowtype'=>$ww_yarn_plan->RowType));

		// Render row
		$ww_yarn_plan_list->renderRow();

		// Render list options
		$ww_yarn_plan_list->renderListOptions();
?>
	<tr<?php echo $ww_yarn_plan->rowAttributes() ?>>
<?php

// Render list options (body, left)
$ww_yarn_plan_list->ListOptions->render("body", "left", $ww_yarn_plan_list->RowCnt);
?>
	<?php if ($ww_yarn_plan->id->Visible) { // id ?>
		<td data-name="id"<?php echo $ww_yarn_plan->id->cellAttributes() ?>>
<span id="el<?php echo $ww_yarn_plan_list->RowCnt ?>_ww_yarn_plan_id" class="ww_yarn_plan_id">
<span<?php echo $ww_yarn_plan->id->viewAttributes() ?>>
<?php echo $ww_yarn_plan->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ww_yarn_plan->period->Visible) { // period ?>
		<td data-name="period"<?php echo $ww_yarn_plan->period->cellAttributes() ?>>
<span id="el<?php echo $ww_yarn_plan_list->RowCnt ?>_ww_yarn_plan_period" class="ww_yarn_plan_period">
<span<?php echo $ww_yarn_plan->period->viewAttributes() ?>>
<?php echo $ww_yarn_plan->period->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ww_yarn_plan->y_id->Visible) { // y_id ?>
		<td data-name="y_id"<?php echo $ww_yarn_plan->y_id->cellAttributes() ?>>
<span id="el<?php echo $ww_yarn_plan_list->RowCnt ?>_ww_yarn_plan_y_id" class="ww_yarn_plan_y_id">
<span<?php echo $ww_yarn_plan->y_id->viewAttributes() ?>>
<?php echo $ww_yarn_plan->y_id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ww_yarn_plan->forcast->Visible) { // forcast ?>
		<td data-name="forcast"<?php echo $ww_yarn_plan->forcast->cellAttributes() ?>>
<span id="el<?php echo $ww_yarn_plan_list->RowCnt ?>_ww_yarn_plan_forcast" class="ww_yarn_plan_forcast">
<span<?php echo $ww_yarn_plan->forcast->viewAttributes() ?>>
<?php echo $ww_yarn_plan->forcast->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ww_yarn_plan->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $ww_yarn_plan->operator->cellAttributes() ?>>
<span id="el<?php echo $ww_yarn_plan_list->RowCnt ?>_ww_yarn_plan_operator" class="ww_yarn_plan_operator">
<span<?php echo $ww_yarn_plan->operator->viewAttributes() ?>>
<?php echo $ww_yarn_plan->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ww_yarn_plan->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $ww_yarn_plan->datetime->cellAttributes() ?>>
<span id="el<?php echo $ww_yarn_plan_list->RowCnt ?>_ww_yarn_plan_datetime" class="ww_yarn_plan_datetime">
<span<?php echo $ww_yarn_plan->datetime->viewAttributes() ?>>
<?php echo $ww_yarn_plan->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$ww_yarn_plan_list->ListOptions->render("body", "right", $ww_yarn_plan_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$ww_yarn_plan->isGridAdd())
		$ww_yarn_plan_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$ww_yarn_plan->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($ww_yarn_plan_list->Recordset)
	$ww_yarn_plan_list->Recordset->Close();
?>
<?php if (!$ww_yarn_plan->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$ww_yarn_plan->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($ww_yarn_plan_list->Pager)) $ww_yarn_plan_list->Pager = new PrevNextPager($ww_yarn_plan_list->StartRec, $ww_yarn_plan_list->DisplayRecs, $ww_yarn_plan_list->TotalRecs, $ww_yarn_plan_list->AutoHidePager) ?>
<?php if ($ww_yarn_plan_list->Pager->RecordCount > 0 && $ww_yarn_plan_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($ww_yarn_plan_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $ww_yarn_plan_list->pageUrl() ?>start=<?php echo $ww_yarn_plan_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($ww_yarn_plan_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $ww_yarn_plan_list->pageUrl() ?>start=<?php echo $ww_yarn_plan_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $ww_yarn_plan_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($ww_yarn_plan_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $ww_yarn_plan_list->pageUrl() ?>start=<?php echo $ww_yarn_plan_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($ww_yarn_plan_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $ww_yarn_plan_list->pageUrl() ?>start=<?php echo $ww_yarn_plan_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $ww_yarn_plan_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($ww_yarn_plan_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $ww_yarn_plan_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $ww_yarn_plan_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $ww_yarn_plan_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($ww_yarn_plan_list->TotalRecs > 0 && (!$ww_yarn_plan_list->AutoHidePageSizeSelector || $ww_yarn_plan_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="ww_yarn_plan">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($ww_yarn_plan_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($ww_yarn_plan_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($ww_yarn_plan_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($ww_yarn_plan_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($ww_yarn_plan_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($ww_yarn_plan->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $ww_yarn_plan_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($ww_yarn_plan_list->TotalRecs == 0 && !$ww_yarn_plan->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $ww_yarn_plan_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$ww_yarn_plan_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$ww_yarn_plan->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$ww_yarn_plan->isExport()) { ?>
<script>
ew.scrollableTable("gmp_ww_yarn_plan", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$ww_yarn_plan_list->terminate();
?>