<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$ww_yarn_plan_view = new ww_yarn_plan_view();

// Run the page
$ww_yarn_plan_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$ww_yarn_plan_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$ww_yarn_plan->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fww_yarn_planview = currentForm = new ew.Form("fww_yarn_planview", "view");

// Form_CustomValidate event
fww_yarn_planview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fww_yarn_planview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fww_yarn_planview.lists["x_period"] = <?php echo $ww_yarn_plan_view->period->Lookup->toClientList() ?>;
fww_yarn_planview.lists["x_period"].options = <?php echo JsonEncode($ww_yarn_plan_view->period->lookupOptions()) ?>;
fww_yarn_planview.lists["x_y_id"] = <?php echo $ww_yarn_plan_view->y_id->Lookup->toClientList() ?>;
fww_yarn_planview.lists["x_y_id"].options = <?php echo JsonEncode($ww_yarn_plan_view->y_id->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$ww_yarn_plan->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $ww_yarn_plan_view->ExportOptions->render("body") ?>
<?php $ww_yarn_plan_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $ww_yarn_plan_view->showPageHeader(); ?>
<?php
$ww_yarn_plan_view->showMessage();
?>
<form name="fww_yarn_planview" id="fww_yarn_planview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($ww_yarn_plan_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $ww_yarn_plan_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="ww_yarn_plan">
<input type="hidden" name="modal" value="<?php echo (int)$ww_yarn_plan_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($ww_yarn_plan->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $ww_yarn_plan_view->TableLeftColumnClass ?>"><span id="elh_ww_yarn_plan_id"><?php echo $ww_yarn_plan->id->caption() ?></span></td>
		<td data-name="id"<?php echo $ww_yarn_plan->id->cellAttributes() ?>>
<span id="el_ww_yarn_plan_id">
<span<?php echo $ww_yarn_plan->id->viewAttributes() ?>>
<?php echo $ww_yarn_plan->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ww_yarn_plan->period->Visible) { // period ?>
	<tr id="r_period">
		<td class="<?php echo $ww_yarn_plan_view->TableLeftColumnClass ?>"><span id="elh_ww_yarn_plan_period"><?php echo $ww_yarn_plan->period->caption() ?></span></td>
		<td data-name="period"<?php echo $ww_yarn_plan->period->cellAttributes() ?>>
<span id="el_ww_yarn_plan_period">
<span<?php echo $ww_yarn_plan->period->viewAttributes() ?>>
<?php echo $ww_yarn_plan->period->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ww_yarn_plan->y_id->Visible) { // y_id ?>
	<tr id="r_y_id">
		<td class="<?php echo $ww_yarn_plan_view->TableLeftColumnClass ?>"><span id="elh_ww_yarn_plan_y_id"><?php echo $ww_yarn_plan->y_id->caption() ?></span></td>
		<td data-name="y_id"<?php echo $ww_yarn_plan->y_id->cellAttributes() ?>>
<span id="el_ww_yarn_plan_y_id">
<span<?php echo $ww_yarn_plan->y_id->viewAttributes() ?>>
<?php echo $ww_yarn_plan->y_id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ww_yarn_plan->forcast->Visible) { // forcast ?>
	<tr id="r_forcast">
		<td class="<?php echo $ww_yarn_plan_view->TableLeftColumnClass ?>"><span id="elh_ww_yarn_plan_forcast"><?php echo $ww_yarn_plan->forcast->caption() ?></span></td>
		<td data-name="forcast"<?php echo $ww_yarn_plan->forcast->cellAttributes() ?>>
<span id="el_ww_yarn_plan_forcast">
<span<?php echo $ww_yarn_plan->forcast->viewAttributes() ?>>
<?php echo $ww_yarn_plan->forcast->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ww_yarn_plan->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $ww_yarn_plan_view->TableLeftColumnClass ?>"><span id="elh_ww_yarn_plan_operator"><?php echo $ww_yarn_plan->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $ww_yarn_plan->operator->cellAttributes() ?>>
<span id="el_ww_yarn_plan_operator">
<span<?php echo $ww_yarn_plan->operator->viewAttributes() ?>>
<?php echo $ww_yarn_plan->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ww_yarn_plan->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $ww_yarn_plan_view->TableLeftColumnClass ?>"><span id="elh_ww_yarn_plan_datetime"><?php echo $ww_yarn_plan->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $ww_yarn_plan->datetime->cellAttributes() ?>>
<span id="el_ww_yarn_plan_datetime">
<span<?php echo $ww_yarn_plan->datetime->viewAttributes() ?>>
<?php echo $ww_yarn_plan->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$ww_yarn_plan_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$ww_yarn_plan->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$ww_yarn_plan_view->terminate();
?>