<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$ww_yarn_add = new ww_yarn_add();

// Run the page
$ww_yarn_add->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$ww_yarn_add->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "add";
var fww_yarnadd = currentForm = new ew.Form("fww_yarnadd", "add");

// Validate form
fww_yarnadd.validate = function() {
	if (!this.validateRequired)
		return true; // Ignore validation
	var $ = jQuery, fobj = this.getForm(), $fobj = $(fobj);
	if ($fobj.find("#confirm").val() == "F")
		return true;
	var elm, felm, uelm, addcnt = 0;
	var $k = $fobj.find("#" + this.formKeyCountName); // Get key_count
	var rowcnt = ($k[0]) ? parseInt($k.val(), 10) : 1;
	var startcnt = (rowcnt == 0) ? 0 : 1; // Check rowcnt == 0 => Inline-Add
	var gridinsert = ["insert", "gridinsert"].includes($fobj.find("#action").val()) && $k[0];
	for (var i = startcnt; i <= rowcnt; i++) {
		var infix = ($k[0]) ? String(i) : "";
		$fobj.data("rowindex", infix);
		<?php if ($ww_yarn_add->yarn->Required) { ?>
			elm = this.getElements("x" + infix + "_yarn");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ww_yarn->yarn->caption(), $ww_yarn->yarn->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ww_yarn_add->ply_1_color->Required) { ?>
			elm = this.getElements("x" + infix + "_ply_1_color");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ww_yarn->ply_1_color->caption(), $ww_yarn->ply_1_color->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ww_yarn_add->ply_1_qty->Required) { ?>
			elm = this.getElements("x" + infix + "_ply_1_qty");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ww_yarn->ply_1_qty->caption(), $ww_yarn->ply_1_qty->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_ply_1_qty");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($ww_yarn->ply_1_qty->errorMessage()) ?>");
		<?php if ($ww_yarn_add->ply_2_color->Required) { ?>
			elm = this.getElements("x" + infix + "_ply_2_color");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ww_yarn->ply_2_color->caption(), $ww_yarn->ply_2_color->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ww_yarn_add->ply_2_qty->Required) { ?>
			elm = this.getElements("x" + infix + "_ply_2_qty");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ww_yarn->ply_2_qty->caption(), $ww_yarn->ply_2_qty->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_ply_2_qty");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($ww_yarn->ply_2_qty->errorMessage()) ?>");
		<?php if ($ww_yarn_add->ply_3_color->Required) { ?>
			elm = this.getElements("x" + infix + "_ply_3_color");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ww_yarn->ply_3_color->caption(), $ww_yarn->ply_3_color->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ww_yarn_add->ply_3_qty->Required) { ?>
			elm = this.getElements("x" + infix + "_ply_3_qty");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ww_yarn->ply_3_qty->caption(), $ww_yarn->ply_3_qty->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_ply_3_qty");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($ww_yarn->ply_3_qty->errorMessage()) ?>");
		<?php if ($ww_yarn_add->stock->Required) { ?>
			elm = this.getElements("x" + infix + "_stock");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ww_yarn->stock->caption(), $ww_yarn->stock->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_stock");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($ww_yarn->stock->errorMessage()) ?>");
		<?php if ($ww_yarn_add->operator->Required) { ?>
			elm = this.getElements("x" + infix + "_operator");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ww_yarn->operator->caption(), $ww_yarn->operator->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ww_yarn_add->datetime->Required) { ?>
			elm = this.getElements("x" + infix + "_datetime");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ww_yarn->datetime->caption(), $ww_yarn->datetime->RequiredErrorMessage)) ?>");
		<?php } ?>
		<?php if ($ww_yarn_add->moq->Required) { ?>
			elm = this.getElements("x" + infix + "_moq");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ww_yarn->moq->caption(), $ww_yarn->moq->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_moq");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($ww_yarn->moq->errorMessage()) ?>");
		<?php if ($ww_yarn_add->m_stock->Required) { ?>
			elm = this.getElements("x" + infix + "_m_stock");
			if (elm && !ew.isHidden(elm) && !ew.hasValue(elm))
				return this.onError(elm, "<?php echo JsEncode(str_replace("%s", $ww_yarn->m_stock->caption(), $ww_yarn->m_stock->RequiredErrorMessage)) ?>");
		<?php } ?>
			elm = this.getElements("x" + infix + "_m_stock");
			if (elm && !ew.checkNumber(elm.value))
				return this.onError(elm, "<?php echo JsEncode($ww_yarn->m_stock->errorMessage()) ?>");

			// Fire Form_CustomValidate event
			if (!this.Form_CustomValidate(fobj))
				return false;
	}

	// Process detail forms
	var dfs = $fobj.find("input[name='detailpage']").get();
	for (var i = 0; i < dfs.length; i++) {
		var df = dfs[i], val = df.value;
		if (val && ew.forms[val])
			if (!ew.forms[val].validate())
				return false;
	}
	return true;
}

// Form_CustomValidate event
fww_yarnadd.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fww_yarnadd.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fww_yarnadd.lists["x_yarn"] = <?php echo $ww_yarn_add->yarn->Lookup->toClientList() ?>;
fww_yarnadd.lists["x_yarn"].options = <?php echo JsonEncode($ww_yarn_add->yarn->lookupOptions()) ?>;
fww_yarnadd.lists["x_ply_1_color"] = <?php echo $ww_yarn_add->ply_1_color->Lookup->toClientList() ?>;
fww_yarnadd.lists["x_ply_1_color"].options = <?php echo JsonEncode($ww_yarn_add->ply_1_color->lookupOptions()) ?>;
fww_yarnadd.lists["x_ply_2_color"] = <?php echo $ww_yarn_add->ply_2_color->Lookup->toClientList() ?>;
fww_yarnadd.lists["x_ply_2_color"].options = <?php echo JsonEncode($ww_yarn_add->ply_2_color->lookupOptions()) ?>;
fww_yarnadd.lists["x_ply_3_color"] = <?php echo $ww_yarn_add->ply_3_color->Lookup->toClientList() ?>;
fww_yarnadd.lists["x_ply_3_color"].options = <?php echo JsonEncode($ww_yarn_add->ply_3_color->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $ww_yarn_add->showPageHeader(); ?>
<?php
$ww_yarn_add->showMessage();
?>
<form name="fww_yarnadd" id="fww_yarnadd" class="<?php echo $ww_yarn_add->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($ww_yarn_add->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $ww_yarn_add->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="ww_yarn">
<input type="hidden" name="action" id="action" value="insert">
<input type="hidden" name="modal" value="<?php echo (int)$ww_yarn_add->IsModal ?>">
<div class="ew-add-div"><!-- page* -->
<?php if ($ww_yarn->yarn->Visible) { // yarn ?>
	<div id="r_yarn" class="form-group row">
		<label id="elh_ww_yarn_yarn" for="x_yarn" class="<?php echo $ww_yarn_add->LeftColumnClass ?>"><?php echo $ww_yarn->yarn->caption() ?><?php echo ($ww_yarn->yarn->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ww_yarn_add->RightColumnClass ?>"><div<?php echo $ww_yarn->yarn->cellAttributes() ?>>
<span id="el_ww_yarn_yarn">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ww_yarn" data-field="x_yarn" data-value-separator="<?php echo $ww_yarn->yarn->displayValueSeparatorAttribute() ?>" id="x_yarn" name="x_yarn"<?php echo $ww_yarn->yarn->editAttributes() ?>>
		<?php echo $ww_yarn->yarn->selectOptionListHtml("x_yarn") ?>
	</select>
</div>
<?php echo $ww_yarn->yarn->Lookup->getParamTag("p_x_yarn") ?>
</span>
<?php echo $ww_yarn->yarn->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ww_yarn->ply_1_color->Visible) { // ply_1_color ?>
	<div id="r_ply_1_color" class="form-group row">
		<label id="elh_ww_yarn_ply_1_color" for="x_ply_1_color" class="<?php echo $ww_yarn_add->LeftColumnClass ?>"><?php echo $ww_yarn->ply_1_color->caption() ?><?php echo ($ww_yarn->ply_1_color->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ww_yarn_add->RightColumnClass ?>"><div<?php echo $ww_yarn->ply_1_color->cellAttributes() ?>>
<span id="el_ww_yarn_ply_1_color">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ww_yarn" data-field="x_ply_1_color" data-value-separator="<?php echo $ww_yarn->ply_1_color->displayValueSeparatorAttribute() ?>" id="x_ply_1_color" name="x_ply_1_color"<?php echo $ww_yarn->ply_1_color->editAttributes() ?>>
		<?php echo $ww_yarn->ply_1_color->selectOptionListHtml("x_ply_1_color") ?>
	</select>
</div>
<?php echo $ww_yarn->ply_1_color->Lookup->getParamTag("p_x_ply_1_color") ?>
</span>
<?php echo $ww_yarn->ply_1_color->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ww_yarn->ply_1_qty->Visible) { // ply_1_qty ?>
	<div id="r_ply_1_qty" class="form-group row">
		<label id="elh_ww_yarn_ply_1_qty" for="x_ply_1_qty" class="<?php echo $ww_yarn_add->LeftColumnClass ?>"><?php echo $ww_yarn->ply_1_qty->caption() ?><?php echo ($ww_yarn->ply_1_qty->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ww_yarn_add->RightColumnClass ?>"><div<?php echo $ww_yarn->ply_1_qty->cellAttributes() ?>>
<span id="el_ww_yarn_ply_1_qty">
<input type="text" data-table="ww_yarn" data-field="x_ply_1_qty" name="x_ply_1_qty" id="x_ply_1_qty" size="30" placeholder="<?php echo HtmlEncode($ww_yarn->ply_1_qty->getPlaceHolder()) ?>" value="<?php echo $ww_yarn->ply_1_qty->EditValue ?>"<?php echo $ww_yarn->ply_1_qty->editAttributes() ?>>
</span>
<?php echo $ww_yarn->ply_1_qty->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ww_yarn->ply_2_color->Visible) { // ply_2_color ?>
	<div id="r_ply_2_color" class="form-group row">
		<label id="elh_ww_yarn_ply_2_color" for="x_ply_2_color" class="<?php echo $ww_yarn_add->LeftColumnClass ?>"><?php echo $ww_yarn->ply_2_color->caption() ?><?php echo ($ww_yarn->ply_2_color->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ww_yarn_add->RightColumnClass ?>"><div<?php echo $ww_yarn->ply_2_color->cellAttributes() ?>>
<span id="el_ww_yarn_ply_2_color">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ww_yarn" data-field="x_ply_2_color" data-value-separator="<?php echo $ww_yarn->ply_2_color->displayValueSeparatorAttribute() ?>" id="x_ply_2_color" name="x_ply_2_color"<?php echo $ww_yarn->ply_2_color->editAttributes() ?>>
		<?php echo $ww_yarn->ply_2_color->selectOptionListHtml("x_ply_2_color") ?>
	</select>
</div>
<?php echo $ww_yarn->ply_2_color->Lookup->getParamTag("p_x_ply_2_color") ?>
</span>
<?php echo $ww_yarn->ply_2_color->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ww_yarn->ply_2_qty->Visible) { // ply_2_qty ?>
	<div id="r_ply_2_qty" class="form-group row">
		<label id="elh_ww_yarn_ply_2_qty" for="x_ply_2_qty" class="<?php echo $ww_yarn_add->LeftColumnClass ?>"><?php echo $ww_yarn->ply_2_qty->caption() ?><?php echo ($ww_yarn->ply_2_qty->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ww_yarn_add->RightColumnClass ?>"><div<?php echo $ww_yarn->ply_2_qty->cellAttributes() ?>>
<span id="el_ww_yarn_ply_2_qty">
<input type="text" data-table="ww_yarn" data-field="x_ply_2_qty" name="x_ply_2_qty" id="x_ply_2_qty" size="30" placeholder="<?php echo HtmlEncode($ww_yarn->ply_2_qty->getPlaceHolder()) ?>" value="<?php echo $ww_yarn->ply_2_qty->EditValue ?>"<?php echo $ww_yarn->ply_2_qty->editAttributes() ?>>
</span>
<?php echo $ww_yarn->ply_2_qty->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ww_yarn->ply_3_color->Visible) { // ply_3_color ?>
	<div id="r_ply_3_color" class="form-group row">
		<label id="elh_ww_yarn_ply_3_color" for="x_ply_3_color" class="<?php echo $ww_yarn_add->LeftColumnClass ?>"><?php echo $ww_yarn->ply_3_color->caption() ?><?php echo ($ww_yarn->ply_3_color->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ww_yarn_add->RightColumnClass ?>"><div<?php echo $ww_yarn->ply_3_color->cellAttributes() ?>>
<span id="el_ww_yarn_ply_3_color">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ww_yarn" data-field="x_ply_3_color" data-value-separator="<?php echo $ww_yarn->ply_3_color->displayValueSeparatorAttribute() ?>" id="x_ply_3_color" name="x_ply_3_color"<?php echo $ww_yarn->ply_3_color->editAttributes() ?>>
		<?php echo $ww_yarn->ply_3_color->selectOptionListHtml("x_ply_3_color") ?>
	</select>
</div>
<?php echo $ww_yarn->ply_3_color->Lookup->getParamTag("p_x_ply_3_color") ?>
</span>
<?php echo $ww_yarn->ply_3_color->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ww_yarn->ply_3_qty->Visible) { // ply_3_qty ?>
	<div id="r_ply_3_qty" class="form-group row">
		<label id="elh_ww_yarn_ply_3_qty" for="x_ply_3_qty" class="<?php echo $ww_yarn_add->LeftColumnClass ?>"><?php echo $ww_yarn->ply_3_qty->caption() ?><?php echo ($ww_yarn->ply_3_qty->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ww_yarn_add->RightColumnClass ?>"><div<?php echo $ww_yarn->ply_3_qty->cellAttributes() ?>>
<span id="el_ww_yarn_ply_3_qty">
<input type="text" data-table="ww_yarn" data-field="x_ply_3_qty" name="x_ply_3_qty" id="x_ply_3_qty" size="30" placeholder="<?php echo HtmlEncode($ww_yarn->ply_3_qty->getPlaceHolder()) ?>" value="<?php echo $ww_yarn->ply_3_qty->EditValue ?>"<?php echo $ww_yarn->ply_3_qty->editAttributes() ?>>
</span>
<?php echo $ww_yarn->ply_3_qty->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ww_yarn->stock->Visible) { // stock ?>
	<div id="r_stock" class="form-group row">
		<label id="elh_ww_yarn_stock" for="x_stock" class="<?php echo $ww_yarn_add->LeftColumnClass ?>"><?php echo $ww_yarn->stock->caption() ?><?php echo ($ww_yarn->stock->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ww_yarn_add->RightColumnClass ?>"><div<?php echo $ww_yarn->stock->cellAttributes() ?>>
<span id="el_ww_yarn_stock">
<input type="text" data-table="ww_yarn" data-field="x_stock" name="x_stock" id="x_stock" size="30" placeholder="<?php echo HtmlEncode($ww_yarn->stock->getPlaceHolder()) ?>" value="<?php echo $ww_yarn->stock->EditValue ?>"<?php echo $ww_yarn->stock->editAttributes() ?>>
</span>
<?php echo $ww_yarn->stock->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ww_yarn->moq->Visible) { // moq ?>
	<div id="r_moq" class="form-group row">
		<label id="elh_ww_yarn_moq" for="x_moq" class="<?php echo $ww_yarn_add->LeftColumnClass ?>"><?php echo $ww_yarn->moq->caption() ?><?php echo ($ww_yarn->moq->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ww_yarn_add->RightColumnClass ?>"><div<?php echo $ww_yarn->moq->cellAttributes() ?>>
<span id="el_ww_yarn_moq">
<input type="text" data-table="ww_yarn" data-field="x_moq" name="x_moq" id="x_moq" size="30" placeholder="<?php echo HtmlEncode($ww_yarn->moq->getPlaceHolder()) ?>" value="<?php echo $ww_yarn->moq->EditValue ?>"<?php echo $ww_yarn->moq->editAttributes() ?>>
</span>
<?php echo $ww_yarn->moq->CustomMsg ?></div></div>
	</div>
<?php } ?>
<?php if ($ww_yarn->m_stock->Visible) { // m_stock ?>
	<div id="r_m_stock" class="form-group row">
		<label id="elh_ww_yarn_m_stock" for="x_m_stock" class="<?php echo $ww_yarn_add->LeftColumnClass ?>"><?php echo $ww_yarn->m_stock->caption() ?><?php echo ($ww_yarn->m_stock->Required) ? $Language->phrase("FieldRequiredIndicator") : "" ?></label>
		<div class="<?php echo $ww_yarn_add->RightColumnClass ?>"><div<?php echo $ww_yarn->m_stock->cellAttributes() ?>>
<span id="el_ww_yarn_m_stock">
<input type="text" data-table="ww_yarn" data-field="x_m_stock" name="x_m_stock" id="x_m_stock" size="30" placeholder="<?php echo HtmlEncode($ww_yarn->m_stock->getPlaceHolder()) ?>" value="<?php echo $ww_yarn->m_stock->EditValue ?>"<?php echo $ww_yarn->m_stock->editAttributes() ?>>
</span>
<?php echo $ww_yarn->m_stock->CustomMsg ?></div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$ww_yarn_add->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $ww_yarn_add->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("AddBtn") ?></button>
<button class="btn btn-default ew-btn" name="btn-cancel" id="btn-cancel" type="button" data-href="<?php echo $ww_yarn_add->getReturnUrl() ?>"><?php echo $Language->phrase("CancelBtn") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$ww_yarn_add->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$ww_yarn_add->terminate();
?>