<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$ww_yarn_list = new ww_yarn_list();

// Run the page
$ww_yarn_list->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$ww_yarn_list->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$ww_yarn->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "list";
var fww_yarnlist = currentForm = new ew.Form("fww_yarnlist", "list");
fww_yarnlist.formKeyCountName = '<?php echo $ww_yarn_list->FormKeyCountName ?>';

// Form_CustomValidate event
fww_yarnlist.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fww_yarnlist.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fww_yarnlist.lists["x_yarn"] = <?php echo $ww_yarn_list->yarn->Lookup->toClientList() ?>;
fww_yarnlist.lists["x_yarn"].options = <?php echo JsonEncode($ww_yarn_list->yarn->lookupOptions()) ?>;
fww_yarnlist.lists["x_ply_1_color"] = <?php echo $ww_yarn_list->ply_1_color->Lookup->toClientList() ?>;
fww_yarnlist.lists["x_ply_1_color"].options = <?php echo JsonEncode($ww_yarn_list->ply_1_color->lookupOptions()) ?>;
fww_yarnlist.lists["x_ply_2_color"] = <?php echo $ww_yarn_list->ply_2_color->Lookup->toClientList() ?>;
fww_yarnlist.lists["x_ply_2_color"].options = <?php echo JsonEncode($ww_yarn_list->ply_2_color->lookupOptions()) ?>;
fww_yarnlist.lists["x_ply_3_color"] = <?php echo $ww_yarn_list->ply_3_color->Lookup->toClientList() ?>;
fww_yarnlist.lists["x_ply_3_color"].options = <?php echo JsonEncode($ww_yarn_list->ply_3_color->lookupOptions()) ?>;

// Form object for search
var fww_yarnlistsrch = currentSearchForm = new ew.Form("fww_yarnlistsrch");

// Filters
fww_yarnlistsrch.filterList = <?php echo $ww_yarn_list->getFilterList() ?>;

// Init search panel as collapsed
fww_yarnlistsrch.initSearchPanel = true;
</script>
<style type="text/css">
.ew-table-preview-row { /* main table preview row color */
	background-color: #FFFFFF; /* preview row color */
}
.ew-table-preview-row .ew-grid {
	display: table;
}
</style>
<div id="ew-preview" class="d-none"><!-- preview -->
	<div class="ew-nav-tabs"><!-- .ew-nav-tabs -->
		<ul class="nav nav-tabs"></ul>
		<div class="tab-content"><!-- .tab-content -->
			<div class="tab-pane fade active show"></div>
		</div><!-- /.tab-content -->
	</div><!-- /.ew-nav-tabs -->
</div><!-- /preview -->
<script src="phpjs/ewpreview.js"></script>
<script>
ew.PREVIEW_PLACEMENT = ew.CSS_FLIP ? "left" : "right";
ew.PREVIEW_SINGLE_ROW = false;
ew.PREVIEW_OVERLAY = false;
</script>
<script src="phpjs/ewscrolltable.js"></script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$ww_yarn->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php if ($ww_yarn_list->TotalRecs > 0 && $ww_yarn_list->ExportOptions->visible()) { ?>
<?php $ww_yarn_list->ExportOptions->render("body") ?>
<?php } ?>
<?php if ($ww_yarn_list->ImportOptions->visible()) { ?>
<?php $ww_yarn_list->ImportOptions->render("body") ?>
<?php } ?>
<?php if ($ww_yarn_list->SearchOptions->visible()) { ?>
<?php $ww_yarn_list->SearchOptions->render("body") ?>
<?php } ?>
<?php if ($ww_yarn_list->FilterOptions->visible()) { ?>
<?php $ww_yarn_list->FilterOptions->render("body") ?>
<?php } ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php
$ww_yarn_list->renderOtherOptions();
?>
<?php if ($Security->CanSearch()) { ?>
<?php if (!$ww_yarn->isExport() && !$ww_yarn->CurrentAction) { ?>
<form name="fww_yarnlistsrch" id="fww_yarnlistsrch" class="form-inline ew-form ew-ext-search-form" action="<?php echo CurrentPageName() ?>">
<?php $searchPanelClass = ($ww_yarn_list->SearchWhere <> "") ? " show" : ""; ?>
<div id="fww_yarnlistsrch-search-panel" class="ew-search-panel collapse<?php echo $searchPanelClass ?>">
<input type="hidden" name="cmd" value="search">
<input type="hidden" name="t" value="ww_yarn">
	<div class="ew-basic-search">
<div id="xsr_1" class="ew-row d-sm-flex">
	<div class="ew-quick-search input-group">
		<input type="text" name="<?php echo TABLE_BASIC_SEARCH ?>" id="<?php echo TABLE_BASIC_SEARCH ?>" class="form-control" value="<?php echo HtmlEncode($ww_yarn_list->BasicSearch->getKeyword()) ?>" placeholder="<?php echo HtmlEncode($Language->phrase("Search")) ?>">
		<input type="hidden" name="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" id="<?php echo TABLE_BASIC_SEARCH_TYPE ?>" value="<?php echo HtmlEncode($ww_yarn_list->BasicSearch->getType()) ?>">
		<div class="input-group-append">
			<button class="btn btn-primary" name="btn-submit" id="btn-submit" type="submit"><?php echo $Language->phrase("SearchBtn") ?></button>
			<button type="button" data-toggle="dropdown" class="btn btn-primary dropdown-toggle dropdown-toggle-split" aria-haspopup="true" aria-expanded="false"><span id="searchtype"><?php echo $ww_yarn_list->BasicSearch->getTypeNameShort() ?></span></button>
			<div class="dropdown-menu dropdown-menu-right">
				<a class="dropdown-item<?php if ($ww_yarn_list->BasicSearch->getType() == "") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this)"><?php echo $Language->phrase("QuickSearchAuto") ?></a>
				<a class="dropdown-item<?php if ($ww_yarn_list->BasicSearch->getType() == "=") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'=')"><?php echo $Language->phrase("QuickSearchExact") ?></a>
				<a class="dropdown-item<?php if ($ww_yarn_list->BasicSearch->getType() == "AND") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'AND')"><?php echo $Language->phrase("QuickSearchAll") ?></a>
				<a class="dropdown-item<?php if ($ww_yarn_list->BasicSearch->getType() == "OR") echo " active"; ?>" href="javascript:void(0);" onclick="ew.setSearchType(this,'OR')"><?php echo $Language->phrase("QuickSearchAny") ?></a>
			</div>
		</div>
	</div>
</div>
	</div>
</div>
</form>
<?php } ?>
<?php } ?>
<?php $ww_yarn_list->showPageHeader(); ?>
<?php
$ww_yarn_list->showMessage();
?>
<?php if ($ww_yarn_list->TotalRecs > 0 || $ww_yarn->CurrentAction) { ?>
<div class="card ew-card ew-grid<?php if ($ww_yarn_list->isAddOrEdit()) { ?> ew-grid-add-edit<?php } ?> ww_yarn">
<?php if (!$ww_yarn->isExport()) { ?>
<div class="card-header ew-grid-upper-panel">
<?php if (!$ww_yarn->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($ww_yarn_list->Pager)) $ww_yarn_list->Pager = new PrevNextPager($ww_yarn_list->StartRec, $ww_yarn_list->DisplayRecs, $ww_yarn_list->TotalRecs, $ww_yarn_list->AutoHidePager) ?>
<?php if ($ww_yarn_list->Pager->RecordCount > 0 && $ww_yarn_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($ww_yarn_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $ww_yarn_list->pageUrl() ?>start=<?php echo $ww_yarn_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($ww_yarn_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $ww_yarn_list->pageUrl() ?>start=<?php echo $ww_yarn_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $ww_yarn_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($ww_yarn_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $ww_yarn_list->pageUrl() ?>start=<?php echo $ww_yarn_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($ww_yarn_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $ww_yarn_list->pageUrl() ?>start=<?php echo $ww_yarn_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $ww_yarn_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($ww_yarn_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $ww_yarn_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $ww_yarn_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $ww_yarn_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($ww_yarn_list->TotalRecs > 0 && (!$ww_yarn_list->AutoHidePageSizeSelector || $ww_yarn_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="ww_yarn">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($ww_yarn_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($ww_yarn_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($ww_yarn_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($ww_yarn_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($ww_yarn_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($ww_yarn->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $ww_yarn_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
<form name="fww_yarnlist" id="fww_yarnlist" class="form-inline ew-form ew-list-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($ww_yarn_list->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $ww_yarn_list->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="ww_yarn">
<div id="gmp_ww_yarn" class="<?php if (IsResponsiveLayout()) { ?>table-responsive <?php } ?>card-body ew-grid-middle-panel">
<?php if ($ww_yarn_list->TotalRecs > 0 || $ww_yarn->isGridEdit()) { ?>
<table id="tbl_ww_yarnlist" class="table ew-table"><!-- .ew-table ##-->
<thead>
	<tr class="ew-table-header">
<?php

// Header row
$ww_yarn_list->RowType = ROWTYPE_HEADER;

// Render list options
$ww_yarn_list->renderListOptions();

// Render list options (header, left)
$ww_yarn_list->ListOptions->render("header", "left");
?>
<?php if ($ww_yarn->id->Visible) { // id ?>
	<?php if ($ww_yarn->sortUrl($ww_yarn->id) == "") { ?>
		<th data-name="id" class="<?php echo $ww_yarn->id->headerCellClass() ?>"><div id="elh_ww_yarn_id" class="ww_yarn_id"><div class="ew-table-header-caption"><?php echo $ww_yarn->id->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="id" class="<?php echo $ww_yarn->id->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ww_yarn->SortUrl($ww_yarn->id) ?>',2);"><div id="elh_ww_yarn_id" class="ww_yarn_id">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ww_yarn->id->caption() ?><?php echo $Language->phrase("SrchLegend") ?></span><span class="ew-table-header-sort"><?php if ($ww_yarn->id->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ww_yarn->id->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ww_yarn->yarn->Visible) { // yarn ?>
	<?php if ($ww_yarn->sortUrl($ww_yarn->yarn) == "") { ?>
		<th data-name="yarn" class="<?php echo $ww_yarn->yarn->headerCellClass() ?>"><div id="elh_ww_yarn_yarn" class="ww_yarn_yarn"><div class="ew-table-header-caption"><?php echo $ww_yarn->yarn->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="yarn" class="<?php echo $ww_yarn->yarn->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ww_yarn->SortUrl($ww_yarn->yarn) ?>',2);"><div id="elh_ww_yarn_yarn" class="ww_yarn_yarn">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ww_yarn->yarn->caption() ?></span><span class="ew-table-header-sort"><?php if ($ww_yarn->yarn->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ww_yarn->yarn->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ww_yarn->ply_1_color->Visible) { // ply_1_color ?>
	<?php if ($ww_yarn->sortUrl($ww_yarn->ply_1_color) == "") { ?>
		<th data-name="ply_1_color" class="<?php echo $ww_yarn->ply_1_color->headerCellClass() ?>"><div id="elh_ww_yarn_ply_1_color" class="ww_yarn_ply_1_color"><div class="ew-table-header-caption"><?php echo $ww_yarn->ply_1_color->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ply_1_color" class="<?php echo $ww_yarn->ply_1_color->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ww_yarn->SortUrl($ww_yarn->ply_1_color) ?>',2);"><div id="elh_ww_yarn_ply_1_color" class="ww_yarn_ply_1_color">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ww_yarn->ply_1_color->caption() ?></span><span class="ew-table-header-sort"><?php if ($ww_yarn->ply_1_color->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ww_yarn->ply_1_color->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ww_yarn->ply_1_qty->Visible) { // ply_1_qty ?>
	<?php if ($ww_yarn->sortUrl($ww_yarn->ply_1_qty) == "") { ?>
		<th data-name="ply_1_qty" class="<?php echo $ww_yarn->ply_1_qty->headerCellClass() ?>"><div id="elh_ww_yarn_ply_1_qty" class="ww_yarn_ply_1_qty"><div class="ew-table-header-caption"><?php echo $ww_yarn->ply_1_qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ply_1_qty" class="<?php echo $ww_yarn->ply_1_qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ww_yarn->SortUrl($ww_yarn->ply_1_qty) ?>',2);"><div id="elh_ww_yarn_ply_1_qty" class="ww_yarn_ply_1_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ww_yarn->ply_1_qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($ww_yarn->ply_1_qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ww_yarn->ply_1_qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ww_yarn->ply_2_color->Visible) { // ply_2_color ?>
	<?php if ($ww_yarn->sortUrl($ww_yarn->ply_2_color) == "") { ?>
		<th data-name="ply_2_color" class="<?php echo $ww_yarn->ply_2_color->headerCellClass() ?>"><div id="elh_ww_yarn_ply_2_color" class="ww_yarn_ply_2_color"><div class="ew-table-header-caption"><?php echo $ww_yarn->ply_2_color->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ply_2_color" class="<?php echo $ww_yarn->ply_2_color->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ww_yarn->SortUrl($ww_yarn->ply_2_color) ?>',2);"><div id="elh_ww_yarn_ply_2_color" class="ww_yarn_ply_2_color">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ww_yarn->ply_2_color->caption() ?></span><span class="ew-table-header-sort"><?php if ($ww_yarn->ply_2_color->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ww_yarn->ply_2_color->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ww_yarn->ply_2_qty->Visible) { // ply_2_qty ?>
	<?php if ($ww_yarn->sortUrl($ww_yarn->ply_2_qty) == "") { ?>
		<th data-name="ply_2_qty" class="<?php echo $ww_yarn->ply_2_qty->headerCellClass() ?>"><div id="elh_ww_yarn_ply_2_qty" class="ww_yarn_ply_2_qty"><div class="ew-table-header-caption"><?php echo $ww_yarn->ply_2_qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ply_2_qty" class="<?php echo $ww_yarn->ply_2_qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ww_yarn->SortUrl($ww_yarn->ply_2_qty) ?>',2);"><div id="elh_ww_yarn_ply_2_qty" class="ww_yarn_ply_2_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ww_yarn->ply_2_qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($ww_yarn->ply_2_qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ww_yarn->ply_2_qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ww_yarn->ply_3_color->Visible) { // ply_3_color ?>
	<?php if ($ww_yarn->sortUrl($ww_yarn->ply_3_color) == "") { ?>
		<th data-name="ply_3_color" class="<?php echo $ww_yarn->ply_3_color->headerCellClass() ?>"><div id="elh_ww_yarn_ply_3_color" class="ww_yarn_ply_3_color"><div class="ew-table-header-caption"><?php echo $ww_yarn->ply_3_color->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ply_3_color" class="<?php echo $ww_yarn->ply_3_color->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ww_yarn->SortUrl($ww_yarn->ply_3_color) ?>',2);"><div id="elh_ww_yarn_ply_3_color" class="ww_yarn_ply_3_color">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ww_yarn->ply_3_color->caption() ?></span><span class="ew-table-header-sort"><?php if ($ww_yarn->ply_3_color->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ww_yarn->ply_3_color->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ww_yarn->ply_3_qty->Visible) { // ply_3_qty ?>
	<?php if ($ww_yarn->sortUrl($ww_yarn->ply_3_qty) == "") { ?>
		<th data-name="ply_3_qty" class="<?php echo $ww_yarn->ply_3_qty->headerCellClass() ?>"><div id="elh_ww_yarn_ply_3_qty" class="ww_yarn_ply_3_qty"><div class="ew-table-header-caption"><?php echo $ww_yarn->ply_3_qty->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ply_3_qty" class="<?php echo $ww_yarn->ply_3_qty->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ww_yarn->SortUrl($ww_yarn->ply_3_qty) ?>',2);"><div id="elh_ww_yarn_ply_3_qty" class="ww_yarn_ply_3_qty">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ww_yarn->ply_3_qty->caption() ?></span><span class="ew-table-header-sort"><?php if ($ww_yarn->ply_3_qty->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ww_yarn->ply_3_qty->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ww_yarn->stock->Visible) { // stock ?>
	<?php if ($ww_yarn->sortUrl($ww_yarn->stock) == "") { ?>
		<th data-name="stock" class="<?php echo $ww_yarn->stock->headerCellClass() ?>"><div id="elh_ww_yarn_stock" class="ww_yarn_stock"><div class="ew-table-header-caption"><?php echo $ww_yarn->stock->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="stock" class="<?php echo $ww_yarn->stock->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ww_yarn->SortUrl($ww_yarn->stock) ?>',2);"><div id="elh_ww_yarn_stock" class="ww_yarn_stock">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ww_yarn->stock->caption() ?></span><span class="ew-table-header-sort"><?php if ($ww_yarn->stock->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ww_yarn->stock->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ww_yarn->operator->Visible) { // operator ?>
	<?php if ($ww_yarn->sortUrl($ww_yarn->operator) == "") { ?>
		<th data-name="operator" class="<?php echo $ww_yarn->operator->headerCellClass() ?>"><div id="elh_ww_yarn_operator" class="ww_yarn_operator"><div class="ew-table-header-caption"><?php echo $ww_yarn->operator->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="operator" class="<?php echo $ww_yarn->operator->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ww_yarn->SortUrl($ww_yarn->operator) ?>',2);"><div id="elh_ww_yarn_operator" class="ww_yarn_operator">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ww_yarn->operator->caption() ?></span><span class="ew-table-header-sort"><?php if ($ww_yarn->operator->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ww_yarn->operator->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ww_yarn->datetime->Visible) { // datetime ?>
	<?php if ($ww_yarn->sortUrl($ww_yarn->datetime) == "") { ?>
		<th data-name="datetime" class="<?php echo $ww_yarn->datetime->headerCellClass() ?>"><div id="elh_ww_yarn_datetime" class="ww_yarn_datetime"><div class="ew-table-header-caption"><?php echo $ww_yarn->datetime->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="datetime" class="<?php echo $ww_yarn->datetime->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ww_yarn->SortUrl($ww_yarn->datetime) ?>',2);"><div id="elh_ww_yarn_datetime" class="ww_yarn_datetime">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ww_yarn->datetime->caption() ?></span><span class="ew-table-header-sort"><?php if ($ww_yarn->datetime->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ww_yarn->datetime->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ww_yarn->moq->Visible) { // moq ?>
	<?php if ($ww_yarn->sortUrl($ww_yarn->moq) == "") { ?>
		<th data-name="moq" class="<?php echo $ww_yarn->moq->headerCellClass() ?>"><div id="elh_ww_yarn_moq" class="ww_yarn_moq"><div class="ew-table-header-caption"><?php echo $ww_yarn->moq->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="moq" class="<?php echo $ww_yarn->moq->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ww_yarn->SortUrl($ww_yarn->moq) ?>',2);"><div id="elh_ww_yarn_moq" class="ww_yarn_moq">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ww_yarn->moq->caption() ?></span><span class="ew-table-header-sort"><?php if ($ww_yarn->moq->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ww_yarn->moq->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ww_yarn->m_stock->Visible) { // m_stock ?>
	<?php if ($ww_yarn->sortUrl($ww_yarn->m_stock) == "") { ?>
		<th data-name="m_stock" class="<?php echo $ww_yarn->m_stock->headerCellClass() ?>"><div id="elh_ww_yarn_m_stock" class="ww_yarn_m_stock"><div class="ew-table-header-caption"><?php echo $ww_yarn->m_stock->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="m_stock" class="<?php echo $ww_yarn->m_stock->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ww_yarn->SortUrl($ww_yarn->m_stock) ?>',2);"><div id="elh_ww_yarn_m_stock" class="ww_yarn_m_stock">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ww_yarn->m_stock->caption() ?></span><span class="ew-table-header-sort"><?php if ($ww_yarn->m_stock->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ww_yarn->m_stock->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ww_yarn->required->Visible) { // required ?>
	<?php if ($ww_yarn->sortUrl($ww_yarn->required) == "") { ?>
		<th data-name="required" class="<?php echo $ww_yarn->required->headerCellClass() ?>"><div id="elh_ww_yarn_required" class="ww_yarn_required"><div class="ew-table-header-caption"><?php echo $ww_yarn->required->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="required" class="<?php echo $ww_yarn->required->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ww_yarn->SortUrl($ww_yarn->required) ?>',2);"><div id="elh_ww_yarn_required" class="ww_yarn_required">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ww_yarn->required->caption() ?></span><span class="ew-table-header-sort"><?php if ($ww_yarn->required->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ww_yarn->required->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ww_yarn->ordered->Visible) { // ordered ?>
	<?php if ($ww_yarn->sortUrl($ww_yarn->ordered) == "") { ?>
		<th data-name="ordered" class="<?php echo $ww_yarn->ordered->headerCellClass() ?>"><div id="elh_ww_yarn_ordered" class="ww_yarn_ordered"><div class="ew-table-header-caption"><?php echo $ww_yarn->ordered->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="ordered" class="<?php echo $ww_yarn->ordered->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ww_yarn->SortUrl($ww_yarn->ordered) ?>',2);"><div id="elh_ww_yarn_ordered" class="ww_yarn_ordered">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ww_yarn->ordered->caption() ?></span><span class="ew-table-header-sort"><?php if ($ww_yarn->ordered->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ww_yarn->ordered->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php if ($ww_yarn->pending_order->Visible) { // pending_order ?>
	<?php if ($ww_yarn->sortUrl($ww_yarn->pending_order) == "") { ?>
		<th data-name="pending_order" class="<?php echo $ww_yarn->pending_order->headerCellClass() ?>"><div id="elh_ww_yarn_pending_order" class="ww_yarn_pending_order"><div class="ew-table-header-caption"><?php echo $ww_yarn->pending_order->caption() ?></div></div></th>
	<?php } else { ?>
		<th data-name="pending_order" class="<?php echo $ww_yarn->pending_order->headerCellClass() ?>"><div class="ew-pointer" onclick="ew.sort(event,'<?php echo $ww_yarn->SortUrl($ww_yarn->pending_order) ?>',2);"><div id="elh_ww_yarn_pending_order" class="ww_yarn_pending_order">
			<div class="ew-table-header-btn"><span class="ew-table-header-caption"><?php echo $ww_yarn->pending_order->caption() ?></span><span class="ew-table-header-sort"><?php if ($ww_yarn->pending_order->getSort() == "ASC") { ?><i class="fa fa-sort-up"></i><?php } elseif ($ww_yarn->pending_order->getSort() == "DESC") { ?><i class="fa fa-sort-down"></i><?php } ?></span></div>
		</div></div></th>
	<?php } ?>
<?php } ?>
<?php

// Render list options (header, right)
$ww_yarn_list->ListOptions->render("header", "right");
?>
	</tr>
</thead>
<tbody>
<?php
if ($ww_yarn->ExportAll && $ww_yarn->isExport()) {
	$ww_yarn_list->StopRec = $ww_yarn_list->TotalRecs;
} else {

	// Set the last record to display
	if ($ww_yarn_list->TotalRecs > $ww_yarn_list->StartRec + $ww_yarn_list->DisplayRecs - 1)
		$ww_yarn_list->StopRec = $ww_yarn_list->StartRec + $ww_yarn_list->DisplayRecs - 1;
	else
		$ww_yarn_list->StopRec = $ww_yarn_list->TotalRecs;
}
$ww_yarn_list->RecCnt = $ww_yarn_list->StartRec - 1;
if ($ww_yarn_list->Recordset && !$ww_yarn_list->Recordset->EOF) {
	$ww_yarn_list->Recordset->moveFirst();
	$selectLimit = $ww_yarn_list->UseSelectLimit;
	if (!$selectLimit && $ww_yarn_list->StartRec > 1)
		$ww_yarn_list->Recordset->move($ww_yarn_list->StartRec - 1);
} elseif (!$ww_yarn->AllowAddDeleteRow && $ww_yarn_list->StopRec == 0) {
	$ww_yarn_list->StopRec = $ww_yarn->GridAddRowCount;
}

// Initialize aggregate
$ww_yarn->RowType = ROWTYPE_AGGREGATEINIT;
$ww_yarn->resetAttributes();
$ww_yarn_list->renderRow();
while ($ww_yarn_list->RecCnt < $ww_yarn_list->StopRec) {
	$ww_yarn_list->RecCnt++;
	if ($ww_yarn_list->RecCnt >= $ww_yarn_list->StartRec) {
		$ww_yarn_list->RowCnt++;

		// Set up key count
		$ww_yarn_list->KeyCount = $ww_yarn_list->RowIndex;

		// Init row class and style
		$ww_yarn->resetAttributes();
		$ww_yarn->CssClass = "";
		if ($ww_yarn->isGridAdd()) {
		} else {
			$ww_yarn_list->loadRowValues($ww_yarn_list->Recordset); // Load row values
		}
		$ww_yarn->RowType = ROWTYPE_VIEW; // Render view

		// Set up row id / data-rowindex
		$ww_yarn->RowAttrs = array_merge($ww_yarn->RowAttrs, array('data-rowindex'=>$ww_yarn_list->RowCnt, 'id'=>'r' . $ww_yarn_list->RowCnt . '_ww_yarn', 'data-rowtype'=>$ww_yarn->RowType));

		// Render row
		$ww_yarn_list->renderRow();

		// Render list options
		$ww_yarn_list->renderListOptions();
?>
	<tr<?php echo $ww_yarn->rowAttributes() ?>>
<?php

// Render list options (body, left)
$ww_yarn_list->ListOptions->render("body", "left", $ww_yarn_list->RowCnt);
?>
	<?php if ($ww_yarn->id->Visible) { // id ?>
		<td data-name="id"<?php echo $ww_yarn->id->cellAttributes() ?>>
<span id="el<?php echo $ww_yarn_list->RowCnt ?>_ww_yarn_id" class="ww_yarn_id">
<span<?php echo $ww_yarn->id->viewAttributes() ?>>
<?php echo $ww_yarn->id->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ww_yarn->yarn->Visible) { // yarn ?>
		<td data-name="yarn"<?php echo $ww_yarn->yarn->cellAttributes() ?>>
<span id="el<?php echo $ww_yarn_list->RowCnt ?>_ww_yarn_yarn" class="ww_yarn_yarn">
<span<?php echo $ww_yarn->yarn->viewAttributes() ?>>
<?php echo $ww_yarn->yarn->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ww_yarn->ply_1_color->Visible) { // ply_1_color ?>
		<td data-name="ply_1_color"<?php echo $ww_yarn->ply_1_color->cellAttributes() ?>>
<span id="el<?php echo $ww_yarn_list->RowCnt ?>_ww_yarn_ply_1_color" class="ww_yarn_ply_1_color">
<span<?php echo $ww_yarn->ply_1_color->viewAttributes() ?>>
<?php echo $ww_yarn->ply_1_color->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ww_yarn->ply_1_qty->Visible) { // ply_1_qty ?>
		<td data-name="ply_1_qty"<?php echo $ww_yarn->ply_1_qty->cellAttributes() ?>>
<span id="el<?php echo $ww_yarn_list->RowCnt ?>_ww_yarn_ply_1_qty" class="ww_yarn_ply_1_qty">
<span<?php echo $ww_yarn->ply_1_qty->viewAttributes() ?>>
<?php echo $ww_yarn->ply_1_qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ww_yarn->ply_2_color->Visible) { // ply_2_color ?>
		<td data-name="ply_2_color"<?php echo $ww_yarn->ply_2_color->cellAttributes() ?>>
<span id="el<?php echo $ww_yarn_list->RowCnt ?>_ww_yarn_ply_2_color" class="ww_yarn_ply_2_color">
<span<?php echo $ww_yarn->ply_2_color->viewAttributes() ?>>
<?php echo $ww_yarn->ply_2_color->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ww_yarn->ply_2_qty->Visible) { // ply_2_qty ?>
		<td data-name="ply_2_qty"<?php echo $ww_yarn->ply_2_qty->cellAttributes() ?>>
<span id="el<?php echo $ww_yarn_list->RowCnt ?>_ww_yarn_ply_2_qty" class="ww_yarn_ply_2_qty">
<span<?php echo $ww_yarn->ply_2_qty->viewAttributes() ?>>
<?php echo $ww_yarn->ply_2_qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ww_yarn->ply_3_color->Visible) { // ply_3_color ?>
		<td data-name="ply_3_color"<?php echo $ww_yarn->ply_3_color->cellAttributes() ?>>
<span id="el<?php echo $ww_yarn_list->RowCnt ?>_ww_yarn_ply_3_color" class="ww_yarn_ply_3_color">
<span<?php echo $ww_yarn->ply_3_color->viewAttributes() ?>>
<?php echo $ww_yarn->ply_3_color->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ww_yarn->ply_3_qty->Visible) { // ply_3_qty ?>
		<td data-name="ply_3_qty"<?php echo $ww_yarn->ply_3_qty->cellAttributes() ?>>
<span id="el<?php echo $ww_yarn_list->RowCnt ?>_ww_yarn_ply_3_qty" class="ww_yarn_ply_3_qty">
<span<?php echo $ww_yarn->ply_3_qty->viewAttributes() ?>>
<?php echo $ww_yarn->ply_3_qty->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ww_yarn->stock->Visible) { // stock ?>
		<td data-name="stock"<?php echo $ww_yarn->stock->cellAttributes() ?>>
<span id="el<?php echo $ww_yarn_list->RowCnt ?>_ww_yarn_stock" class="ww_yarn_stock">
<span<?php echo $ww_yarn->stock->viewAttributes() ?>>
<?php echo $ww_yarn->stock->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ww_yarn->operator->Visible) { // operator ?>
		<td data-name="operator"<?php echo $ww_yarn->operator->cellAttributes() ?>>
<span id="el<?php echo $ww_yarn_list->RowCnt ?>_ww_yarn_operator" class="ww_yarn_operator">
<span<?php echo $ww_yarn->operator->viewAttributes() ?>>
<?php echo $ww_yarn->operator->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ww_yarn->datetime->Visible) { // datetime ?>
		<td data-name="datetime"<?php echo $ww_yarn->datetime->cellAttributes() ?>>
<span id="el<?php echo $ww_yarn_list->RowCnt ?>_ww_yarn_datetime" class="ww_yarn_datetime">
<span<?php echo $ww_yarn->datetime->viewAttributes() ?>>
<?php echo $ww_yarn->datetime->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ww_yarn->moq->Visible) { // moq ?>
		<td data-name="moq"<?php echo $ww_yarn->moq->cellAttributes() ?>>
<span id="el<?php echo $ww_yarn_list->RowCnt ?>_ww_yarn_moq" class="ww_yarn_moq">
<span<?php echo $ww_yarn->moq->viewAttributes() ?>>
<?php echo $ww_yarn->moq->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ww_yarn->m_stock->Visible) { // m_stock ?>
		<td data-name="m_stock"<?php echo $ww_yarn->m_stock->cellAttributes() ?>>
<span id="el<?php echo $ww_yarn_list->RowCnt ?>_ww_yarn_m_stock" class="ww_yarn_m_stock">
<span<?php echo $ww_yarn->m_stock->viewAttributes() ?>>
<?php echo $ww_yarn->m_stock->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ww_yarn->required->Visible) { // required ?>
		<td data-name="required"<?php echo $ww_yarn->required->cellAttributes() ?>>
<span id="el<?php echo $ww_yarn_list->RowCnt ?>_ww_yarn_required" class="ww_yarn_required">
<span<?php echo $ww_yarn->required->viewAttributes() ?>>
<?php echo $ww_yarn->required->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ww_yarn->ordered->Visible) { // ordered ?>
		<td data-name="ordered"<?php echo $ww_yarn->ordered->cellAttributes() ?>>
<span id="el<?php echo $ww_yarn_list->RowCnt ?>_ww_yarn_ordered" class="ww_yarn_ordered">
<span<?php echo $ww_yarn->ordered->viewAttributes() ?>>
<?php echo $ww_yarn->ordered->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
	<?php if ($ww_yarn->pending_order->Visible) { // pending_order ?>
		<td data-name="pending_order"<?php echo $ww_yarn->pending_order->cellAttributes() ?>>
<span id="el<?php echo $ww_yarn_list->RowCnt ?>_ww_yarn_pending_order" class="ww_yarn_pending_order">
<span<?php echo $ww_yarn->pending_order->viewAttributes() ?>>
<?php echo $ww_yarn->pending_order->getViewValue() ?></span>
</span>
</td>
	<?php } ?>
<?php

// Render list options (body, right)
$ww_yarn_list->ListOptions->render("body", "right", $ww_yarn_list->RowCnt);
?>
	</tr>
<?php
	}
	if (!$ww_yarn->isGridAdd())
		$ww_yarn_list->Recordset->moveNext();
}
?>
</tbody>
</table><!-- /.ew-table -->
<?php } ?>
<?php if (!$ww_yarn->CurrentAction) { ?>
<input type="hidden" name="action" id="action" value="">
<?php } ?>
</div><!-- /.ew-grid-middle-panel -->
</form><!-- /.ew-list-form -->
<?php

// Close recordset
if ($ww_yarn_list->Recordset)
	$ww_yarn_list->Recordset->Close();
?>
<?php if (!$ww_yarn->isExport()) { ?>
<div class="card-footer ew-grid-lower-panel">
<?php if (!$ww_yarn->isGridAdd()) { ?>
<form name="ew-pager-form" class="form-inline ew-form ew-pager-form" action="<?php echo CurrentPageName() ?>">
<?php if (!isset($ww_yarn_list->Pager)) $ww_yarn_list->Pager = new PrevNextPager($ww_yarn_list->StartRec, $ww_yarn_list->DisplayRecs, $ww_yarn_list->TotalRecs, $ww_yarn_list->AutoHidePager) ?>
<?php if ($ww_yarn_list->Pager->RecordCount > 0 && $ww_yarn_list->Pager->Visible) { ?>
<div class="ew-pager">
<span><?php echo $Language->Phrase("Page") ?>&nbsp;</span>
<div class="ew-prev-next"><div class="input-group input-group-sm">
<div class="input-group-prepend">
<!-- first page button -->
	<?php if ($ww_yarn_list->Pager->FirstButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerFirst") ?>" href="<?php echo $ww_yarn_list->pageUrl() ?>start=<?php echo $ww_yarn_list->Pager->FirstButton->Start ?>"><i class="icon-first ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerFirst") ?>"><i class="icon-first ew-icon"></i></a>
	<?php } ?>
<!-- previous page button -->
	<?php if ($ww_yarn_list->Pager->PrevButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerPrevious") ?>" href="<?php echo $ww_yarn_list->pageUrl() ?>start=<?php echo $ww_yarn_list->Pager->PrevButton->Start ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerPrevious") ?>"><i class="icon-prev ew-icon"></i></a>
	<?php } ?>
</div>
<!-- current page number -->
	<input class="form-control" type="text" name="<?php echo TABLE_PAGE_NO ?>" value="<?php echo $ww_yarn_list->Pager->CurrentPage ?>">
<div class="input-group-append">
<!-- next page button -->
	<?php if ($ww_yarn_list->Pager->NextButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerNext") ?>" href="<?php echo $ww_yarn_list->pageUrl() ?>start=<?php echo $ww_yarn_list->Pager->NextButton->Start ?>"><i class="icon-next ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerNext") ?>"><i class="icon-next ew-icon"></i></a>
	<?php } ?>
<!-- last page button -->
	<?php if ($ww_yarn_list->Pager->LastButton->Enabled) { ?>
	<a class="btn btn-default" title="<?php echo $Language->phrase("PagerLast") ?>" href="<?php echo $ww_yarn_list->pageUrl() ?>start=<?php echo $ww_yarn_list->Pager->LastButton->Start ?>"><i class="icon-last ew-icon"></i></a>
	<?php } else { ?>
	<a class="btn btn-default disabled" title="<?php echo $Language->phrase("PagerLast") ?>"><i class="icon-last ew-icon"></i></a>
	<?php } ?>
</div>
</div>
</div>
<span>&nbsp;<?php echo $Language->Phrase("of") ?>&nbsp;<?php echo $ww_yarn_list->Pager->PageCount ?></span>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php if ($ww_yarn_list->Pager->RecordCount > 0) { ?>
<div class="ew-pager ew-rec">
	<span><?php echo $Language->Phrase("Record") ?>&nbsp;<?php echo $ww_yarn_list->Pager->FromIndex ?>&nbsp;<?php echo $Language->Phrase("To") ?>&nbsp;<?php echo $ww_yarn_list->Pager->ToIndex ?>&nbsp;<?php echo $Language->Phrase("Of") ?>&nbsp;<?php echo $ww_yarn_list->Pager->RecordCount ?></span>
</div>
<?php } ?>
<?php if ($ww_yarn_list->TotalRecs > 0 && (!$ww_yarn_list->AutoHidePageSizeSelector || $ww_yarn_list->Pager->Visible)) { ?>
<div class="ew-pager">
<input type="hidden" name="t" value="ww_yarn">
<select name="<?php echo TABLE_REC_PER_PAGE ?>" class="form-control form-control-sm ew-tooltip" title="<?php echo $Language->phrase("RecordsPerPage") ?>" onchange="this.form.submit();">
<option value="10"<?php if ($ww_yarn_list->DisplayRecs == 10) { ?> selected<?php } ?>>10</option>
<option value="20"<?php if ($ww_yarn_list->DisplayRecs == 20) { ?> selected<?php } ?>>20</option>
<option value="50"<?php if ($ww_yarn_list->DisplayRecs == 50) { ?> selected<?php } ?>>50</option>
<option value="100"<?php if ($ww_yarn_list->DisplayRecs == 100) { ?> selected<?php } ?>>100</option>
<option value="250"<?php if ($ww_yarn_list->DisplayRecs == 250) { ?> selected<?php } ?>>250</option>
<option value="ALL"<?php if ($ww_yarn->getRecordsPerPage() == -1) { ?> selected<?php } ?>><?php echo $Language->Phrase("AllRecords") ?></option>
</select>
</div>
<?php } ?>
</form>
<?php } ?>
<div class="ew-list-other-options">
<?php $ww_yarn_list->OtherOptions->render("body", "bottom") ?>
</div>
<div class="clearfix"></div>
</div>
<?php } ?>
</div><!-- /.ew-grid -->
<?php } ?>
<?php if ($ww_yarn_list->TotalRecs == 0 && !$ww_yarn->CurrentAction) { // Show other options ?>
<div class="ew-list-other-options">
<?php $ww_yarn_list->OtherOptions->render("body") ?>
</div>
<div class="clearfix"></div>
<?php } ?>
<?php
$ww_yarn_list->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$ww_yarn->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php if (!$ww_yarn->isExport()) { ?>
<script>
ew.scrollableTable("gmp_ww_yarn", "100%", "500px");
</script>
<?php } ?>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$ww_yarn_list->terminate();
?>