<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$ww_yarn_search = new ww_yarn_search();

// Run the page
$ww_yarn_search->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$ww_yarn_search->Page_Render();
?>
<?php include_once "header.php" ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "search";
<?php if ($ww_yarn_search->IsModal) { ?>
var fww_yarnsearch = currentAdvancedSearchForm = new ew.Form("fww_yarnsearch", "search");
<?php } else { ?>
var fww_yarnsearch = currentForm = new ew.Form("fww_yarnsearch", "search");
<?php } ?>

// Form_CustomValidate event
fww_yarnsearch.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fww_yarnsearch.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fww_yarnsearch.lists["x_yarn"] = <?php echo $ww_yarn_search->yarn->Lookup->toClientList() ?>;
fww_yarnsearch.lists["x_yarn"].options = <?php echo JsonEncode($ww_yarn_search->yarn->lookupOptions()) ?>;
fww_yarnsearch.lists["x_ply_1_color"] = <?php echo $ww_yarn_search->ply_1_color->Lookup->toClientList() ?>;
fww_yarnsearch.lists["x_ply_1_color"].options = <?php echo JsonEncode($ww_yarn_search->ply_1_color->lookupOptions()) ?>;
fww_yarnsearch.lists["x_ply_2_color"] = <?php echo $ww_yarn_search->ply_2_color->Lookup->toClientList() ?>;
fww_yarnsearch.lists["x_ply_2_color"].options = <?php echo JsonEncode($ww_yarn_search->ply_2_color->lookupOptions()) ?>;
fww_yarnsearch.lists["x_ply_3_color"] = <?php echo $ww_yarn_search->ply_3_color->Lookup->toClientList() ?>;
fww_yarnsearch.lists["x_ply_3_color"].options = <?php echo JsonEncode($ww_yarn_search->ply_3_color->lookupOptions()) ?>;

// Form object for search
// Validate function for search

fww_yarnsearch.validate = function(fobj) {
	if (!this.validateRequired)
		return true; // Ignore validation
	fobj = fobj || this._form;
	var infix = "";
	elm = this.getElements("x" + infix + "_ply_1_qty");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($ww_yarn->ply_1_qty->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_ply_2_qty");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($ww_yarn->ply_2_qty->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_ply_3_qty");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($ww_yarn->ply_3_qty->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_stock");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($ww_yarn->stock->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_operator");
	if (elm && !ew.checkInteger(elm.value))
		return this.onError(elm, "<?php echo JsEncode($ww_yarn->operator->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_datetime");
	if (elm && !ew.checkDateDef(elm.value))
		return this.onError(elm, "<?php echo JsEncode($ww_yarn->datetime->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_moq");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($ww_yarn->moq->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_m_stock");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($ww_yarn->m_stock->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_required");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($ww_yarn->required->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_ordered");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($ww_yarn->ordered->errorMessage()) ?>");
	elm = this.getElements("x" + infix + "_pending_order");
	if (elm && !ew.checkNumber(elm.value))
		return this.onError(elm, "<?php echo JsEncode($ww_yarn->pending_order->errorMessage()) ?>");

	// Fire Form_CustomValidate event
	if (!this.Form_CustomValidate(fobj))
		return false;
	return true;
}
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php $ww_yarn_search->showPageHeader(); ?>
<?php
$ww_yarn_search->showMessage();
?>
<form name="fww_yarnsearch" id="fww_yarnsearch" class="<?php echo $ww_yarn_search->FormClassName ?>" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($ww_yarn_search->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $ww_yarn_search->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="ww_yarn">
<input type="hidden" name="action" id="action" value="search">
<input type="hidden" name="modal" value="<?php echo (int)$ww_yarn_search->IsModal ?>">
<div class="ew-search-div"><!-- page* -->
<?php if ($ww_yarn->id->Visible) { // id ?>
	<div id="r_id" class="form-group row">
		<label for="x_id" class="<?php echo $ww_yarn_search->LeftColumnClass ?>"><span id="elh_ww_yarn_id"><?php echo $ww_yarn->id->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_id" id="z_id" value="LIKE"></span>
		</label>
		<div class="<?php echo $ww_yarn_search->RightColumnClass ?>"><div<?php echo $ww_yarn->id->cellAttributes() ?>>
			<span id="el_ww_yarn_id">
<input type="text" data-table="ww_yarn" data-field="x_id" name="x_id" id="x_id" size="30" maxlength="255" placeholder="<?php echo HtmlEncode($ww_yarn->id->getPlaceHolder()) ?>" value="<?php echo $ww_yarn->id->EditValue ?>"<?php echo $ww_yarn->id->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ww_yarn->yarn->Visible) { // yarn ?>
	<div id="r_yarn" class="form-group row">
		<label for="x_yarn" class="<?php echo $ww_yarn_search->LeftColumnClass ?>"><span id="elh_ww_yarn_yarn"><?php echo $ww_yarn->yarn->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("LIKE") ?><input type="hidden" name="z_yarn" id="z_yarn" value="LIKE"></span>
		</label>
		<div class="<?php echo $ww_yarn_search->RightColumnClass ?>"><div<?php echo $ww_yarn->yarn->cellAttributes() ?>>
			<span id="el_ww_yarn_yarn">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ww_yarn" data-field="x_yarn" data-value-separator="<?php echo $ww_yarn->yarn->displayValueSeparatorAttribute() ?>" id="x_yarn" name="x_yarn"<?php echo $ww_yarn->yarn->editAttributes() ?>>
		<?php echo $ww_yarn->yarn->selectOptionListHtml("x_yarn") ?>
	</select>
</div>
<?php echo $ww_yarn->yarn->Lookup->getParamTag("p_x_yarn") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ww_yarn->ply_1_color->Visible) { // ply_1_color ?>
	<div id="r_ply_1_color" class="form-group row">
		<label for="x_ply_1_color" class="<?php echo $ww_yarn_search->LeftColumnClass ?>"><span id="elh_ww_yarn_ply_1_color"><?php echo $ww_yarn->ply_1_color->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ply_1_color" id="z_ply_1_color" value="="></span>
		</label>
		<div class="<?php echo $ww_yarn_search->RightColumnClass ?>"><div<?php echo $ww_yarn->ply_1_color->cellAttributes() ?>>
			<span id="el_ww_yarn_ply_1_color">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ww_yarn" data-field="x_ply_1_color" data-value-separator="<?php echo $ww_yarn->ply_1_color->displayValueSeparatorAttribute() ?>" id="x_ply_1_color" name="x_ply_1_color"<?php echo $ww_yarn->ply_1_color->editAttributes() ?>>
		<?php echo $ww_yarn->ply_1_color->selectOptionListHtml("x_ply_1_color") ?>
	</select>
</div>
<?php echo $ww_yarn->ply_1_color->Lookup->getParamTag("p_x_ply_1_color") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ww_yarn->ply_1_qty->Visible) { // ply_1_qty ?>
	<div id="r_ply_1_qty" class="form-group row">
		<label for="x_ply_1_qty" class="<?php echo $ww_yarn_search->LeftColumnClass ?>"><span id="elh_ww_yarn_ply_1_qty"><?php echo $ww_yarn->ply_1_qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ply_1_qty" id="z_ply_1_qty" value="="></span>
		</label>
		<div class="<?php echo $ww_yarn_search->RightColumnClass ?>"><div<?php echo $ww_yarn->ply_1_qty->cellAttributes() ?>>
			<span id="el_ww_yarn_ply_1_qty">
<input type="text" data-table="ww_yarn" data-field="x_ply_1_qty" name="x_ply_1_qty" id="x_ply_1_qty" size="30" placeholder="<?php echo HtmlEncode($ww_yarn->ply_1_qty->getPlaceHolder()) ?>" value="<?php echo $ww_yarn->ply_1_qty->EditValue ?>"<?php echo $ww_yarn->ply_1_qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ww_yarn->ply_2_color->Visible) { // ply_2_color ?>
	<div id="r_ply_2_color" class="form-group row">
		<label for="x_ply_2_color" class="<?php echo $ww_yarn_search->LeftColumnClass ?>"><span id="elh_ww_yarn_ply_2_color"><?php echo $ww_yarn->ply_2_color->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ply_2_color" id="z_ply_2_color" value="="></span>
		</label>
		<div class="<?php echo $ww_yarn_search->RightColumnClass ?>"><div<?php echo $ww_yarn->ply_2_color->cellAttributes() ?>>
			<span id="el_ww_yarn_ply_2_color">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ww_yarn" data-field="x_ply_2_color" data-value-separator="<?php echo $ww_yarn->ply_2_color->displayValueSeparatorAttribute() ?>" id="x_ply_2_color" name="x_ply_2_color"<?php echo $ww_yarn->ply_2_color->editAttributes() ?>>
		<?php echo $ww_yarn->ply_2_color->selectOptionListHtml("x_ply_2_color") ?>
	</select>
</div>
<?php echo $ww_yarn->ply_2_color->Lookup->getParamTag("p_x_ply_2_color") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ww_yarn->ply_2_qty->Visible) { // ply_2_qty ?>
	<div id="r_ply_2_qty" class="form-group row">
		<label for="x_ply_2_qty" class="<?php echo $ww_yarn_search->LeftColumnClass ?>"><span id="elh_ww_yarn_ply_2_qty"><?php echo $ww_yarn->ply_2_qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ply_2_qty" id="z_ply_2_qty" value="="></span>
		</label>
		<div class="<?php echo $ww_yarn_search->RightColumnClass ?>"><div<?php echo $ww_yarn->ply_2_qty->cellAttributes() ?>>
			<span id="el_ww_yarn_ply_2_qty">
<input type="text" data-table="ww_yarn" data-field="x_ply_2_qty" name="x_ply_2_qty" id="x_ply_2_qty" size="30" placeholder="<?php echo HtmlEncode($ww_yarn->ply_2_qty->getPlaceHolder()) ?>" value="<?php echo $ww_yarn->ply_2_qty->EditValue ?>"<?php echo $ww_yarn->ply_2_qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ww_yarn->ply_3_color->Visible) { // ply_3_color ?>
	<div id="r_ply_3_color" class="form-group row">
		<label for="x_ply_3_color" class="<?php echo $ww_yarn_search->LeftColumnClass ?>"><span id="elh_ww_yarn_ply_3_color"><?php echo $ww_yarn->ply_3_color->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ply_3_color" id="z_ply_3_color" value="="></span>
		</label>
		<div class="<?php echo $ww_yarn_search->RightColumnClass ?>"><div<?php echo $ww_yarn->ply_3_color->cellAttributes() ?>>
			<span id="el_ww_yarn_ply_3_color">
<div class="input-group">
	<select class="custom-select ew-custom-select" data-table="ww_yarn" data-field="x_ply_3_color" data-value-separator="<?php echo $ww_yarn->ply_3_color->displayValueSeparatorAttribute() ?>" id="x_ply_3_color" name="x_ply_3_color"<?php echo $ww_yarn->ply_3_color->editAttributes() ?>>
		<?php echo $ww_yarn->ply_3_color->selectOptionListHtml("x_ply_3_color") ?>
	</select>
</div>
<?php echo $ww_yarn->ply_3_color->Lookup->getParamTag("p_x_ply_3_color") ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ww_yarn->ply_3_qty->Visible) { // ply_3_qty ?>
	<div id="r_ply_3_qty" class="form-group row">
		<label for="x_ply_3_qty" class="<?php echo $ww_yarn_search->LeftColumnClass ?>"><span id="elh_ww_yarn_ply_3_qty"><?php echo $ww_yarn->ply_3_qty->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ply_3_qty" id="z_ply_3_qty" value="="></span>
		</label>
		<div class="<?php echo $ww_yarn_search->RightColumnClass ?>"><div<?php echo $ww_yarn->ply_3_qty->cellAttributes() ?>>
			<span id="el_ww_yarn_ply_3_qty">
<input type="text" data-table="ww_yarn" data-field="x_ply_3_qty" name="x_ply_3_qty" id="x_ply_3_qty" size="30" placeholder="<?php echo HtmlEncode($ww_yarn->ply_3_qty->getPlaceHolder()) ?>" value="<?php echo $ww_yarn->ply_3_qty->EditValue ?>"<?php echo $ww_yarn->ply_3_qty->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ww_yarn->stock->Visible) { // stock ?>
	<div id="r_stock" class="form-group row">
		<label for="x_stock" class="<?php echo $ww_yarn_search->LeftColumnClass ?>"><span id="elh_ww_yarn_stock"><?php echo $ww_yarn->stock->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_stock" id="z_stock" value="="></span>
		</label>
		<div class="<?php echo $ww_yarn_search->RightColumnClass ?>"><div<?php echo $ww_yarn->stock->cellAttributes() ?>>
			<span id="el_ww_yarn_stock">
<input type="text" data-table="ww_yarn" data-field="x_stock" name="x_stock" id="x_stock" size="30" placeholder="<?php echo HtmlEncode($ww_yarn->stock->getPlaceHolder()) ?>" value="<?php echo $ww_yarn->stock->EditValue ?>"<?php echo $ww_yarn->stock->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ww_yarn->operator->Visible) { // operator ?>
	<div id="r_operator" class="form-group row">
		<label for="x_operator" class="<?php echo $ww_yarn_search->LeftColumnClass ?>"><span id="elh_ww_yarn_operator"><?php echo $ww_yarn->operator->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_operator" id="z_operator" value="="></span>
		</label>
		<div class="<?php echo $ww_yarn_search->RightColumnClass ?>"><div<?php echo $ww_yarn->operator->cellAttributes() ?>>
			<span id="el_ww_yarn_operator">
<input type="text" data-table="ww_yarn" data-field="x_operator" name="x_operator" id="x_operator" size="30" placeholder="<?php echo HtmlEncode($ww_yarn->operator->getPlaceHolder()) ?>" value="<?php echo $ww_yarn->operator->EditValue ?>"<?php echo $ww_yarn->operator->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ww_yarn->datetime->Visible) { // datetime ?>
	<div id="r_datetime" class="form-group row">
		<label for="x_datetime" class="<?php echo $ww_yarn_search->LeftColumnClass ?>"><span id="elh_ww_yarn_datetime"><?php echo $ww_yarn->datetime->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_datetime" id="z_datetime" value="="></span>
		</label>
		<div class="<?php echo $ww_yarn_search->RightColumnClass ?>"><div<?php echo $ww_yarn->datetime->cellAttributes() ?>>
			<span id="el_ww_yarn_datetime">
<input type="text" data-table="ww_yarn" data-field="x_datetime" name="x_datetime" id="x_datetime" placeholder="<?php echo HtmlEncode($ww_yarn->datetime->getPlaceHolder()) ?>" value="<?php echo $ww_yarn->datetime->EditValue ?>"<?php echo $ww_yarn->datetime->editAttributes() ?>>
<?php if (!$ww_yarn->datetime->ReadOnly && !$ww_yarn->datetime->Disabled && !isset($ww_yarn->datetime->EditAttrs["readonly"]) && !isset($ww_yarn->datetime->EditAttrs["disabled"])) { ?>
<script>
ew.createDateTimePicker("fww_yarnsearch", "x_datetime", {"ignoreReadonly":true,"useCurrent":false,"format":0});
</script>
<?php } ?>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ww_yarn->moq->Visible) { // moq ?>
	<div id="r_moq" class="form-group row">
		<label for="x_moq" class="<?php echo $ww_yarn_search->LeftColumnClass ?>"><span id="elh_ww_yarn_moq"><?php echo $ww_yarn->moq->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_moq" id="z_moq" value="="></span>
		</label>
		<div class="<?php echo $ww_yarn_search->RightColumnClass ?>"><div<?php echo $ww_yarn->moq->cellAttributes() ?>>
			<span id="el_ww_yarn_moq">
<input type="text" data-table="ww_yarn" data-field="x_moq" name="x_moq" id="x_moq" size="30" placeholder="<?php echo HtmlEncode($ww_yarn->moq->getPlaceHolder()) ?>" value="<?php echo $ww_yarn->moq->EditValue ?>"<?php echo $ww_yarn->moq->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ww_yarn->m_stock->Visible) { // m_stock ?>
	<div id="r_m_stock" class="form-group row">
		<label for="x_m_stock" class="<?php echo $ww_yarn_search->LeftColumnClass ?>"><span id="elh_ww_yarn_m_stock"><?php echo $ww_yarn->m_stock->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_m_stock" id="z_m_stock" value="="></span>
		</label>
		<div class="<?php echo $ww_yarn_search->RightColumnClass ?>"><div<?php echo $ww_yarn->m_stock->cellAttributes() ?>>
			<span id="el_ww_yarn_m_stock">
<input type="text" data-table="ww_yarn" data-field="x_m_stock" name="x_m_stock" id="x_m_stock" size="30" placeholder="<?php echo HtmlEncode($ww_yarn->m_stock->getPlaceHolder()) ?>" value="<?php echo $ww_yarn->m_stock->EditValue ?>"<?php echo $ww_yarn->m_stock->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ww_yarn->required->Visible) { // required ?>
	<div id="r_required" class="form-group row">
		<label for="x_required" class="<?php echo $ww_yarn_search->LeftColumnClass ?>"><span id="elh_ww_yarn_required"><?php echo $ww_yarn->required->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_required" id="z_required" value="="></span>
		</label>
		<div class="<?php echo $ww_yarn_search->RightColumnClass ?>"><div<?php echo $ww_yarn->required->cellAttributes() ?>>
			<span id="el_ww_yarn_required">
<input type="text" data-table="ww_yarn" data-field="x_required" name="x_required" id="x_required" size="30" placeholder="<?php echo HtmlEncode($ww_yarn->required->getPlaceHolder()) ?>" value="<?php echo $ww_yarn->required->EditValue ?>"<?php echo $ww_yarn->required->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ww_yarn->ordered->Visible) { // ordered ?>
	<div id="r_ordered" class="form-group row">
		<label for="x_ordered" class="<?php echo $ww_yarn_search->LeftColumnClass ?>"><span id="elh_ww_yarn_ordered"><?php echo $ww_yarn->ordered->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_ordered" id="z_ordered" value="="></span>
		</label>
		<div class="<?php echo $ww_yarn_search->RightColumnClass ?>"><div<?php echo $ww_yarn->ordered->cellAttributes() ?>>
			<span id="el_ww_yarn_ordered">
<input type="text" data-table="ww_yarn" data-field="x_ordered" name="x_ordered" id="x_ordered" size="30" placeholder="<?php echo HtmlEncode($ww_yarn->ordered->getPlaceHolder()) ?>" value="<?php echo $ww_yarn->ordered->EditValue ?>"<?php echo $ww_yarn->ordered->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
<?php if ($ww_yarn->pending_order->Visible) { // pending_order ?>
	<div id="r_pending_order" class="form-group row">
		<label for="x_pending_order" class="<?php echo $ww_yarn_search->LeftColumnClass ?>"><span id="elh_ww_yarn_pending_order"><?php echo $ww_yarn->pending_order->caption() ?></span>
		<span class="ew-search-operator"><?php echo $Language->phrase("=") ?><input type="hidden" name="z_pending_order" id="z_pending_order" value="="></span>
		</label>
		<div class="<?php echo $ww_yarn_search->RightColumnClass ?>"><div<?php echo $ww_yarn->pending_order->cellAttributes() ?>>
			<span id="el_ww_yarn_pending_order">
<input type="text" data-table="ww_yarn" data-field="x_pending_order" name="x_pending_order" id="x_pending_order" size="30" placeholder="<?php echo HtmlEncode($ww_yarn->pending_order->getPlaceHolder()) ?>" value="<?php echo $ww_yarn->pending_order->EditValue ?>"<?php echo $ww_yarn->pending_order->editAttributes() ?>>
</span>
		</div></div>
	</div>
<?php } ?>
</div><!-- /page* -->
<?php if (!$ww_yarn_search->IsModal) { ?>
<div class="form-group row"><!-- buttons .form-group -->
	<div class="<?php echo $ww_yarn_search->OffsetColumnClass ?>"><!-- buttons offset -->
<button class="btn btn-primary ew-btn" name="btn-action" id="btn-action" type="submit"><?php echo $Language->phrase("Search") ?></button>
<button class="btn btn-default ew-btn" name="btn-reset" id="btn-reset" type="button" onclick="ew.clearForm(this.form);"><?php echo $Language->phrase("Reset") ?></button>
	</div><!-- /buttons offset -->
</div><!-- /buttons .form-group -->
<?php } ?>
</form>
<?php
$ww_yarn_search->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php include_once "footer.php" ?>
<?php
$ww_yarn_search->terminate();
?>