<?php
namespace PHPMaker2019\fibre;

// Session
if (session_status() !== PHP_SESSION_ACTIVE)
	session_start(); // Init session data

// Output buffering
ob_start(); 

// Autoload
include_once "autoload.php";
?>
<?php

// Write header
WriteHeader(FALSE);

// Create page object
$ww_yarn_view = new ww_yarn_view();

// Run the page
$ww_yarn_view->run();

// Setup login status
SetupLoginStatus();
SetClientVar("login", LoginStatus());

// Global Page Rendering event (in userfn*.php)
Page_Rendering();

// Page Rendering event
$ww_yarn_view->Page_Render();
?>
<?php include_once "header.php" ?>
<?php if (!$ww_yarn->isExport()) { ?>
<script>

// Form object
currentPageID = ew.PAGE_ID = "view";
var fww_yarnview = currentForm = new ew.Form("fww_yarnview", "view");

// Form_CustomValidate event
fww_yarnview.Form_CustomValidate = function(fobj) { // DO NOT CHANGE THIS LINE!

	// Your custom validation code here, return false if invalid.
	return true;
}

// Use JavaScript validation or not
fww_yarnview.validateRequired = <?php echo json_encode(CLIENT_VALIDATE) ?>;

// Dynamic selection lists
fww_yarnview.lists["x_yarn"] = <?php echo $ww_yarn_view->yarn->Lookup->toClientList() ?>;
fww_yarnview.lists["x_yarn"].options = <?php echo JsonEncode($ww_yarn_view->yarn->lookupOptions()) ?>;
fww_yarnview.lists["x_ply_1_color"] = <?php echo $ww_yarn_view->ply_1_color->Lookup->toClientList() ?>;
fww_yarnview.lists["x_ply_1_color"].options = <?php echo JsonEncode($ww_yarn_view->ply_1_color->lookupOptions()) ?>;
fww_yarnview.lists["x_ply_2_color"] = <?php echo $ww_yarn_view->ply_2_color->Lookup->toClientList() ?>;
fww_yarnview.lists["x_ply_2_color"].options = <?php echo JsonEncode($ww_yarn_view->ply_2_color->lookupOptions()) ?>;
fww_yarnview.lists["x_ply_3_color"] = <?php echo $ww_yarn_view->ply_3_color->Lookup->toClientList() ?>;
fww_yarnview.lists["x_ply_3_color"].options = <?php echo JsonEncode($ww_yarn_view->ply_3_color->lookupOptions()) ?>;

// Form object for search
</script>
<script>

// Write your client script here, no need to add script tags.
</script>
<?php } ?>
<?php if (!$ww_yarn->isExport()) { ?>
<div class="btn-toolbar ew-toolbar">
<?php $ww_yarn_view->ExportOptions->render("body") ?>
<?php $ww_yarn_view->OtherOptions->render("body") ?>
<div class="clearfix"></div>
</div>
<?php } ?>
<?php $ww_yarn_view->showPageHeader(); ?>
<?php
$ww_yarn_view->showMessage();
?>
<form name="fww_yarnview" id="fww_yarnview" class="form-inline ew-form ew-view-form" action="<?php echo CurrentPageName() ?>" method="post">
<?php if ($ww_yarn_view->CheckToken) { ?>
<input type="hidden" name="<?php echo TOKEN_NAME ?>" value="<?php echo $ww_yarn_view->Token ?>">
<?php } ?>
<input type="hidden" name="t" value="ww_yarn">
<input type="hidden" name="modal" value="<?php echo (int)$ww_yarn_view->IsModal ?>">
<table class="table table-striped table-sm ew-view-table">
<?php if ($ww_yarn->id->Visible) { // id ?>
	<tr id="r_id">
		<td class="<?php echo $ww_yarn_view->TableLeftColumnClass ?>"><span id="elh_ww_yarn_id"><?php echo $ww_yarn->id->caption() ?></span></td>
		<td data-name="id"<?php echo $ww_yarn->id->cellAttributes() ?>>
<span id="el_ww_yarn_id">
<span<?php echo $ww_yarn->id->viewAttributes() ?>>
<?php echo $ww_yarn->id->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ww_yarn->yarn->Visible) { // yarn ?>
	<tr id="r_yarn">
		<td class="<?php echo $ww_yarn_view->TableLeftColumnClass ?>"><span id="elh_ww_yarn_yarn"><?php echo $ww_yarn->yarn->caption() ?></span></td>
		<td data-name="yarn"<?php echo $ww_yarn->yarn->cellAttributes() ?>>
<span id="el_ww_yarn_yarn">
<span<?php echo $ww_yarn->yarn->viewAttributes() ?>>
<?php echo $ww_yarn->yarn->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ww_yarn->ply_1_color->Visible) { // ply_1_color ?>
	<tr id="r_ply_1_color">
		<td class="<?php echo $ww_yarn_view->TableLeftColumnClass ?>"><span id="elh_ww_yarn_ply_1_color"><?php echo $ww_yarn->ply_1_color->caption() ?></span></td>
		<td data-name="ply_1_color"<?php echo $ww_yarn->ply_1_color->cellAttributes() ?>>
<span id="el_ww_yarn_ply_1_color">
<span<?php echo $ww_yarn->ply_1_color->viewAttributes() ?>>
<?php echo $ww_yarn->ply_1_color->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ww_yarn->ply_1_qty->Visible) { // ply_1_qty ?>
	<tr id="r_ply_1_qty">
		<td class="<?php echo $ww_yarn_view->TableLeftColumnClass ?>"><span id="elh_ww_yarn_ply_1_qty"><?php echo $ww_yarn->ply_1_qty->caption() ?></span></td>
		<td data-name="ply_1_qty"<?php echo $ww_yarn->ply_1_qty->cellAttributes() ?>>
<span id="el_ww_yarn_ply_1_qty">
<span<?php echo $ww_yarn->ply_1_qty->viewAttributes() ?>>
<?php echo $ww_yarn->ply_1_qty->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ww_yarn->ply_2_color->Visible) { // ply_2_color ?>
	<tr id="r_ply_2_color">
		<td class="<?php echo $ww_yarn_view->TableLeftColumnClass ?>"><span id="elh_ww_yarn_ply_2_color"><?php echo $ww_yarn->ply_2_color->caption() ?></span></td>
		<td data-name="ply_2_color"<?php echo $ww_yarn->ply_2_color->cellAttributes() ?>>
<span id="el_ww_yarn_ply_2_color">
<span<?php echo $ww_yarn->ply_2_color->viewAttributes() ?>>
<?php echo $ww_yarn->ply_2_color->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ww_yarn->ply_2_qty->Visible) { // ply_2_qty ?>
	<tr id="r_ply_2_qty">
		<td class="<?php echo $ww_yarn_view->TableLeftColumnClass ?>"><span id="elh_ww_yarn_ply_2_qty"><?php echo $ww_yarn->ply_2_qty->caption() ?></span></td>
		<td data-name="ply_2_qty"<?php echo $ww_yarn->ply_2_qty->cellAttributes() ?>>
<span id="el_ww_yarn_ply_2_qty">
<span<?php echo $ww_yarn->ply_2_qty->viewAttributes() ?>>
<?php echo $ww_yarn->ply_2_qty->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ww_yarn->ply_3_color->Visible) { // ply_3_color ?>
	<tr id="r_ply_3_color">
		<td class="<?php echo $ww_yarn_view->TableLeftColumnClass ?>"><span id="elh_ww_yarn_ply_3_color"><?php echo $ww_yarn->ply_3_color->caption() ?></span></td>
		<td data-name="ply_3_color"<?php echo $ww_yarn->ply_3_color->cellAttributes() ?>>
<span id="el_ww_yarn_ply_3_color">
<span<?php echo $ww_yarn->ply_3_color->viewAttributes() ?>>
<?php echo $ww_yarn->ply_3_color->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ww_yarn->ply_3_qty->Visible) { // ply_3_qty ?>
	<tr id="r_ply_3_qty">
		<td class="<?php echo $ww_yarn_view->TableLeftColumnClass ?>"><span id="elh_ww_yarn_ply_3_qty"><?php echo $ww_yarn->ply_3_qty->caption() ?></span></td>
		<td data-name="ply_3_qty"<?php echo $ww_yarn->ply_3_qty->cellAttributes() ?>>
<span id="el_ww_yarn_ply_3_qty">
<span<?php echo $ww_yarn->ply_3_qty->viewAttributes() ?>>
<?php echo $ww_yarn->ply_3_qty->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ww_yarn->stock->Visible) { // stock ?>
	<tr id="r_stock">
		<td class="<?php echo $ww_yarn_view->TableLeftColumnClass ?>"><span id="elh_ww_yarn_stock"><?php echo $ww_yarn->stock->caption() ?></span></td>
		<td data-name="stock"<?php echo $ww_yarn->stock->cellAttributes() ?>>
<span id="el_ww_yarn_stock">
<span<?php echo $ww_yarn->stock->viewAttributes() ?>>
<?php echo $ww_yarn->stock->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ww_yarn->operator->Visible) { // operator ?>
	<tr id="r_operator">
		<td class="<?php echo $ww_yarn_view->TableLeftColumnClass ?>"><span id="elh_ww_yarn_operator"><?php echo $ww_yarn->operator->caption() ?></span></td>
		<td data-name="operator"<?php echo $ww_yarn->operator->cellAttributes() ?>>
<span id="el_ww_yarn_operator">
<span<?php echo $ww_yarn->operator->viewAttributes() ?>>
<?php echo $ww_yarn->operator->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ww_yarn->datetime->Visible) { // datetime ?>
	<tr id="r_datetime">
		<td class="<?php echo $ww_yarn_view->TableLeftColumnClass ?>"><span id="elh_ww_yarn_datetime"><?php echo $ww_yarn->datetime->caption() ?></span></td>
		<td data-name="datetime"<?php echo $ww_yarn->datetime->cellAttributes() ?>>
<span id="el_ww_yarn_datetime">
<span<?php echo $ww_yarn->datetime->viewAttributes() ?>>
<?php echo $ww_yarn->datetime->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ww_yarn->moq->Visible) { // moq ?>
	<tr id="r_moq">
		<td class="<?php echo $ww_yarn_view->TableLeftColumnClass ?>"><span id="elh_ww_yarn_moq"><?php echo $ww_yarn->moq->caption() ?></span></td>
		<td data-name="moq"<?php echo $ww_yarn->moq->cellAttributes() ?>>
<span id="el_ww_yarn_moq">
<span<?php echo $ww_yarn->moq->viewAttributes() ?>>
<?php echo $ww_yarn->moq->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ww_yarn->m_stock->Visible) { // m_stock ?>
	<tr id="r_m_stock">
		<td class="<?php echo $ww_yarn_view->TableLeftColumnClass ?>"><span id="elh_ww_yarn_m_stock"><?php echo $ww_yarn->m_stock->caption() ?></span></td>
		<td data-name="m_stock"<?php echo $ww_yarn->m_stock->cellAttributes() ?>>
<span id="el_ww_yarn_m_stock">
<span<?php echo $ww_yarn->m_stock->viewAttributes() ?>>
<?php echo $ww_yarn->m_stock->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ww_yarn->required->Visible) { // required ?>
	<tr id="r_required">
		<td class="<?php echo $ww_yarn_view->TableLeftColumnClass ?>"><span id="elh_ww_yarn_required"><?php echo $ww_yarn->required->caption() ?></span></td>
		<td data-name="required"<?php echo $ww_yarn->required->cellAttributes() ?>>
<span id="el_ww_yarn_required">
<span<?php echo $ww_yarn->required->viewAttributes() ?>>
<?php echo $ww_yarn->required->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ww_yarn->ordered->Visible) { // ordered ?>
	<tr id="r_ordered">
		<td class="<?php echo $ww_yarn_view->TableLeftColumnClass ?>"><span id="elh_ww_yarn_ordered"><?php echo $ww_yarn->ordered->caption() ?></span></td>
		<td data-name="ordered"<?php echo $ww_yarn->ordered->cellAttributes() ?>>
<span id="el_ww_yarn_ordered">
<span<?php echo $ww_yarn->ordered->viewAttributes() ?>>
<?php echo $ww_yarn->ordered->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
<?php if ($ww_yarn->pending_order->Visible) { // pending_order ?>
	<tr id="r_pending_order">
		<td class="<?php echo $ww_yarn_view->TableLeftColumnClass ?>"><span id="elh_ww_yarn_pending_order"><?php echo $ww_yarn->pending_order->caption() ?></span></td>
		<td data-name="pending_order"<?php echo $ww_yarn->pending_order->cellAttributes() ?>>
<span id="el_ww_yarn_pending_order">
<span<?php echo $ww_yarn->pending_order->viewAttributes() ?>>
<?php echo $ww_yarn->pending_order->getViewValue() ?></span>
</span>
</td>
	</tr>
<?php } ?>
</table>
</form>
<?php
$ww_yarn_view->showPageFooter();
if (DEBUG_ENABLED)
	echo GetDebugMessage();
?>
<?php if (!$ww_yarn->isExport()) { ?>
<script>

// Write your table-specific startup script here
// document.write("page loaded");

</script>
<?php } ?>
<?php include_once "footer.php" ?>
<?php
$ww_yarn_view->terminate();
?>